#include "mex.h"
#include "matrix.h"
#include "math.h"
#include "stdio.h"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )

{

    /* -- Inputs -- */
	double *nin			= mxGetPr(prhs[0]);
	double *nxin		= mxGetPr(prhs[1]);
	double *nyin		= mxGetPr(prhs[2]);
    double *xss 		= mxGetPr(prhs[3]);
    double *yss 		= mxGetPr(prhs[4]);
	double *parmin 		= mxGetPr(prhs[5]);
	double *nnuin 		= mxGetPr(prhs[6]);
	double *Hs  		= mxGetPr(prhs[7]);
	double *Gs 			= mxGetPr(prhs[8]);
	double *Gsp 		= mxGetPr(prhs[9]);
	double *Psspin  	= mxGetPr(prhs[10]);
	double *dP1sspin	= mxGetPr(prhs[11]);
	double *dP2sspin	= mxGetPr(prhs[12]);

	/* -- Specific Inputs -- */
	int n 				= nin[0];
	int nx 				= nxin[0];
	int ny 				= nyin[0];
	double nnus 		= nnuin[0];
	double bbeta 		= parmin[0];
	double rrho 		= parmin[1];
	double oomega 		= parmin[2];
	double eeta 		= parmin[3];
	double aalpha 		= parmin[4];
	double ddelta 		= parmin[5];
	double pbar 		= parmin[6];
	double ebar 		= parmin[7];
	double iiota 		= parmin[8];
	double pphi 		= parmin[9];
	double rbar 		= parmin[10];
	double kkappa   	= parmin[11];
	double rrhoa 		= parmin[12];
	double rrhoz 		= parmin[13];
	double rrhop 		= parmin[14];
	double rrhor 		= parmin[15];
	double rrhoe 		= parmin[16];
	double rrhod 	 	= parmin[17];
	double varphibar 	= parmin[18];
	double bbar 		= parmin[19];
	double ppsir 		= parmin[20];
	double abar  		= parmin[21];
	double zbar 		= parmin[22];
	double Pssp 		= Psspin[0];
	double dP1ssp 		= dP1sspin[0];
	double dP2ssp 		= dP2sspin[0];

	/* -- Outputs -- */
	plhs[0] = mxCreateDoubleMatrix(n*nx*nx,(n+ny)*nx*nx,mxREAL);
	plhs[1] = mxCreateDoubleMatrix(n*nx*nx,1,mxREAL);
	double *Mxx_sp_s = mxGetPr(plhs[0]);
	double *Nxx_sp_s = mxGetPr(plhs[1]);

    /* -- Definition of Variables -- */
    double E = 2.71828182845905;


    /* -- Mathematica Output Here -- */
Nxx_sp_s[0]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*pow(Gs[0],2)) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*pow(Gs[1],2) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*pow(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1],2) - pow(E,yss[8])*Pssp*pow(Gs[8],2) - 2*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])*Hs[7] + (Pssp*pow(Hs[7],2))/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + 2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])) - pow(E,yss[8])*Gs[8] + Hs[7]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[1]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(eeta,2)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)) - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[1],2) + 2*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2] + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[2] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[2],2) - (2*pbar*pphi*Pssp*Gs[5]*Gs[9])/pow(E,yss[8]) - 2*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2] - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[2] + 2*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[2] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[2],2) - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[3] - 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[3] + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[3] - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[3] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[3],2) + (2*pbar*pphi*Pssp*Gs[8]*Gs[9]*(1 + yss[5]))/pow(E,yss[8]) + (2*pbar*pphi*Pssp*Gs[5]*Gs[8]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*pow(Gs[8],2)*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*pow(Hs[4],2)*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (2*pbar*pphi*Pssp*Hs[4]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8]) + 2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[1] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[2] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[2] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[3] - pbar*Hs[4]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[2]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(eeta,2)*Pssp*pow(zbar,aalpha) + 2*(-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[1] - pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*pow(Gs[1],2) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[1],2) - 2*aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2] - 2*(-1 + aalpha)*aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[2] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[2],2) - 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[9] + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[2] + 2*(-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[2] - 2*aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[2],2) + 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[3] + 2*(-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[3] - 2*pow(aalpha,2)*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[3] + 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[3] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[3],2) + 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[9]*(1 + yss[5]) + 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[8]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*pow(Gs[8],2)*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*pow(Gs[7],2)*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[7]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])) + 2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha) - pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[1] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] - pow(E,yss[7])*pphi*Gs[7]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])));
	Nxx_sp_s[3]=-(pow(E,yss[8])*Pssp*pow(Gs[8],2)) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[5]*Hs[3])/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gs[5]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(Hs[3],2)*(1 + yss[5]))/pow(zbar,rrho) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[3]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7],2)*(1 + yss[5]))/pow(zbar,rrho) + 2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*((bbeta*pow(E,yss[8])*Gs[5])/pow(zbar,rrho) - pow(E,yss[8])*Gs[8] + Gs[9] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[3]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[4]=-(pow(E,yss[8])*iiota*Pssp*zbar) + pow(E,yss[8])*Pssp*pow(Gs[8],2) - 2*kkappa*Pssp*Gs[6]*Gs[9] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[0],2) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[0],2) - 2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[0]*Hs[2] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*pow(Hs[2],2) - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[0]*Hs[3] - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[2]*Hs[3] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*pow(Hs[3],2) - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*pow(Hs[3],2))/pow(zbar,rrho) - 2*pow(E,yss[8])*iiota*Pssp*zbar*(-1 + Hs[0] + Hs[3]) + 2*pow(E,yss[8])*iiota*Pssp*zbar*Gs[8]*(-1 + Hs[0] + Hs[3]) + pow(E,yss[8])*iiota*Pssp*zbar*pow(Hs[0] + Hs[3],2) - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - 2*pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7],2) + 2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + 2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*pow(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7],2) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7],2) + 2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7],2) + (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*pow(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7],2))/pow(zbar,rrho) + (2*bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[3]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])))/pow(zbar,rrho) - (2*bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])))/pow(zbar,rrho) - kkappa*Pssp*pow(Gs[6],2)*yss[9] + 2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[8])*Gs[8] - kkappa*Gs[9] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(-1 + Hs[0] + Hs[3]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])))/pow(zbar,rrho) - kkappa*Gs[6]*yss[9]);
	Nxx_sp_s[5]=-(iiota*Pssp*zbar) - Pssp*pow(Gs[6],2) + 2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-Gs[6] + iiota*zbar*Hs[0] + iiota*zbar*(-1 + Hs[3])) - 2*iiota*Pssp*zbar*(-1 + Hs[0] + Hs[3]) + iiota*Pssp*zbar*pow(Hs[0] + Hs[3],2);
	Nxx_sp_s[6]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*pow(Gs[1],2) - pow(E,yss[7])*Pssp*pow(Gs[7],2) + 2*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[1] - pow(E,yss[7])*Gs[7])*(dP2ssp*Gs[9] + dP1ssp*Gs[10]);
	Nxx_sp_s[7]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(eeta,2)*Pssp*pow(zbar,aalpha) - pow(E,yss[0])*Pssp*pow(Gs[0],2) + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[1] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[1],2) - 2*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2] - 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[2] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[2],2) - pow(E,yss[3])*Pssp*pow(Gs[3],2) + 2*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[2] + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[2] - 2*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[2] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[2],2) + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[3] + 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[3] - 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[3] + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[3] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[3],2) - pow(E,yss[2])*pbar*Pssp*pow(Gs[2] + Hs[4],2) - 2*pphi*Pssp*Gs[5]*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4])) - pow(E,yss[11])*ebar*Pssp*pow(Hs[6],2) - pow(E,yss[1] + yss[7])*pphi*Pssp*pow(Gs[1] + Gs[7],2)*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*pow(Gs[2] + Hs[4],2)*yss[5] - (2*Pssp*zbar*pow(Gs[5],2)*xss[1])/pow(1 + yss[5],3) + (2*Pssp*zbar*Gs[5]*Hs[1])/pow(1 + yss[5],2) + (2*Pssp*zbar*Gs[5]*Hs[3]*xss[1])/pow(1 + yss[5],2) - (2*Pssp*zbar*Hs[1]*Hs[3])/(1 + yss[5]) - (Pssp*zbar*pow(Hs[3],2)*xss[1])/(1 + yss[5]) + 2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha) - pow(E,yss[0])*Gs[0] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[2] - pow(E,yss[3])*Gs[3] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[5] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] - pow(E,yss[2])*pbar*(Gs[2] + Hs[4]) - pow(E,yss[11])*ebar*Hs[6] - pphi*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))*yss[5] + (zbar*Gs[5]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[1])/(1 + yss[5]) - (zbar*Hs[3]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[8]=-((-1 + ddelta)*pow(E,xss[0])*Pssp) + pow(E,yss[3])*Pssp*pow(Gs[3],2) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*pow(-1 + Hs[0] + Hs[3],2) - pow(E,xss[0])*Pssp*zbar*pow(Hs[0] + Hs[3],2) + 2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[3])*Gs[3] - pow(E,xss[0])*(-1 + ddelta + zbar*Hs[0] + zbar*Hs[3]));
	Nxx_sp_s[9]=pow(E,xss[0])*kkappa*Pssp*zbar*pow(Gs[6] + Hs[0] + Hs[3],2) - 2*pphi*Pssp*Gs[5]*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4])) + (2*Pssp*zbar*pow(Gs[5],2)*xss[1])/pow(1 + yss[5],3) - (2*Pssp*zbar*Gs[5]*Hs[1])/pow(1 + yss[5],2) - (2*Pssp*zbar*Gs[5]*Hs[3]*xss[1])/pow(1 + yss[5],2) + (2*Pssp*zbar*Hs[1]*Hs[3])/(1 + yss[5]) + (Pssp*zbar*pow(Hs[3],2)*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*pow(Gs[1] + Gs[7],2)*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*pow(Gs[2] + Hs[4],2)*(1 + yss[5]) + 2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[5]) - Gs[10] + pow(E,xss[0])*kkappa*zbar*(Gs[6] + Hs[0] + Hs[3]) - (zbar*Gs[5]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[1])/(1 + yss[5]) + (zbar*Hs[3]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))*(1 + yss[5]));
	Nxx_sp_s[10]=2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*((-1 + nnus)*Gs[9] + nnus*Gs[10]);
	Nxx_sp_s[11]=pow(E,bbar - xss[1])*ppsir*Pssp*pow(Hs[1],2) + 2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-Gs[5] - pow(E,bbar - xss[1])*ppsir*Hs[1] + Hs[5]);
	Nxx_sp_s[12]=-(pow(E,xss[0])*(Gs[4] - Hs[0])*(2*dP2ssp*Gs[9] + 2*dP1ssp*Gs[10] + Pssp*(Gs[4] + Hs[0])));
	Nxx_sp_s[13]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(eeta,2)*Pssp*pow(zbar,aalpha)) - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[1] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[1],2) + 2*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2] + 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[2] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[2],2) + pow(E,yss[11])*Pssp*pow(Gs[11],2) - 2*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[2] - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[2] + 2*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[2] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[2],2) - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[3] - 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[3] + 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[3] - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[3] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[3],2) + pow(E,yss[2])*pbar*Pssp*pow(Gs[2] + Hs[4],2) + 2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha)) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[2] + pow(E,yss[11])*Gs[11] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]));
	Nxx_sp_s[14]=(2*Pssp*zbar*Hs[1]*(Gs[11] - Hs[3]) - Pssp*zbar*pow(Gs[11] - Hs[3],2)*xss[1] + 2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[11])*Gs[12] - zbar*Hs[1] + zbar*(Gs[11] - Hs[3])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[15]=(-2*Pssp*zbar*Hs[1]*Hs[3] - Pssp*(-1 + zbar)*pow(Gs[11],2)*xss[1] - Pssp*zbar*pow(Hs[3],2)*xss[1] + 2*Pssp*zbar*Gs[11]*(Hs[1] + Hs[3]*xss[1]) - 2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(E,yss[11])*Gs[13]) + zbar*Hs[1] - (-1 + zbar)*Gs[11]*xss[1] + zbar*Hs[3]*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[16]=pow(E,yss[0] - yss[11])*Pssp*pow(Gs[0],2) + pow(E,yss[3] - yss[11])*Pssp*pow(Gs[3],2) - Pssp*pow(Gs[11],2) + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*pow(Gs[11],2))/pow(E,yss[11]) + ebar*Pssp*pow(Hs[6],2) + (2*Pssp*Gs[11]*(-(pow(E,yss[0])*Gs[0]) - pow(E,yss[3])*Gs[3] + pow(E,yss[11])*Gs[11] - pow(E,yss[11])*ebar*Hs[6]))/pow(E,yss[11]) + (2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[0])*Gs[0] + pow(E,yss[3])*Gs[3] - pow(E,yss[0])*Gs[11] - pow(E,yss[3])*Gs[11] - pow(E,yss[11])*ebar*Gs[11] + pow(E,yss[11])*Gs[14] + pow(E,yss[11])*ebar*Hs[6]))/pow(E,yss[11]);
	Nxx_sp_s[17]=((-2*Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[9]*Hs[3])/pow(E,yss[8]) + (2*Pssp*pow(zbar,rrho)*Gs[9]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(E,yss[8]) - (Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*pow(Hs[3],2)*yss[9])/pow(E,yss[8]) + (2*Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[3]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*yss[9])/pow(E,yss[8]) - (Pssp*pow(zbar,rrho)*pow(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7],2)*yss[9])/pow(E,yss[8]) + 2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-((pow(zbar,rrho)*Gs[9])/pow(E,yss[8])) + bbeta*Gs[15] - (rrho*rrhoz*pow(zbar,rrho)*Hs[3]*yss[9])/pow(E,yss[8]) + (pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*yss[9])/pow(E,yss[8])))/bbeta;
	Nxx_sp_s[18]=-2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[2];
	Nxx_sp_s[19]=-2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[3];
	Nxx_sp_s[20]=-2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[4];
	Nxx_sp_s[21]=-2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[7];
	Nxx_sp_s[22]=-2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[6];
	Nxx_sp_s[23]=-2*(dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[5];
	Nxx_sp_s[24]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[0]*Gs[16]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[1]*Gs[17] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17]) - pow(E,yss[8])*Pssp*Gs[8]*Gs[24] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])*Hs[7] + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])) - pow(E,yss[8])*Gs[8] + Hs[7]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])*Hs[15] + (Pssp*Hs[7]*Hs[15])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])) - pow(E,yss[8])*Gs[24] + Hs[15]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[25]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]) - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[17] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[17] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[18] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[18] - (pbar*pphi*Pssp*Gs[9]*Gs[21])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[5]*Gs[25])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[2] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[2] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[3] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[3] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[10] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[10] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[11] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[11] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[11] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[11] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[11] + (pbar*pphi*Pssp*Gs[9]*Gs[24]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[8]*Gs[25]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[8]*Gs[21]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[5]*Gs[24]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[8]*Gs[24]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[4]*Hs[12]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[12]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[4]*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[1] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[2] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[2] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[3] - pbar*Hs[4]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[17]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[18] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[11] - pbar*Hs[12]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[26]=(-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[17] - pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[1]*Gs[17] + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[17] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[17] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[18] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[18] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[18] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[9]*Gs[21] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[25] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[2] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[3] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[3] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[10] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[10] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[10] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[11] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[11] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[11] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[11] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[11] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[9]*Gs[24]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[25]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[21]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[24]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[24]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[7]*Gs[23]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[23]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[7]*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha) - pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[1] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] - pow(E,yss[7])*pphi*Gs[7]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9]))) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[17]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] - pow(E,yss[7])*pphi*Gs[23]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])));
	Nxx_sp_s[27]=-(pow(E,yss[8])*Pssp*Gs[8]*Gs[24]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[21]*Hs[3])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[21]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[5]*Hs[11])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[5]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[3]*Hs[11]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[11]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[3]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*((bbeta*pow(E,yss[8])*Gs[5])/pow(zbar,rrho) - pow(E,yss[8])*Gs[8] + Gs[9] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[3]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*((bbeta*pow(E,yss[8])*Gs[21])/pow(zbar,rrho) - pow(E,yss[8])*Gs[24] + Gs[25] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[11]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[28]=-(kkappa*Pssp*Gs[9]*Gs[22]) + pow(E,yss[8])*Pssp*Gs[8]*Gs[24] - kkappa*Pssp*Gs[6]*Gs[25] + pow(E,yss[8])*iiota*Pssp*zbar*Gs[24]*(-1 + Hs[0] + Hs[3]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[8] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[8] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*Hs[8] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*Hs[8] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[8] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[8] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*Hs[8] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[0]*Hs[10] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[2]*Hs[10] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*Hs[10] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[10] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[10] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[0]*Hs[11] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[2]*Hs[11] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[3]*Hs[11] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[11])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[11] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[11] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[11])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7]))*Hs[11])/pow(zbar,rrho) - pow(E,yss[8])*iiota*Pssp*zbar*(Hs[8] + Hs[11]) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[8]*(Hs[8] + Hs[11]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[8] + Hs[11]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*(Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7]))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[3]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])))/pow(zbar,rrho) - kkappa*Pssp*Gs[6]*Gs[22]*yss[9] + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[8])*Gs[8] - kkappa*Gs[9] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(-1 + Hs[0] + Hs[3]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])))/pow(zbar,rrho) - kkappa*Gs[6]*yss[9]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[8])*Gs[24] - kkappa*Gs[25] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[8] + Hs[11]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])))/pow(zbar,rrho) - kkappa*Gs[22]*yss[9]);
	Nxx_sp_s[29]=-(Pssp*Gs[6]*Gs[22]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-Gs[6] + iiota*zbar*Hs[0] + iiota*zbar*(-1 + Hs[3])) - iiota*Pssp*zbar*(Hs[8] + Hs[11]) + iiota*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[8] + Hs[11]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-Gs[22] + iiota*zbar*(Hs[8] + Hs[11]));
	Nxx_sp_s[30]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[1]*Gs[17] - pow(E,yss[7])*Pssp*Gs[7]*Gs[23] + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[17] - pow(E,yss[7])*Gs[23]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[1] - pow(E,yss[7])*Gs[7])*(dP2ssp*Gs[25] + dP1ssp*Gs[26]);
	Nxx_sp_s[31]=-(pow(E,yss[0])*Pssp*Gs[0]*Gs[16]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[17] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[17] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[17] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[18] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[18] - pow(E,yss[3])*Pssp*Gs[3]*Gs[19] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[2] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[2] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[3] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[3] - pphi*Pssp*Gs[21]*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4])) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[10] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[10] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[11] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[11] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[11] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[11] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[11] - pow(E,yss[2])*pbar*Pssp*(Gs[2] + Hs[4])*(Gs[18] + Hs[12]) - pphi*Pssp*Gs[5]*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12])) - pow(E,yss[11])*ebar*Pssp*Hs[6]*Hs[14] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[1] + Gs[7])*(Gs[17] + Gs[23])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[2] + Hs[4])*(Gs[18] + Hs[12])*yss[5] - (2*Pssp*zbar*Gs[5]*Gs[21]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[21]*Hs[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[5]*Hs[9])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[21]*Hs[3]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[5]*Hs[11]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[3]*Hs[9])/(1 + yss[5]) - (Pssp*zbar*Hs[1]*Hs[11])/(1 + yss[5]) - (Pssp*zbar*Hs[3]*Hs[11]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha) - pow(E,yss[0])*Gs[0] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[2] - pow(E,yss[3])*Gs[3] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[5] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] - pow(E,yss[2])*pbar*(Gs[2] + Hs[4]) - pow(E,yss[11])*ebar*Hs[6] - pphi*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))*yss[5] + (zbar*Gs[5]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[1])/(1 + yss[5]) - (zbar*Hs[3]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(1 - pow(E,yss[0])*Gs[16] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[18] - pow(E,yss[3])*Gs[19] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[21] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] - pow(E,yss[2])*pbar*(Gs[18] + Hs[12]) - pow(E,yss[11])*ebar*Hs[14] - pphi*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))*yss[5] + (zbar*Gs[21]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[9])/(1 + yss[5]) - (zbar*Hs[11]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[32]=pow(E,yss[3])*Pssp*Gs[3]*Gs[19] + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[3])*Gs[3] - pow(E,xss[0])*(-1 + ddelta + zbar*Hs[0] + zbar*Hs[3])) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(-1 + Hs[0] + Hs[3])*(Hs[8] + Hs[11]) - pow(E,xss[0])*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[8] + Hs[11]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[3])*Gs[19] - pow(E,xss[0])*zbar*(Hs[8] + Hs[11]));
	Nxx_sp_s[33]=-(pphi*Pssp*Gs[21]*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[6] + Hs[0] + Hs[3])*(Gs[22] + Hs[8] + Hs[11]) - pphi*Pssp*Gs[5]*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12])) + (2*Pssp*zbar*Gs[5]*Gs[21]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[21]*Hs[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[5]*Hs[9])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[21]*Hs[3]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[5]*Hs[11]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[3]*Hs[9])/(1 + yss[5]) + (Pssp*zbar*Hs[1]*Hs[11])/(1 + yss[5]) + (Pssp*zbar*Hs[3]*Hs[11]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[1] + Gs[7])*(Gs[17] + Gs[23])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[2] + Hs[4])*(Gs[18] + Hs[12])*(1 + yss[5]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[5]) - Gs[10] + pow(E,xss[0])*kkappa*zbar*(Gs[6] + Hs[0] + Hs[3]) - (zbar*Gs[5]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[1])/(1 + yss[5]) + (zbar*Hs[3]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))*(1 + yss[5])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[21]) - Gs[26] + pow(E,xss[0])*kkappa*zbar*(Gs[22] + Hs[8] + Hs[11]) - (zbar*Gs[21]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[9])/(1 + yss[5]) + (zbar*Hs[11]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))*(1 + yss[5]));
	Nxx_sp_s[34]=((-1 + nnus)*Gs[9] + nnus*Gs[10])*(dP2ssp*Gs[25] + dP1ssp*Gs[26]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*((-1 + nnus)*Gs[25] + nnus*Gs[26]);
	Nxx_sp_s[35]=(dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-Gs[5] - pow(E,bbar - xss[1])*ppsir*Hs[1] + Hs[5]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[1]*Hs[9] + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-Gs[21] - pow(E,bbar - xss[1])*ppsir*Hs[9] + Hs[13]);
	Nxx_sp_s[36]=pow(E,xss[0])*(-(Pssp*Gs[4]*Gs[20]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(Gs[4] - Hs[0]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(Gs[20] - Hs[8]) + Pssp*Hs[0]*Hs[8]);
	Nxx_sp_s[37]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[17]) - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[17] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[18] + pow(E,yss[11])*Pssp*Gs[11]*Gs[27] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[2] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[2] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[3] + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha)) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[2] + pow(E,yss[11])*Gs[11] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] + pow(E,yss[2])*pbar*(Gs[2] + Hs[4])) - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[10] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[10] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[11] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[11] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[11] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[11] + pow(E,yss[2])*pbar*Pssp*(Gs[2] + Hs[4])*(Gs[18] + Hs[12]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[18] + pow(E,yss[11])*Gs[27] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]));
	Nxx_sp_s[38]=(Pssp*zbar*(Gs[11] - Hs[3])*Hs[9] + Pssp*zbar*Hs[1]*(Gs[27] - Hs[11]) - Pssp*zbar*(Gs[11] - Hs[3])*(Gs[27] - Hs[11])*xss[1] + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[11])*Gs[12] - zbar*Hs[1] + zbar*(Gs[11] - Hs[3])*xss[1]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[11])*Gs[28] - zbar*Hs[9] + zbar*(Gs[27] - Hs[11])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[39]=-((Pssp*zbar*Hs[3]*Hs[9])/pow(E,yss[11])) - (Pssp*zbar*Hs[1]*Hs[11])/pow(E,yss[11]) - (Pssp*(-1 + zbar)*Gs[11]*Gs[27]*xss[1])/pow(E,yss[11]) - (Pssp*zbar*Hs[3]*Hs[11]*xss[1])/pow(E,yss[11]) + (Pssp*zbar*Gs[27]*(Hs[1] + Hs[3]*xss[1]))/pow(E,yss[11]) - ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(E,yss[11])*Gs[13]) + zbar*Hs[1] - (-1 + zbar)*Gs[11]*xss[1] + zbar*Hs[3]*xss[1]))/pow(E,yss[11]) + (Pssp*Gs[11]*(-1 + zbar*Hs[9] + zbar*Hs[11]*xss[1]))/pow(E,yss[11]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(Gs[29] + ((-1 + zbar)*Gs[27]*xss[1])/pow(E,yss[11]) - (-1 + zbar*Hs[9] + zbar*Hs[11]*xss[1])/pow(E,yss[11]));
	Nxx_sp_s[40]=pow(E,yss[0] - yss[11])*Pssp*Gs[0]*Gs[16] + pow(E,yss[3] - yss[11])*Pssp*Gs[3]*Gs[19] - Pssp*Gs[11]*Gs[27] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[11]*Gs[27])/pow(E,yss[11]) - (Pssp*Gs[27]*(pow(E,yss[0])*Gs[0] + pow(E,yss[3])*Gs[3] - pow(E,yss[11])*Gs[11] + pow(E,yss[11])*ebar*Hs[6]))/pow(E,yss[11]) + ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[0])*Gs[0] + pow(E,yss[3])*Gs[3] - pow(E,yss[0])*Gs[11] - pow(E,yss[3])*Gs[11] - pow(E,yss[11])*ebar*Gs[11] + pow(E,yss[11])*Gs[14] + pow(E,yss[11])*ebar*Hs[6]))/pow(E,yss[11]) + ebar*Pssp*Hs[6]*Hs[14] - (Pssp*Gs[11]*(pow(E,yss[0])*Gs[16] + pow(E,yss[3])*Gs[19] - pow(E,yss[11])*Gs[27] + pow(E,yss[11])*ebar*Hs[14]))/pow(E,yss[11]) + ((dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[0])*Gs[16] + pow(E,yss[3])*Gs[19] - pow(E,yss[0])*Gs[27] - pow(E,yss[3])*Gs[27] - pow(E,yss[11])*ebar*Gs[27] + pow(E,yss[11])*Gs[30] + pow(E,yss[11])*ebar*Hs[14]))/pow(E,yss[11]);
	Nxx_sp_s[41]=(-((Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[25]*Hs[3])/pow(E,yss[8])) + (Pssp*pow(zbar,rrho)*Gs[25]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(E,yss[8]) - (Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[9]*Hs[11])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*Gs[9]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(E,yss[8]) - (Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[3]*Hs[11]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[11]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[3]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*yss[9])/pow(E,yss[8]) - (Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*yss[9])/pow(E,yss[8]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-((pow(zbar,rrho)*Gs[9])/pow(E,yss[8])) + bbeta*Gs[15] - (rrho*rrhoz*pow(zbar,rrho)*Hs[3]*yss[9])/pow(E,yss[8]) + (pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*yss[9])/pow(E,yss[8])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-((pow(zbar,rrho)*Gs[25])/pow(E,yss[8])) + bbeta*Gs[31] - (rrho*rrhoz*pow(zbar,rrho)*Hs[11]*yss[9])/pow(E,yss[8]) + (pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*yss[9])/pow(E,yss[8])))/bbeta;
	Nxx_sp_s[42]=-((dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[2]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[10];
	Nxx_sp_s[43]=-((dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[3]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[11];
	Nxx_sp_s[44]=-((dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[4]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[12];
	Nxx_sp_s[45]=-((dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[7]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[15];
	Nxx_sp_s[46]=-((dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[6]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[14];
	Nxx_sp_s[47]=-((dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[5]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[13];
	Nxx_sp_s[48]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[0]*Gs[32]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[1]*Gs[33] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33]) - pow(E,yss[8])*Pssp*Gs[8]*Gs[40] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])*Hs[7] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])) - pow(E,yss[8])*Gs[8] + Hs[7]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])*Hs[23] + (Pssp*Hs[7]*Hs[23])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])) - pow(E,yss[8])*Gs[40] + Hs[23]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[49]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]) - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[33] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[33] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[34] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[34] - (pbar*pphi*Pssp*Gs[9]*Gs[37])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[5]*Gs[41])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[2] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[2] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[3] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[3] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[18] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[18] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[19] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[19] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[19] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[19] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[19] + (pbar*pphi*Pssp*Gs[9]*Gs[40]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[8]*Gs[41]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[8]*Gs[37]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[5]*Gs[40]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[8]*Gs[40]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[4]*Hs[20]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[20]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[4]*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[1] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[2] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[2] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[3] - pbar*Hs[4]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[33]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[34] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[19] - pbar*Hs[20]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[50]=(-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[33] - pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[1]*Gs[33] + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[33] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[33] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[34] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[34] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[34] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[9]*Gs[37] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[41] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[2] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[3] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[3] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[18] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[18] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[18] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[19] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[19] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[19] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[19] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[19] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[9]*Gs[40]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[41]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[37]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[40]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[40]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[7]*Gs[39]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[39]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[7]*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha) - pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[1] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] - pow(E,yss[7])*pphi*Gs[7]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9]))) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[33]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] - pow(E,yss[7])*pphi*Gs[39]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])));
	Nxx_sp_s[51]=-(pow(E,yss[8])*Pssp*Gs[8]*Gs[40]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[37]*Hs[3])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[37]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[5]*Hs[19])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[5]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[3]*Hs[19]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[19]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[3]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*((bbeta*pow(E,yss[8])*Gs[5])/pow(zbar,rrho) - pow(E,yss[8])*Gs[8] + Gs[9] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[3]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*((bbeta*pow(E,yss[8])*Gs[37])/pow(zbar,rrho) - pow(E,yss[8])*Gs[40] + Gs[41] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[19]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[52]=-(kkappa*Pssp*Gs[9]*Gs[38]) + pow(E,yss[8])*Pssp*Gs[8]*Gs[40] - kkappa*Pssp*Gs[6]*Gs[41] + pow(E,yss[8])*iiota*Pssp*zbar*Gs[40]*(-1 + Hs[0] + Hs[3]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[16] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[16] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*Hs[16] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*Hs[16] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[16] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[16] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*Hs[16] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[0]*Hs[18] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[2]*Hs[18] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*Hs[18] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[18] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[18] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[0]*Hs[19] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[2]*Hs[19] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[3]*Hs[19] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[19])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[19] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[19] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[19])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7]))*Hs[19])/pow(zbar,rrho) - pow(E,yss[8])*iiota*Pssp*zbar*(Hs[16] + Hs[19]) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[8]*(Hs[16] + Hs[19]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[16] + Hs[19]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*(Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7]))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[3]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])))/pow(zbar,rrho) - kkappa*Pssp*Gs[6]*Gs[38]*yss[9] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[8])*Gs[8] - kkappa*Gs[9] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(-1 + Hs[0] + Hs[3]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])))/pow(zbar,rrho) - kkappa*Gs[6]*yss[9]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[8])*Gs[40] - kkappa*Gs[41] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[16] + Hs[19]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])))/pow(zbar,rrho) - kkappa*Gs[38]*yss[9]);
	Nxx_sp_s[53]=-(Pssp*Gs[6]*Gs[38]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-Gs[6] + iiota*zbar*Hs[0] + iiota*zbar*(-1 + Hs[3])) - iiota*Pssp*zbar*(Hs[16] + Hs[19]) + iiota*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[16] + Hs[19]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-Gs[38] + iiota*zbar*(Hs[16] + Hs[19]));
	Nxx_sp_s[54]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[1]*Gs[33] - pow(E,yss[7])*Pssp*Gs[7]*Gs[39] + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[33] - pow(E,yss[7])*Gs[39]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[1] - pow(E,yss[7])*Gs[7])*(dP2ssp*Gs[41] + dP1ssp*Gs[42]);
	Nxx_sp_s[55]=-(pow(E,yss[0])*Pssp*Gs[0]*Gs[32]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[33] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[33] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[33] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[34] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[34] - pow(E,yss[3])*Pssp*Gs[3]*Gs[35] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[2] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[2] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[3] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[3] - pphi*Pssp*Gs[37]*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4])) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[18] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[19] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[19] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[19] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[19] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[19] - pow(E,yss[2])*pbar*Pssp*(Gs[2] + Hs[4])*(Gs[34] + Hs[20]) - pphi*Pssp*Gs[5]*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20])) - pow(E,yss[11])*ebar*Pssp*Hs[6]*Hs[22] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[1] + Gs[7])*(Gs[33] + Gs[39])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[2] + Hs[4])*(Gs[34] + Hs[20])*yss[5] - (2*Pssp*zbar*Gs[5]*Gs[37]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[37]*Hs[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[5]*Hs[17])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[37]*Hs[3]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[5]*Hs[19]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[3]*Hs[17])/(1 + yss[5]) - (Pssp*zbar*Hs[1]*Hs[19])/(1 + yss[5]) - (Pssp*zbar*Hs[3]*Hs[19]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha) - pow(E,yss[0])*Gs[0] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[2] - pow(E,yss[3])*Gs[3] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[5] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] - pow(E,yss[2])*pbar*(Gs[2] + Hs[4]) - pow(E,yss[11])*ebar*Hs[6] - pphi*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))*yss[5] + (zbar*Gs[5]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[1])/(1 + yss[5]) - (zbar*Hs[3]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(E,yss[0])*Gs[32]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[34] - pow(E,yss[3])*Gs[35] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[37] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] - pow(E,yss[2])*pbar*(Gs[34] + Hs[20]) - pow(E,yss[11])*ebar*Hs[22] - pphi*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))*yss[5] + (zbar*Gs[37]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[17])/(1 + yss[5]) - (zbar*Hs[19]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[56]=pow(E,yss[3])*Pssp*Gs[3]*Gs[35] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[3])*Gs[3] - pow(E,xss[0])*(-1 + ddelta + zbar*Hs[0] + zbar*Hs[3])) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(-1 + Hs[0] + Hs[3])*(Hs[16] + Hs[19]) - pow(E,xss[0])*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[16] + Hs[19]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[3])*Gs[35] - pow(E,xss[0])*zbar*(Hs[16] + Hs[19]));
	Nxx_sp_s[57]=-(pphi*Pssp*Gs[37]*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[6] + Hs[0] + Hs[3])*(Gs[38] + Hs[16] + Hs[19]) - pphi*Pssp*Gs[5]*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20])) + (2*Pssp*zbar*Gs[5]*Gs[37]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[37]*Hs[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[5]*Hs[17])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[37]*Hs[3]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[5]*Hs[19]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[3]*Hs[17])/(1 + yss[5]) + (Pssp*zbar*Hs[1]*Hs[19])/(1 + yss[5]) + (Pssp*zbar*Hs[3]*Hs[19]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[1] + Gs[7])*(Gs[33] + Gs[39])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[2] + Hs[4])*(Gs[34] + Hs[20])*(1 + yss[5]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[5]) - Gs[10] + pow(E,xss[0])*kkappa*zbar*(Gs[6] + Hs[0] + Hs[3]) - (zbar*Gs[5]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[1])/(1 + yss[5]) + (zbar*Hs[3]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))*(1 + yss[5])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[37]) - Gs[42] + pow(E,xss[0])*kkappa*zbar*(Gs[38] + Hs[16] + Hs[19]) - (zbar*Gs[37]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[17])/(1 + yss[5]) + (zbar*Hs[19]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))*(1 + yss[5]));
	Nxx_sp_s[58]=((-1 + nnus)*Gs[9] + nnus*Gs[10])*(dP2ssp*Gs[41] + dP1ssp*Gs[42]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*((-1 + nnus)*Gs[41] + nnus*Gs[42]);
	Nxx_sp_s[59]=(dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-Gs[5] - pow(E,bbar - xss[1])*ppsir*Hs[1] + Hs[5]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[1]*Hs[17] + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-Gs[37] - pow(E,bbar - xss[1])*ppsir*Hs[17] + Hs[21]);
	Nxx_sp_s[60]=pow(E,xss[0])*(-(Pssp*Gs[4]*Gs[36]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(Gs[4] - Hs[0]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(Gs[36] - Hs[16]) + Pssp*Hs[0]*Hs[16]);
	Nxx_sp_s[61]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[33]) - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[33] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[34] + pow(E,yss[11])*Pssp*Gs[11]*Gs[43] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[2] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[2] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[3] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha)) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[2] + pow(E,yss[11])*Gs[11] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] + pow(E,yss[2])*pbar*(Gs[2] + Hs[4])) - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[18] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[18] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[19] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[19] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[19] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[19] + pow(E,yss[2])*pbar*Pssp*(Gs[2] + Hs[4])*(Gs[34] + Hs[20]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[34] + pow(E,yss[11])*Gs[43] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]));
	Nxx_sp_s[62]=(Pssp*zbar*(Gs[11] - Hs[3])*Hs[17] + Pssp*zbar*Hs[1]*(Gs[43] - Hs[19]) - Pssp*zbar*(Gs[11] - Hs[3])*(Gs[43] - Hs[19])*xss[1] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[11])*Gs[12] - zbar*Hs[1] + zbar*(Gs[11] - Hs[3])*xss[1]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[11])*Gs[44] - zbar*Hs[17] + zbar*(Gs[43] - Hs[19])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[63]=(-(Pssp*zbar*Hs[3]*Hs[17]) - Pssp*zbar*Hs[1]*Hs[19] - Pssp*(-1 + zbar)*Gs[11]*Gs[43]*xss[1] - Pssp*zbar*Hs[3]*Hs[19]*xss[1] + Pssp*zbar*Gs[43]*(Hs[1] + Hs[3]*xss[1]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(E,yss[11])*Gs[13]) + zbar*Hs[1] - (-1 + zbar)*Gs[11]*xss[1] + zbar*Hs[3]*xss[1]) + Pssp*zbar*Gs[11]*(Hs[17] + Hs[19]*xss[1]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(E,yss[11])*Gs[45]) + zbar*Hs[17] - (-1 + zbar)*Gs[43]*xss[1] + zbar*Hs[19]*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[64]=pow(E,yss[0] - yss[11])*Pssp*Gs[0]*Gs[32] + pow(E,yss[3] - yss[11])*Pssp*Gs[3]*Gs[35] - Pssp*Gs[11]*Gs[43] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[11]*Gs[43])/pow(E,yss[11]) - (Pssp*Gs[43]*(pow(E,yss[0])*Gs[0] + pow(E,yss[3])*Gs[3] - pow(E,yss[11])*Gs[11] + pow(E,yss[11])*ebar*Hs[6]))/pow(E,yss[11]) + ((dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[0])*Gs[0] + pow(E,yss[3])*Gs[3] - pow(E,yss[0])*Gs[11] - pow(E,yss[3])*Gs[11] - pow(E,yss[11])*ebar*Gs[11] + pow(E,yss[11])*Gs[14] + pow(E,yss[11])*ebar*Hs[6]))/pow(E,yss[11]) + ebar*Pssp*Hs[6]*Hs[22] - (Pssp*Gs[11]*(pow(E,yss[0])*Gs[32] + pow(E,yss[3])*Gs[35] - pow(E,yss[11])*Gs[43] + pow(E,yss[11])*ebar*Hs[22]))/pow(E,yss[11]) + ((dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[0])*Gs[32] + pow(E,yss[3])*Gs[35] - pow(E,yss[0])*Gs[43] - pow(E,yss[3])*Gs[43] - pow(E,yss[11])*ebar*Gs[43] + pow(E,yss[11])*Gs[46] + pow(E,yss[11])*ebar*Hs[22]))/pow(E,yss[11]);
	Nxx_sp_s[65]=(-((Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[41]*Hs[3])/pow(E,yss[8])) + (Pssp*pow(zbar,rrho)*Gs[41]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(E,yss[8]) - (Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[9]*Hs[19])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*Gs[9]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(E,yss[8]) - (Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[3]*Hs[19]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[19]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[3]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*yss[9])/pow(E,yss[8]) - (Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*yss[9])/pow(E,yss[8]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-((pow(zbar,rrho)*Gs[9])/pow(E,yss[8])) + bbeta*Gs[15] - (rrho*rrhoz*pow(zbar,rrho)*Hs[3]*yss[9])/pow(E,yss[8]) + (pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*yss[9])/pow(E,yss[8])) + ((dP2ssp*Gs[9] + dP1ssp*Gs[10])*(bbeta*pow(E,yss[8])*Gs[47] + pow(zbar,rrho)*Gsp[120]*Hs[23]*yss[9] + pow(zbar,rrho)*(-Gs[41] + Gsp[8]*Hs[16]*yss[9] + Gsp[24]*Hs[17]*yss[9] + Gsp[40]*Hs[18]*yss[9] - rrho*rrhoz*Hs[19]*yss[9] + Gsp[56]*Hs[19]*yss[9] + Gsp[72]*Hs[20]*yss[9] + Gsp[88]*Hs[21]*yss[9] + Gsp[104]*Hs[22]*yss[9])))/pow(E,yss[8]))/bbeta;
	Nxx_sp_s[66]=-((dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[2]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(rrhoa - Hs[18]);
	Nxx_sp_s[67]=-((dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[3]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[19];
	Nxx_sp_s[68]=-((dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[4]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[20];
	Nxx_sp_s[69]=-((dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[7]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[23];
	Nxx_sp_s[70]=-((dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[6]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[22];
	Nxx_sp_s[71]=-((dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[5]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[21];
	Nxx_sp_s[72]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[0]*Gs[48]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[1]*Gs[49] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])*(pow(E,yss[0])*Gs[48] - pow(pow(E,yss[1]),oomega)*Gs[49]) - pow(E,yss[8])*Pssp*Gs[8]*Gs[56] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[48] - pow(pow(E,yss[1]),oomega)*Gs[49])*Hs[7] + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])) - pow(E,yss[8])*Gs[8] + Hs[7]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])*Hs[31] + (Pssp*Hs[7]*Hs[31])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[48] - pow(pow(E,yss[1]),oomega)*Gs[49])) - pow(E,yss[8])*Gs[56] + Hs[31]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[73]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[49]) - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[49] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[49] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[50] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[50] - (pbar*pphi*Pssp*Gs[9]*Gs[53])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[5]*Gs[57])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[2] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[2] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[3] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[3] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[26] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[26] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[26] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[26] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[26] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[27] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[27] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[27] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[27] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[27] + (pbar*pphi*Pssp*Gs[9]*Gs[56]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[8]*Gs[57]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[8]*Gs[53]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[5]*Gs[56]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[8]*Gs[56]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[4]*Hs[28]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[28]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[4]*(Gs[53]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[57] - Gs[56]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[1] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[2] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[2] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[3] - pbar*Hs[4]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[49]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[50] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[26] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[27] - pbar*Hs[28]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[53]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[57] - Gs[56]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[74]=(-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[49] - pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[1]*Gs[49] + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[49] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[49] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[50] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[50] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[50] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[9]*Gs[53] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[57] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[2] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[3] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[3] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[26] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[26] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[26] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[27] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[27] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[27] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[27] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[27] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[9]*Gs[56]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[57]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[53]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[56]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[56]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[7]*Gs[55]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[55]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[7]*(Gs[53]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[57] - Gs[56]*yss[9])) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha) - pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[1] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] - pow(E,yss[7])*pphi*Gs[7]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9]))) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[49]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[49] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[26] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[27] - pow(E,yss[7])*pphi*Gs[55]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[53]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[57] - Gs[56]*yss[9])));
	Nxx_sp_s[75]=-(pow(E,yss[8])*Pssp*Gs[8]*Gs[56]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[53]*Hs[3])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[53]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[5]*Hs[27])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[5]*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[3]*Hs[27]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[27]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[3]*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*((bbeta*pow(E,yss[8])*Gs[5])/pow(zbar,rrho) - pow(E,yss[8])*Gs[8] + Gs[9] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[3]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*((bbeta*pow(E,yss[8])*Gs[53])/pow(zbar,rrho) - pow(E,yss[8])*Gs[56] + Gs[57] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[27]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[76]=-(kkappa*Pssp*Gs[9]*Gs[54]) + pow(E,yss[8])*Pssp*Gs[8]*Gs[56] - kkappa*Pssp*Gs[6]*Gs[57] + pow(E,yss[8])*iiota*Pssp*zbar*Gs[56]*(-1 + Hs[0] + Hs[3]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[24] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[24] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*Hs[24] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*Hs[24] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[24] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[24] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*Hs[24] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[0]*Hs[26] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[2]*Hs[26] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*Hs[26] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[26] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[26] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[0]*Hs[27] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[2]*Hs[27] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[3]*Hs[27] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[27])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[27] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[27] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[27])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7]))*Hs[27])/pow(zbar,rrho) - pow(E,yss[8])*iiota*Pssp*zbar*(Hs[24] + Hs[27]) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[8]*(Hs[24] + Hs[27]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[24] + Hs[27]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*(Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7]))*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[3]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[24] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[27] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[24] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[27] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31])))/pow(zbar,rrho) - kkappa*Pssp*Gs[6]*Gs[54]*yss[9] + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(pow(E,yss[8])*Gs[8] - kkappa*Gs[9] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(-1 + Hs[0] + Hs[3]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])))/pow(zbar,rrho) - kkappa*Gs[6]*yss[9]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[8])*Gs[56] - kkappa*Gs[57] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[27])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[24] + Hs[27]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[24] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[27] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31])))/pow(zbar,rrho) - kkappa*Gs[54]*yss[9]);
	Nxx_sp_s[77]=-(Pssp*Gs[6]*Gs[54]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-Gs[6] + iiota*zbar*Hs[0] + iiota*zbar*(-1 + Hs[3])) - iiota*Pssp*zbar*(Hs[24] + Hs[27]) + iiota*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[24] + Hs[27]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-Gs[54] + iiota*zbar*(Hs[24] + Hs[27]));
	Nxx_sp_s[78]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[1]*Gs[49] - pow(E,yss[7])*Pssp*Gs[7]*Gs[55] + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[49] - pow(E,yss[7])*Gs[55]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[1] - pow(E,yss[7])*Gs[7])*(dP2ssp*Gs[57] + dP1ssp*Gs[58]);
	Nxx_sp_s[79]=-(pow(E,yss[0])*Pssp*Gs[0]*Gs[48]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[49] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[49] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[49] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[50] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[50] - pow(E,yss[3])*Pssp*Gs[3]*Gs[51] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[2] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[2] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[3] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[3] - pphi*Pssp*Gs[53]*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4])) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[26] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[26] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[27] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[27] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[27] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[27] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[27] - pow(E,yss[2])*pbar*Pssp*(Gs[2] + Hs[4])*(Gs[50] + Hs[28]) - pphi*Pssp*Gs[5]*(pow(E,yss[1] + yss[7])*(Gs[49] + Gs[55]) + pow(E,yss[2])*pbar*(Gs[50] + Hs[28])) - pow(E,yss[11])*ebar*Pssp*Hs[6]*Hs[30] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[1] + Gs[7])*(Gs[49] + Gs[55])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[2] + Hs[4])*(Gs[50] + Hs[28])*yss[5] - (2*Pssp*zbar*Gs[5]*Gs[53]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[53]*Hs[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[5]*Hs[25])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[53]*Hs[3]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[5]*Hs[27]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[3]*Hs[25])/(1 + yss[5]) - (Pssp*zbar*Hs[1]*Hs[27])/(1 + yss[5]) - (Pssp*zbar*Hs[3]*Hs[27]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha) - pow(E,yss[0])*Gs[0] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[2] - pow(E,yss[3])*Gs[3] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[5] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] - pow(E,yss[2])*pbar*(Gs[2] + Hs[4]) - pow(E,yss[11])*ebar*Hs[6] - pphi*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))*yss[5] + (zbar*Gs[5]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[1])/(1 + yss[5]) - (zbar*Hs[3]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(E,yss[0])*Gs[48]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[49] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[50] - pow(E,yss[3])*Gs[51] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[53] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[27] - pow(E,yss[2])*pbar*(Gs[50] + Hs[28]) - pow(E,yss[11])*ebar*Hs[30] - pphi*(pow(E,yss[1] + yss[7])*(Gs[49] + Gs[55]) + pow(E,yss[2])*pbar*(Gs[50] + Hs[28]))*yss[5] + (zbar*Gs[53]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[25])/(1 + yss[5]) - (zbar*Hs[27]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[80]=pow(E,yss[3])*Pssp*Gs[3]*Gs[51] + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(pow(E,yss[3])*Gs[3] - pow(E,xss[0])*(-1 + ddelta + zbar*Hs[0] + zbar*Hs[3])) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(-1 + Hs[0] + Hs[3])*(Hs[24] + Hs[27]) - pow(E,xss[0])*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[24] + Hs[27]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[3])*Gs[51] - pow(E,xss[0])*zbar*(Hs[24] + Hs[27]));
	Nxx_sp_s[81]=-(pphi*Pssp*Gs[53]*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[6] + Hs[0] + Hs[3])*(Gs[54] + Hs[24] + Hs[27]) - pphi*Pssp*Gs[5]*(pow(E,yss[1] + yss[7])*(Gs[49] + Gs[55]) + pow(E,yss[2])*pbar*(Gs[50] + Hs[28])) + (2*Pssp*zbar*Gs[5]*Gs[53]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[53]*Hs[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[5]*Hs[25])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[53]*Hs[3]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[5]*Hs[27]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[3]*Hs[25])/(1 + yss[5]) + (Pssp*zbar*Hs[1]*Hs[27])/(1 + yss[5]) + (Pssp*zbar*Hs[3]*Hs[27]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[1] + Gs[7])*(Gs[49] + Gs[55])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[2] + Hs[4])*(Gs[50] + Hs[28])*(1 + yss[5]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[5]) - Gs[10] + pow(E,xss[0])*kkappa*zbar*(Gs[6] + Hs[0] + Hs[3]) - (zbar*Gs[5]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[1])/(1 + yss[5]) + (zbar*Hs[3]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))*(1 + yss[5])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[53]) - Gs[58] + pow(E,xss[0])*kkappa*zbar*(Gs[54] + Hs[24] + Hs[27]) - (zbar*Gs[53]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[25])/(1 + yss[5]) + (zbar*Hs[27]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[49] + Gs[55]) + pow(E,yss[2])*pbar*(Gs[50] + Hs[28]))*(1 + yss[5]));
	Nxx_sp_s[82]=((-1 + nnus)*Gs[9] + nnus*Gs[10])*(dP2ssp*Gs[57] + dP1ssp*Gs[58]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*((-1 + nnus)*Gs[57] + nnus*Gs[58]);
	Nxx_sp_s[83]=(dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-Gs[5] - pow(E,bbar - xss[1])*ppsir*Hs[1] + Hs[5]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[1]*Hs[25] + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-Gs[53] - pow(E,bbar - xss[1])*ppsir*Hs[25] + Hs[29]);
	Nxx_sp_s[84]=pow(E,xss[0])*(-(Pssp*Gs[4]*Gs[52]) - (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(Gs[4] - Hs[0]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(Gs[52] - Hs[24]) + Pssp*Hs[0]*Hs[24]);
	Nxx_sp_s[85]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[49]) - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[49] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[49] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[50] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[50] + pow(E,yss[11])*Pssp*Gs[11]*Gs[59] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[2] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[2] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[3] + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha)) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[2] + pow(E,yss[11])*Gs[11] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] + pow(E,yss[2])*pbar*(Gs[2] + Hs[4])) - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[26] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[26] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[26] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[26] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[26] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[27] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[27] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[27] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[27] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[27] + pow(E,yss[2])*pbar*Pssp*(Gs[2] + Hs[4])*(Gs[50] + Hs[28]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[49]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[50] + pow(E,yss[11])*Gs[59] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[26] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[27] + pow(E,yss[2])*pbar*(Gs[50] + Hs[28]));
	Nxx_sp_s[86]=(Pssp*zbar*(Gs[11] - Hs[3])*Hs[25] + Pssp*zbar*Hs[1]*(Gs[59] - Hs[27]) - Pssp*zbar*(Gs[11] - Hs[3])*(Gs[59] - Hs[27])*xss[1] + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(pow(E,yss[11])*Gs[12] - zbar*Hs[1] + zbar*(Gs[11] - Hs[3])*xss[1]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[11])*Gs[60] - zbar*Hs[25] + zbar*(Gs[59] - Hs[27])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[87]=(-(Pssp*zbar*Hs[3]*Hs[25]) - Pssp*zbar*Hs[1]*Hs[27] - Pssp*(-1 + zbar)*Gs[11]*Gs[59]*xss[1] - Pssp*zbar*Hs[3]*Hs[27]*xss[1] + Pssp*zbar*Gs[59]*(Hs[1] + Hs[3]*xss[1]) - (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(pow(E,yss[11])*Gs[13]) + zbar*Hs[1] - (-1 + zbar)*Gs[11]*xss[1] + zbar*Hs[3]*xss[1]) + Pssp*zbar*Gs[11]*(Hs[25] + Hs[27]*xss[1]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(E,yss[11])*Gs[61]) + zbar*Hs[25] - (-1 + zbar)*Gs[59]*xss[1] + zbar*Hs[27]*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[88]=pow(E,yss[0] - yss[11])*Pssp*Gs[0]*Gs[48] + pow(E,yss[3] - yss[11])*Pssp*Gs[3]*Gs[51] - Pssp*Gs[11]*Gs[59] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[11]*Gs[59])/pow(E,yss[11]) - (Pssp*Gs[59]*(pow(E,yss[0])*Gs[0] + pow(E,yss[3])*Gs[3] - pow(E,yss[11])*Gs[11] + pow(E,yss[11])*ebar*Hs[6]))/pow(E,yss[11]) + ((dP2ssp*Gs[57] + dP1ssp*Gs[58])*(pow(E,yss[0])*Gs[0] + pow(E,yss[3])*Gs[3] - pow(E,yss[0])*Gs[11] - pow(E,yss[3])*Gs[11] - pow(E,yss[11])*ebar*Gs[11] + pow(E,yss[11])*Gs[14] + pow(E,yss[11])*ebar*Hs[6]))/pow(E,yss[11]) + ebar*Pssp*Hs[6]*Hs[30] - (Pssp*Gs[11]*(pow(E,yss[0])*Gs[48] + pow(E,yss[3])*Gs[51] - pow(E,yss[11])*Gs[59] + pow(E,yss[11])*ebar*Hs[30]))/pow(E,yss[11]) + ((dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[0])*Gs[48] + pow(E,yss[3])*Gs[51] - pow(E,yss[0])*Gs[59] - pow(E,yss[3])*Gs[59] - pow(E,yss[11])*ebar*Gs[59] + pow(E,yss[11])*Gs[62] + pow(E,yss[11])*ebar*Hs[30]))/pow(E,yss[11]);
	Nxx_sp_s[89]=(-((Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[57]*Hs[3])/pow(E,yss[8])) + (Pssp*pow(zbar,rrho)*Gs[57]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(E,yss[8]) - (Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[9]*Hs[27])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*Gs[9]*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]))/pow(E,yss[8]) - (Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[3]*Hs[27]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[27]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[3]*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*yss[9])/pow(E,yss[8]) - (Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*yss[9])/pow(E,yss[8]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-((pow(zbar,rrho)*Gs[9])/pow(E,yss[8])) + bbeta*Gs[15] - (rrho*rrhoz*pow(zbar,rrho)*Hs[3]*yss[9])/pow(E,yss[8]) + (pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*yss[9])/pow(E,yss[8])) + ((dP2ssp*Gs[9] + dP1ssp*Gs[10])*(bbeta*pow(E,yss[8])*Gs[63] + pow(zbar,rrho)*Gsp[120]*Hs[31]*yss[9] + pow(zbar,rrho)*(-Gs[57] + Gsp[8]*Hs[24]*yss[9] + Gsp[24]*Hs[25]*yss[9] + Gsp[40]*Hs[26]*yss[9] - rrho*rrhoz*Hs[27]*yss[9] + Gsp[56]*Hs[27]*yss[9] + Gsp[72]*Hs[28]*yss[9] + Gsp[88]*Hs[29]*yss[9] + Gsp[104]*Hs[30]*yss[9])))/pow(E,yss[8]))/bbeta;
	Nxx_sp_s[90]=-((dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[2]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[26];
	Nxx_sp_s[91]=-((dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[3]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(rrhoz - Hs[27]);
	Nxx_sp_s[92]=-((dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[4]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[28];
	Nxx_sp_s[93]=-((dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[7]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[31];
	Nxx_sp_s[94]=-((dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[6]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[30];
	Nxx_sp_s[95]=-((dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[5]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[29];
	Nxx_sp_s[96]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[0]*Gs[64]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[1]*Gs[65] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])*(pow(E,yss[0])*Gs[64] - pow(pow(E,yss[1]),oomega)*Gs[65]) - pow(E,yss[8])*Pssp*Gs[8]*Gs[72] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[64] - pow(pow(E,yss[1]),oomega)*Gs[65])*Hs[7] + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])) - pow(E,yss[8])*Gs[8] + Hs[7]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])*Hs[39] + (Pssp*Hs[7]*Hs[39])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[64] - pow(pow(E,yss[1]),oomega)*Gs[65])) - pow(E,yss[8])*Gs[72] + Hs[39]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[97]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[65]) - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[65] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[65] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[66] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[66] - (pbar*pphi*Pssp*Gs[9]*Gs[69])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[5]*Gs[73])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[2] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[2] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[3] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[3] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[34] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[34] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[34] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[34] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[34] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[35] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[35] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[35] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[35] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[35] + (pbar*pphi*Pssp*Gs[9]*Gs[72]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[8]*Gs[73]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[8]*Gs[69]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[5]*Gs[72]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[8]*Gs[72]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[4]*Hs[36]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[36]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[4]*(Gs[69]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[73] - Gs[72]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[1] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[2] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[2] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[3] - pbar*Hs[4]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[65]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[66] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[34] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[35] - pbar*Hs[36]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[69]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[73] - Gs[72]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[98]=(-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[65] - pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[1]*Gs[65] + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[65] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[65] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[66] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[66] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[66] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[9]*Gs[69] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[73] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[2] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[3] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[3] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[34] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[34] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[34] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[35] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[35] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[35] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[35] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[35] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[9]*Gs[72]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[73]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[69]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[72]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[72]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[7]*Gs[71]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[71]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[7]*(Gs[69]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[73] - Gs[72]*yss[9])) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha) - pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[1] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] - pow(E,yss[7])*pphi*Gs[7]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9]))) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[65]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[65] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[34] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[35] - pow(E,yss[7])*pphi*Gs[71]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[69]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[73] - Gs[72]*yss[9])));
	Nxx_sp_s[99]=-(pow(E,yss[8])*Pssp*Gs[8]*Gs[72]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[69]*Hs[3])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[69]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[5]*Hs[35])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[5]*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[3]*Hs[35]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[35]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[3]*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*((bbeta*pow(E,yss[8])*Gs[5])/pow(zbar,rrho) - pow(E,yss[8])*Gs[8] + Gs[9] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[3]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*((bbeta*pow(E,yss[8])*Gs[69])/pow(zbar,rrho) - pow(E,yss[8])*Gs[72] + Gs[73] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[35]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[100]=-(kkappa*Pssp*Gs[9]*Gs[70]) + pow(E,yss[8])*Pssp*Gs[8]*Gs[72] - kkappa*Pssp*Gs[6]*Gs[73] + pow(E,yss[8])*iiota*Pssp*zbar*Gs[72]*(-1 + Hs[0] + Hs[3]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[32] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[32] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*Hs[32] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*Hs[32] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[32] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[32] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*Hs[32] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[0]*Hs[34] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[2]*Hs[34] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*Hs[34] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[34] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[34] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[0]*Hs[35] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[2]*Hs[35] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[3]*Hs[35] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[35])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[35] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[35] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[35])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7]))*Hs[35])/pow(zbar,rrho) - pow(E,yss[8])*iiota*Pssp*zbar*(Hs[32] + Hs[35]) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[8]*(Hs[32] + Hs[35]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[32] + Hs[35]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*(Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7]))*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[3]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[32] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[35] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[32] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[35] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39])))/pow(zbar,rrho) - kkappa*Pssp*Gs[6]*Gs[70]*yss[9] + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(pow(E,yss[8])*Gs[8] - kkappa*Gs[9] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(-1 + Hs[0] + Hs[3]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])))/pow(zbar,rrho) - kkappa*Gs[6]*yss[9]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[8])*Gs[72] - kkappa*Gs[73] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[35])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[32] + Hs[35]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[32] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[35] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39])))/pow(zbar,rrho) - kkappa*Gs[70]*yss[9]);
	Nxx_sp_s[101]=-(Pssp*Gs[6]*Gs[70]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-Gs[6] + iiota*zbar*Hs[0] + iiota*zbar*(-1 + Hs[3])) - iiota*Pssp*zbar*(Hs[32] + Hs[35]) + iiota*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[32] + Hs[35]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-Gs[70] + iiota*zbar*(Hs[32] + Hs[35]));
	Nxx_sp_s[102]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[1]*Gs[65] - pow(E,yss[7])*Pssp*Gs[7]*Gs[71] + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[65] - pow(E,yss[7])*Gs[71]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[1] - pow(E,yss[7])*Gs[7])*(dP2ssp*Gs[73] + dP1ssp*Gs[74]);
	Nxx_sp_s[103]=-(pow(E,yss[0])*Pssp*Gs[0]*Gs[64]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[65] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[65] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[65] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[66] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[66] - pow(E,yss[3])*Pssp*Gs[3]*Gs[67] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[2] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[2] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[3] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[3] - pphi*Pssp*Gs[69]*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4])) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[34] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[35] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[35] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[35] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[35] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[35] - pow(E,yss[2])*pbar*Pssp*(Gs[2] + Hs[4])*(Gs[66] + Hs[36]) - pphi*Pssp*Gs[5]*(pow(E,yss[1] + yss[7])*(Gs[65] + Gs[71]) + pow(E,yss[2])*pbar*(Gs[66] + Hs[36])) - pow(E,yss[11])*ebar*Pssp*Hs[6]*Hs[38] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[1] + Gs[7])*(Gs[65] + Gs[71])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[2] + Hs[4])*(Gs[66] + Hs[36])*yss[5] - (2*Pssp*zbar*Gs[5]*Gs[69]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[69]*Hs[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[5]*Hs[33])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[69]*Hs[3]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[5]*Hs[35]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[3]*Hs[33])/(1 + yss[5]) - (Pssp*zbar*Hs[1]*Hs[35])/(1 + yss[5]) - (Pssp*zbar*Hs[3]*Hs[35]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha) - pow(E,yss[0])*Gs[0] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[2] - pow(E,yss[3])*Gs[3] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[5] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] - pow(E,yss[2])*pbar*(Gs[2] + Hs[4]) - pow(E,yss[11])*ebar*Hs[6] - pphi*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))*yss[5] + (zbar*Gs[5]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[1])/(1 + yss[5]) - (zbar*Hs[3]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(E,yss[0])*Gs[64]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[65] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[66] - pow(E,yss[3])*Gs[67] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[69] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[35] - pow(E,yss[2])*pbar*(Gs[66] + Hs[36]) - pow(E,yss[11])*ebar*Hs[38] - pphi*(pow(E,yss[1] + yss[7])*(Gs[65] + Gs[71]) + pow(E,yss[2])*pbar*(Gs[66] + Hs[36]))*yss[5] + (zbar*Gs[69]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[33])/(1 + yss[5]) - (zbar*Hs[35]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[104]=pow(E,yss[3])*Pssp*Gs[3]*Gs[67] + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(pow(E,yss[3])*Gs[3] - pow(E,xss[0])*(-1 + ddelta + zbar*Hs[0] + zbar*Hs[3])) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(-1 + Hs[0] + Hs[3])*(Hs[32] + Hs[35]) - pow(E,xss[0])*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[32] + Hs[35]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[3])*Gs[67] - pow(E,xss[0])*zbar*(Hs[32] + Hs[35]));
	Nxx_sp_s[105]=-(pphi*Pssp*Gs[69]*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[6] + Hs[0] + Hs[3])*(Gs[70] + Hs[32] + Hs[35]) - pphi*Pssp*Gs[5]*(pow(E,yss[1] + yss[7])*(Gs[65] + Gs[71]) + pow(E,yss[2])*pbar*(Gs[66] + Hs[36])) + (2*Pssp*zbar*Gs[5]*Gs[69]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[69]*Hs[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[5]*Hs[33])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[69]*Hs[3]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[5]*Hs[35]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[3]*Hs[33])/(1 + yss[5]) + (Pssp*zbar*Hs[1]*Hs[35])/(1 + yss[5]) + (Pssp*zbar*Hs[3]*Hs[35]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[1] + Gs[7])*(Gs[65] + Gs[71])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[2] + Hs[4])*(Gs[66] + Hs[36])*(1 + yss[5]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[5]) - Gs[10] + pow(E,xss[0])*kkappa*zbar*(Gs[6] + Hs[0] + Hs[3]) - (zbar*Gs[5]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[1])/(1 + yss[5]) + (zbar*Hs[3]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))*(1 + yss[5])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[69]) - Gs[74] + pow(E,xss[0])*kkappa*zbar*(Gs[70] + Hs[32] + Hs[35]) - (zbar*Gs[69]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[33])/(1 + yss[5]) + (zbar*Hs[35]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[65] + Gs[71]) + pow(E,yss[2])*pbar*(Gs[66] + Hs[36]))*(1 + yss[5]));
	Nxx_sp_s[106]=((-1 + nnus)*Gs[9] + nnus*Gs[10])*(dP2ssp*Gs[73] + dP1ssp*Gs[74]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*((-1 + nnus)*Gs[73] + nnus*Gs[74]);
	Nxx_sp_s[107]=(dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-Gs[5] - pow(E,bbar - xss[1])*ppsir*Hs[1] + Hs[5]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[1]*Hs[33] + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-Gs[69] - pow(E,bbar - xss[1])*ppsir*Hs[33] + Hs[37]);
	Nxx_sp_s[108]=pow(E,xss[0])*(-(Pssp*Gs[4]*Gs[68]) - (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(Gs[4] - Hs[0]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(Gs[68] - Hs[32]) + Pssp*Hs[0]*Hs[32]);
	Nxx_sp_s[109]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[65]) - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[65] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[66] + pow(E,yss[11])*Pssp*Gs[11]*Gs[75] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[2] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[2] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[3] + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha)) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[2] + pow(E,yss[11])*Gs[11] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] + pow(E,yss[2])*pbar*(Gs[2] + Hs[4])) - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[34] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[34] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[34] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[34] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[34] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[35] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[35] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[35] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[35] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[35] + pow(E,yss[2])*pbar*Pssp*(Gs[2] + Hs[4])*(Gs[66] + Hs[36]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[65]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[66] + pow(E,yss[11])*Gs[75] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[34] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[35] + pow(E,yss[2])*pbar*(Gs[66] + Hs[36]));
	Nxx_sp_s[110]=(Pssp*zbar*(Gs[11] - Hs[3])*Hs[33] + Pssp*zbar*Hs[1]*(Gs[75] - Hs[35]) - Pssp*zbar*(Gs[11] - Hs[3])*(Gs[75] - Hs[35])*xss[1] + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(pow(E,yss[11])*Gs[12] - zbar*Hs[1] + zbar*(Gs[11] - Hs[3])*xss[1]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[11])*Gs[76] - zbar*Hs[33] + zbar*(Gs[75] - Hs[35])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[111]=(-(Pssp*zbar*Hs[3]*Hs[33]) - Pssp*zbar*Hs[1]*Hs[35] - Pssp*(-1 + zbar)*Gs[11]*Gs[75]*xss[1] - Pssp*zbar*Hs[3]*Hs[35]*xss[1] + Pssp*zbar*Gs[75]*(Hs[1] + Hs[3]*xss[1]) - (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(pow(E,yss[11])*Gs[13]) + zbar*Hs[1] - (-1 + zbar)*Gs[11]*xss[1] + zbar*Hs[3]*xss[1]) + Pssp*zbar*Gs[11]*(Hs[33] + Hs[35]*xss[1]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(E,yss[11])*Gs[77]) + zbar*Hs[33] - (-1 + zbar)*Gs[75]*xss[1] + zbar*Hs[35]*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[112]=pow(E,yss[0] - yss[11])*Pssp*Gs[0]*Gs[64] + pow(E,yss[3] - yss[11])*Pssp*Gs[3]*Gs[67] - Pssp*Gs[11]*Gs[75] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[11]*Gs[75])/pow(E,yss[11]) - (Pssp*Gs[75]*(pow(E,yss[0])*Gs[0] + pow(E,yss[3])*Gs[3] - pow(E,yss[11])*Gs[11] + pow(E,yss[11])*ebar*Hs[6]))/pow(E,yss[11]) + ((dP2ssp*Gs[73] + dP1ssp*Gs[74])*(pow(E,yss[0])*Gs[0] + pow(E,yss[3])*Gs[3] - pow(E,yss[0])*Gs[11] - pow(E,yss[3])*Gs[11] - pow(E,yss[11])*ebar*Gs[11] + pow(E,yss[11])*Gs[14] + pow(E,yss[11])*ebar*Hs[6]))/pow(E,yss[11]) + ebar*Pssp*Hs[6]*Hs[38] - (Pssp*Gs[11]*(pow(E,yss[0])*Gs[64] + pow(E,yss[3])*Gs[67] - pow(E,yss[11])*Gs[75] + pow(E,yss[11])*ebar*Hs[38]))/pow(E,yss[11]) + ((dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[0])*Gs[64] + pow(E,yss[3])*Gs[67] - pow(E,yss[0])*Gs[75] - pow(E,yss[3])*Gs[75] - pow(E,yss[11])*ebar*Gs[75] + pow(E,yss[11])*Gs[78] + pow(E,yss[11])*ebar*Hs[38]))/pow(E,yss[11]);
	Nxx_sp_s[113]=(-((Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[73]*Hs[3])/pow(E,yss[8])) + (Pssp*pow(zbar,rrho)*Gs[73]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(E,yss[8]) - (Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[9]*Hs[35])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*Gs[9]*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]))/pow(E,yss[8]) - (Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[3]*Hs[35]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[35]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[3]*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*yss[9])/pow(E,yss[8]) - (Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*yss[9])/pow(E,yss[8]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-((pow(zbar,rrho)*Gs[9])/pow(E,yss[8])) + bbeta*Gs[15] - (rrho*rrhoz*pow(zbar,rrho)*Hs[3]*yss[9])/pow(E,yss[8]) + (pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*yss[9])/pow(E,yss[8])) + ((dP2ssp*Gs[9] + dP1ssp*Gs[10])*(bbeta*pow(E,yss[8])*Gs[79] + pow(zbar,rrho)*Gsp[120]*Hs[39]*yss[9] + pow(zbar,rrho)*(-Gs[73] + Gsp[8]*Hs[32]*yss[9] + Gsp[24]*Hs[33]*yss[9] + Gsp[40]*Hs[34]*yss[9] - rrho*rrhoz*Hs[35]*yss[9] + Gsp[56]*Hs[35]*yss[9] + Gsp[72]*Hs[36]*yss[9] + Gsp[88]*Hs[37]*yss[9] + Gsp[104]*Hs[38]*yss[9])))/pow(E,yss[8]))/bbeta;
	Nxx_sp_s[114]=-((dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[2]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[34];
	Nxx_sp_s[115]=-((dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[3]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[35];
	Nxx_sp_s[116]=-((dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[4]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(rrhop - Hs[36]);
	Nxx_sp_s[117]=-((dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[7]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[39];
	Nxx_sp_s[118]=-((dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[6]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[38];
	Nxx_sp_s[119]=-((dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[5]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[37];
	Nxx_sp_s[120]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[0]*Gs[80]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[1]*Gs[81] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])*(pow(E,yss[0])*Gs[80] - pow(pow(E,yss[1]),oomega)*Gs[81]) - pow(E,yss[8])*Pssp*Gs[8]*Gs[88] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[80] - pow(pow(E,yss[1]),oomega)*Gs[81])*Hs[7] + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])) - pow(E,yss[8])*Gs[8] + Hs[7]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])*Hs[47] + (Pssp*Hs[7]*Hs[47])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[80] - pow(pow(E,yss[1]),oomega)*Gs[81])) - pow(E,yss[8])*Gs[88] + Hs[47]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[121]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[81]) - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[81] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[81] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[82] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[82] - (pbar*pphi*Pssp*Gs[9]*Gs[85])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[5]*Gs[89])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[2] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[2] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[3] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[3] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[42] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[42] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[42] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[42] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[42] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[43] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[43] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[43] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[43] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[43] + (pbar*pphi*Pssp*Gs[9]*Gs[88]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[8]*Gs[89]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[8]*Gs[85]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[5]*Gs[88]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[8]*Gs[88]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[4]*Hs[44]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[44]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[4]*(Gs[85]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[89] - Gs[88]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[1] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[2] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[2] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[3] - pbar*Hs[4]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[81]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[82] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[42] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[43] - pbar*Hs[44]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[85]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[89] - Gs[88]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[122]=(-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[81] - pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[1]*Gs[81] + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[81] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[81] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[82] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[82] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[82] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[9]*Gs[85] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[89] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[2] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[3] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[3] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[42] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[42] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[42] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[43] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[43] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[43] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[43] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[43] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[9]*Gs[88]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[89]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[85]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[88]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[88]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[7]*Gs[87]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[87]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[7]*(Gs[85]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[89] - Gs[88]*yss[9])) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha) - pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[1] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] - pow(E,yss[7])*pphi*Gs[7]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9]))) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[81]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[81] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[42] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[43] - pow(E,yss[7])*pphi*Gs[87]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[85]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[89] - Gs[88]*yss[9])));
	Nxx_sp_s[123]=-(pow(E,yss[8])*Pssp*Gs[8]*Gs[88]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[85]*Hs[3])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[85]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[5]*Hs[43])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[5]*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[3]*Hs[43]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[43]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[3]*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*((bbeta*pow(E,yss[8])*Gs[5])/pow(zbar,rrho) - pow(E,yss[8])*Gs[8] + Gs[9] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[3]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*((bbeta*pow(E,yss[8])*Gs[85])/pow(zbar,rrho) - pow(E,yss[8])*Gs[88] + Gs[89] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[43]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[124]=-(kkappa*Pssp*Gs[9]*Gs[86]) + pow(E,yss[8])*Pssp*Gs[8]*Gs[88] - kkappa*Pssp*Gs[6]*Gs[89] + pow(E,yss[8])*iiota*Pssp*zbar*Gs[88]*(-1 + Hs[0] + Hs[3]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[40] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[40] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*Hs[40] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*Hs[40] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[40] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[40] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*Hs[40] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[0]*Hs[42] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[2]*Hs[42] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*Hs[42] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[42] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[42] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[0]*Hs[43] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[2]*Hs[43] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[3]*Hs[43] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[43])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[43] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[43] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[43])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7]))*Hs[43])/pow(zbar,rrho) - pow(E,yss[8])*iiota*Pssp*zbar*(Hs[40] + Hs[43]) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[8]*(Hs[40] + Hs[43]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[40] + Hs[43]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*(Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7]))*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[3]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[40] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[43] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[40] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[43] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47])))/pow(zbar,rrho) - kkappa*Pssp*Gs[6]*Gs[86]*yss[9] + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(pow(E,yss[8])*Gs[8] - kkappa*Gs[9] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(-1 + Hs[0] + Hs[3]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])))/pow(zbar,rrho) - kkappa*Gs[6]*yss[9]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[8])*Gs[88] - kkappa*Gs[89] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[43])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[40] + Hs[43]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[40] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[43] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47])))/pow(zbar,rrho) - kkappa*Gs[86]*yss[9]);
	Nxx_sp_s[125]=-(Pssp*Gs[6]*Gs[86]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-Gs[6] + iiota*zbar*Hs[0] + iiota*zbar*(-1 + Hs[3])) - iiota*Pssp*zbar*(Hs[40] + Hs[43]) + iiota*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[40] + Hs[43]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-Gs[86] + iiota*zbar*(Hs[40] + Hs[43]));
	Nxx_sp_s[126]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[1]*Gs[81] - pow(E,yss[7])*Pssp*Gs[7]*Gs[87] + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[81] - pow(E,yss[7])*Gs[87]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[1] - pow(E,yss[7])*Gs[7])*(dP2ssp*Gs[89] + dP1ssp*Gs[90]);
	Nxx_sp_s[127]=-(pow(E,yss[0])*Pssp*Gs[0]*Gs[80]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[81] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[81] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[81] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[82] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[82] - pow(E,yss[3])*Pssp*Gs[3]*Gs[83] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[2] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[2] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[3] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[3] - pphi*Pssp*Gs[85]*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4])) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[42] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[42] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[43] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[43] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[43] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[43] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[43] - pow(E,yss[2])*pbar*Pssp*(Gs[2] + Hs[4])*(Gs[82] + Hs[44]) - pphi*Pssp*Gs[5]*(pow(E,yss[1] + yss[7])*(Gs[81] + Gs[87]) + pow(E,yss[2])*pbar*(Gs[82] + Hs[44])) - pow(E,yss[11])*ebar*Pssp*Hs[6]*Hs[46] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[1] + Gs[7])*(Gs[81] + Gs[87])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[2] + Hs[4])*(Gs[82] + Hs[44])*yss[5] - (2*Pssp*zbar*Gs[5]*Gs[85]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[85]*Hs[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[5]*Hs[41])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[85]*Hs[3]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[5]*Hs[43]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[3]*Hs[41])/(1 + yss[5]) - (Pssp*zbar*Hs[1]*Hs[43])/(1 + yss[5]) - (Pssp*zbar*Hs[3]*Hs[43]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha) - pow(E,yss[0])*Gs[0] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[2] - pow(E,yss[3])*Gs[3] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[5] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] - pow(E,yss[2])*pbar*(Gs[2] + Hs[4]) - pow(E,yss[11])*ebar*Hs[6] - pphi*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))*yss[5] + (zbar*Gs[5]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[1])/(1 + yss[5]) - (zbar*Hs[3]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(E,yss[0])*Gs[80]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[81] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[82] - pow(E,yss[3])*Gs[83] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[85] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[43] - pow(E,yss[2])*pbar*(Gs[82] + Hs[44]) - pow(E,yss[11])*ebar*Hs[46] - pphi*(pow(E,yss[1] + yss[7])*(Gs[81] + Gs[87]) + pow(E,yss[2])*pbar*(Gs[82] + Hs[44]))*yss[5] + (zbar*Gs[85]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[41])/(1 + yss[5]) - (zbar*Hs[43]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[128]=pow(E,yss[3])*Pssp*Gs[3]*Gs[83] + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(pow(E,yss[3])*Gs[3] - pow(E,xss[0])*(-1 + ddelta + zbar*Hs[0] + zbar*Hs[3])) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(-1 + Hs[0] + Hs[3])*(Hs[40] + Hs[43]) - pow(E,xss[0])*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[40] + Hs[43]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[3])*Gs[83] - pow(E,xss[0])*zbar*(Hs[40] + Hs[43]));
	Nxx_sp_s[129]=-(pphi*Pssp*Gs[85]*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[6] + Hs[0] + Hs[3])*(Gs[86] + Hs[40] + Hs[43]) - pphi*Pssp*Gs[5]*(pow(E,yss[1] + yss[7])*(Gs[81] + Gs[87]) + pow(E,yss[2])*pbar*(Gs[82] + Hs[44])) + (2*Pssp*zbar*Gs[5]*Gs[85]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[85]*Hs[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[5]*Hs[41])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[85]*Hs[3]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[5]*Hs[43]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[3]*Hs[41])/(1 + yss[5]) + (Pssp*zbar*Hs[1]*Hs[43])/(1 + yss[5]) + (Pssp*zbar*Hs[3]*Hs[43]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[1] + Gs[7])*(Gs[81] + Gs[87])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[2] + Hs[4])*(Gs[82] + Hs[44])*(1 + yss[5]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[5]) - Gs[10] + pow(E,xss[0])*kkappa*zbar*(Gs[6] + Hs[0] + Hs[3]) - (zbar*Gs[5]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[1])/(1 + yss[5]) + (zbar*Hs[3]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))*(1 + yss[5])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[85]) - Gs[90] + pow(E,xss[0])*kkappa*zbar*(Gs[86] + Hs[40] + Hs[43]) - (zbar*Gs[85]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[41])/(1 + yss[5]) + (zbar*Hs[43]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[81] + Gs[87]) + pow(E,yss[2])*pbar*(Gs[82] + Hs[44]))*(1 + yss[5]));
	Nxx_sp_s[130]=((-1 + nnus)*Gs[9] + nnus*Gs[10])*(dP2ssp*Gs[89] + dP1ssp*Gs[90]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*((-1 + nnus)*Gs[89] + nnus*Gs[90]);
	Nxx_sp_s[131]=(dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-Gs[5] - pow(E,bbar - xss[1])*ppsir*Hs[1] + Hs[5]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[1]*Hs[41] + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-Gs[85] - pow(E,bbar - xss[1])*ppsir*Hs[41] + Hs[45]);
	Nxx_sp_s[132]=pow(E,xss[0])*(-(Pssp*Gs[4]*Gs[84]) - (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(Gs[4] - Hs[0]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(Gs[84] - Hs[40]) + Pssp*Hs[0]*Hs[40]);
	Nxx_sp_s[133]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[81]) - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[81] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[82] + pow(E,yss[11])*Pssp*Gs[11]*Gs[91] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[2] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[2] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[3] + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha)) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[2] + pow(E,yss[11])*Gs[11] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] + pow(E,yss[2])*pbar*(Gs[2] + Hs[4])) - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[42] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[42] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[42] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[42] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[42] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[43] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[43] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[43] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[43] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[43] + pow(E,yss[2])*pbar*Pssp*(Gs[2] + Hs[4])*(Gs[82] + Hs[44]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[81]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[82] + pow(E,yss[11])*Gs[91] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[42] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[43] + pow(E,yss[2])*pbar*(Gs[82] + Hs[44]));
	Nxx_sp_s[134]=(Pssp*zbar*(Gs[11] - Hs[3])*Hs[41] + Pssp*zbar*Hs[1]*(Gs[91] - Hs[43]) - Pssp*zbar*(Gs[11] - Hs[3])*(Gs[91] - Hs[43])*xss[1] + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(pow(E,yss[11])*Gs[12] - zbar*Hs[1] + zbar*(Gs[11] - Hs[3])*xss[1]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[11])*Gs[92] - zbar*Hs[41] + zbar*(Gs[91] - Hs[43])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[135]=(-(Pssp*zbar*Hs[3]*Hs[41]) - Pssp*zbar*Hs[1]*Hs[43] - Pssp*(-1 + zbar)*Gs[11]*Gs[91]*xss[1] - Pssp*zbar*Hs[3]*Hs[43]*xss[1] + Pssp*zbar*Gs[91]*(Hs[1] + Hs[3]*xss[1]) - (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(pow(E,yss[11])*Gs[13]) + zbar*Hs[1] - (-1 + zbar)*Gs[11]*xss[1] + zbar*Hs[3]*xss[1]) + Pssp*zbar*Gs[11]*(Hs[41] + Hs[43]*xss[1]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(E,yss[11])*Gs[93]) + zbar*Hs[41] - (-1 + zbar)*Gs[91]*xss[1] + zbar*Hs[43]*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[136]=pow(E,yss[0] - yss[11])*Pssp*Gs[0]*Gs[80] + pow(E,yss[3] - yss[11])*Pssp*Gs[3]*Gs[83] - Pssp*Gs[11]*Gs[91] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[11]*Gs[91])/pow(E,yss[11]) - (Pssp*Gs[91]*(pow(E,yss[0])*Gs[0] + pow(E,yss[3])*Gs[3] - pow(E,yss[11])*Gs[11] + pow(E,yss[11])*ebar*Hs[6]))/pow(E,yss[11]) + ((dP2ssp*Gs[89] + dP1ssp*Gs[90])*(pow(E,yss[0])*Gs[0] + pow(E,yss[3])*Gs[3] - pow(E,yss[0])*Gs[11] - pow(E,yss[3])*Gs[11] - pow(E,yss[11])*ebar*Gs[11] + pow(E,yss[11])*Gs[14] + pow(E,yss[11])*ebar*Hs[6]))/pow(E,yss[11]) + ebar*Pssp*Hs[6]*Hs[46] - (Pssp*Gs[11]*(pow(E,yss[0])*Gs[80] + pow(E,yss[3])*Gs[83] - pow(E,yss[11])*Gs[91] + pow(E,yss[11])*ebar*Hs[46]))/pow(E,yss[11]) + ((dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[0])*Gs[80] + pow(E,yss[3])*Gs[83] - pow(E,yss[0])*Gs[91] - pow(E,yss[3])*Gs[91] - pow(E,yss[11])*ebar*Gs[91] + pow(E,yss[11])*Gs[94] + pow(E,yss[11])*ebar*Hs[46]))/pow(E,yss[11]);
	Nxx_sp_s[137]=(-((Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[89]*Hs[3])/pow(E,yss[8])) + (Pssp*pow(zbar,rrho)*Gs[89]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(E,yss[8]) - (Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[9]*Hs[43])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*Gs[9]*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]))/pow(E,yss[8]) - (Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[3]*Hs[43]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[43]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[3]*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*yss[9])/pow(E,yss[8]) - (Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*yss[9])/pow(E,yss[8]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-((pow(zbar,rrho)*Gs[9])/pow(E,yss[8])) + bbeta*Gs[15] - (rrho*rrhoz*pow(zbar,rrho)*Hs[3]*yss[9])/pow(E,yss[8]) + (pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*yss[9])/pow(E,yss[8])) + ((dP2ssp*Gs[9] + dP1ssp*Gs[10])*(bbeta*pow(E,yss[8])*Gs[95] + pow(zbar,rrho)*Gsp[120]*Hs[47]*yss[9] + pow(zbar,rrho)*(-Gs[89] + Gsp[8]*Hs[40]*yss[9] + Gsp[24]*Hs[41]*yss[9] + Gsp[40]*Hs[42]*yss[9] + (-(rrho*rrhoz) + Gsp[56])*Hs[43]*yss[9] + Gsp[72]*Hs[44]*yss[9] + Gsp[88]*Hs[45]*yss[9] + Gsp[104]*Hs[46]*yss[9])))/pow(E,yss[8]))/bbeta;
	Nxx_sp_s[138]=-((dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[2]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[42];
	Nxx_sp_s[139]=-((dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[3]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[43];
	Nxx_sp_s[140]=-((dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[4]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[44];
	Nxx_sp_s[141]=-((dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[7]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[47];
	Nxx_sp_s[142]=-((dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[6]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[46];
	Nxx_sp_s[143]=-((dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[5]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(rrhor - Hs[45]);
	Nxx_sp_s[144]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[0]*Gs[96]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[1]*Gs[97] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])*(pow(E,yss[0])*Gs[96] - pow(pow(E,yss[1]),oomega)*Gs[97]) - pow(E,yss[8])*Pssp*Gs[8]*Gs[104] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[96] - pow(pow(E,yss[1]),oomega)*Gs[97])*Hs[7] + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])) - pow(E,yss[8])*Gs[8] + Hs[7]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])*Hs[55] + (Pssp*Hs[7]*Hs[55])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[96] - pow(pow(E,yss[1]),oomega)*Gs[97])) - pow(E,yss[8])*Gs[104] + Hs[55]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[145]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[97]) - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[97] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[97] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[98] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[98] - (pbar*pphi*Pssp*Gs[9]*Gs[101])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[5]*Gs[105])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[2] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[2] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[3] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[3] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[50] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[50] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[50] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[50] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[50] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[51] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[51] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[51] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[51] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[51] + (pbar*pphi*Pssp*Gs[9]*Gs[104]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[8]*Gs[105]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[8]*Gs[101]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[5]*Gs[104]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[8]*Gs[104]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[4]*Hs[52]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[52]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[4]*(Gs[101]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[105] - Gs[104]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[1] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[2] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[2] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[3] - pbar*Hs[4]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[97]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[98] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[50] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[51] - pbar*Hs[52]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[101]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[105] - Gs[104]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[146]=(-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[97] - pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[1]*Gs[97] + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[97] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[97] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[98] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[98] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[98] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[9]*Gs[101] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[105] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[2] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[3] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[3] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[50] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[50] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[50] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[51] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[51] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[51] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[51] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[51] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[9]*Gs[104]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[105]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[101]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[104]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[104]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[7]*Gs[103]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[103]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[7]*(Gs[101]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[105] - Gs[104]*yss[9])) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha) - pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[1] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] - pow(E,yss[7])*pphi*Gs[7]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9]))) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[97]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[97] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[50] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[51] - pow(E,yss[7])*pphi*Gs[103]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[101]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[105] - Gs[104]*yss[9])));
	Nxx_sp_s[147]=-(pow(E,yss[8])*Pssp*Gs[8]*Gs[104]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[101]*Hs[3])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[101]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[5]*Hs[51])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[5]*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[3]*Hs[51]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[51]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[3]*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*((bbeta*pow(E,yss[8])*Gs[5])/pow(zbar,rrho) - pow(E,yss[8])*Gs[8] + Gs[9] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[3]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*((bbeta*pow(E,yss[8])*Gs[101])/pow(zbar,rrho) - pow(E,yss[8])*Gs[104] + Gs[105] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[51]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[148]=-(kkappa*Pssp*Gs[9]*Gs[102]) + pow(E,yss[8])*Pssp*Gs[8]*Gs[104] - kkappa*Pssp*Gs[6]*Gs[105] + pow(E,yss[8])*iiota*Pssp*zbar*Gs[104]*(-1 + Hs[0] + Hs[3]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[48] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[48] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*Hs[48] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*Hs[48] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[48] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[48] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*Hs[48] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[0]*Hs[50] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[2]*Hs[50] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*Hs[50] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[50] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[50] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[0]*Hs[51] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[2]*Hs[51] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[3]*Hs[51] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[51])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[51] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[51] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[51])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7]))*Hs[51])/pow(zbar,rrho) - pow(E,yss[8])*iiota*Pssp*zbar*(Hs[48] + Hs[51]) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[8]*(Hs[48] + Hs[51]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[48] + Hs[51]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*(Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7]))*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[3]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[48] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[51] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[48] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[51] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55])))/pow(zbar,rrho) - kkappa*Pssp*Gs[6]*Gs[102]*yss[9] + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(pow(E,yss[8])*Gs[8] - kkappa*Gs[9] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(-1 + Hs[0] + Hs[3]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])))/pow(zbar,rrho) - kkappa*Gs[6]*yss[9]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[8])*Gs[104] - kkappa*Gs[105] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[51])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[48] + Hs[51]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[48] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[51] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55])))/pow(zbar,rrho) - kkappa*Gs[102]*yss[9]);
	Nxx_sp_s[149]=-(Pssp*Gs[6]*Gs[102]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-Gs[6] + iiota*zbar*Hs[0] + iiota*zbar*(-1 + Hs[3])) - iiota*Pssp*zbar*(Hs[48] + Hs[51]) + iiota*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[48] + Hs[51]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-Gs[102] + iiota*zbar*(Hs[48] + Hs[51]));
	Nxx_sp_s[150]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[1]*Gs[97] - pow(E,yss[7])*Pssp*Gs[7]*Gs[103] + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[97] - pow(E,yss[7])*Gs[103]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[1] - pow(E,yss[7])*Gs[7])*(dP2ssp*Gs[105] + dP1ssp*Gs[106]);
	Nxx_sp_s[151]=-(pow(E,yss[0])*Pssp*Gs[0]*Gs[96]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[97] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[97] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[97] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[98] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[98] - pow(E,yss[3])*Pssp*Gs[3]*Gs[99] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[2] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[2] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[3] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[3] - pphi*Pssp*Gs[101]*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4])) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[50] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[50] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[51] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[51] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[51] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[51] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[51] - pow(E,yss[2])*pbar*Pssp*(Gs[2] + Hs[4])*(Gs[98] + Hs[52]) - pphi*Pssp*Gs[5]*(pow(E,yss[1] + yss[7])*(Gs[97] + Gs[103]) + pow(E,yss[2])*pbar*(Gs[98] + Hs[52])) - pow(E,yss[11])*ebar*Pssp*Hs[6]*Hs[54] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[1] + Gs[7])*(Gs[97] + Gs[103])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[2] + Hs[4])*(Gs[98] + Hs[52])*yss[5] - (2*Pssp*zbar*Gs[5]*Gs[101]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[101]*Hs[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[5]*Hs[49])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[101]*Hs[3]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[5]*Hs[51]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[3]*Hs[49])/(1 + yss[5]) - (Pssp*zbar*Hs[1]*Hs[51])/(1 + yss[5]) - (Pssp*zbar*Hs[3]*Hs[51]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha) - pow(E,yss[0])*Gs[0] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[2] - pow(E,yss[3])*Gs[3] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[5] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] - pow(E,yss[2])*pbar*(Gs[2] + Hs[4]) - pow(E,yss[11])*ebar*Hs[6] - pphi*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))*yss[5] + (zbar*Gs[5]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[1])/(1 + yss[5]) - (zbar*Hs[3]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(E,yss[0])*Gs[96]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[97] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[98] - pow(E,yss[3])*Gs[99] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[101] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[51] - pow(E,yss[2])*pbar*(Gs[98] + Hs[52]) - pow(E,yss[11])*ebar*Hs[54] - pphi*(pow(E,yss[1] + yss[7])*(Gs[97] + Gs[103]) + pow(E,yss[2])*pbar*(Gs[98] + Hs[52]))*yss[5] + (zbar*Gs[101]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[49])/(1 + yss[5]) - (zbar*Hs[51]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[152]=pow(E,yss[3])*Pssp*Gs[3]*Gs[99] + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(pow(E,yss[3])*Gs[3] - pow(E,xss[0])*(-1 + ddelta + zbar*Hs[0] + zbar*Hs[3])) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(-1 + Hs[0] + Hs[3])*(Hs[48] + Hs[51]) - pow(E,xss[0])*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[48] + Hs[51]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[3])*Gs[99] - pow(E,xss[0])*zbar*(Hs[48] + Hs[51]));
	Nxx_sp_s[153]=-(pphi*Pssp*Gs[101]*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[6] + Hs[0] + Hs[3])*(Gs[102] + Hs[48] + Hs[51]) - pphi*Pssp*Gs[5]*(pow(E,yss[1] + yss[7])*(Gs[97] + Gs[103]) + pow(E,yss[2])*pbar*(Gs[98] + Hs[52])) + (2*Pssp*zbar*Gs[5]*Gs[101]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[101]*Hs[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[5]*Hs[49])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[101]*Hs[3]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[5]*Hs[51]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[3]*Hs[49])/(1 + yss[5]) + (Pssp*zbar*Hs[1]*Hs[51])/(1 + yss[5]) + (Pssp*zbar*Hs[3]*Hs[51]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[1] + Gs[7])*(Gs[97] + Gs[103])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[2] + Hs[4])*(Gs[98] + Hs[52])*(1 + yss[5]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[5]) - Gs[10] + pow(E,xss[0])*kkappa*zbar*(Gs[6] + Hs[0] + Hs[3]) - (zbar*Gs[5]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[1])/(1 + yss[5]) + (zbar*Hs[3]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))*(1 + yss[5])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[101]) - Gs[106] + pow(E,xss[0])*kkappa*zbar*(Gs[102] + Hs[48] + Hs[51]) - (zbar*Gs[101]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[49])/(1 + yss[5]) + (zbar*Hs[51]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[97] + Gs[103]) + pow(E,yss[2])*pbar*(Gs[98] + Hs[52]))*(1 + yss[5]));
	Nxx_sp_s[154]=((-1 + nnus)*Gs[9] + nnus*Gs[10])*(dP2ssp*Gs[105] + dP1ssp*Gs[106]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*((-1 + nnus)*Gs[105] + nnus*Gs[106]);
	Nxx_sp_s[155]=(dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-Gs[5] - pow(E,bbar - xss[1])*ppsir*Hs[1] + Hs[5]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[1]*Hs[49] + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-Gs[101] - pow(E,bbar - xss[1])*ppsir*Hs[49] + Hs[53]);
	Nxx_sp_s[156]=pow(E,xss[0])*(-(Pssp*Gs[4]*Gs[100]) - (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(Gs[4] - Hs[0]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(Gs[100] - Hs[48]) + Pssp*Hs[0]*Hs[48]);
	Nxx_sp_s[157]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[97]) - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[97] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[98] + pow(E,yss[11])*Pssp*Gs[11]*Gs[107] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[2] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[2] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[3] + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha)) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[2] + pow(E,yss[11])*Gs[11] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] + pow(E,yss[2])*pbar*(Gs[2] + Hs[4])) - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[50] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[50] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[50] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[50] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[50] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[51] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[51] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[51] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[51] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[51] + pow(E,yss[2])*pbar*Pssp*(Gs[2] + Hs[4])*(Gs[98] + Hs[52]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[97]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[98] + pow(E,yss[11])*Gs[107] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[50] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[51] + pow(E,yss[2])*pbar*(Gs[98] + Hs[52]));
	Nxx_sp_s[158]=(Pssp*zbar*(Gs[11] - Hs[3])*Hs[49] + Pssp*zbar*Hs[1]*(Gs[107] - Hs[51]) - Pssp*zbar*(Gs[11] - Hs[3])*(Gs[107] - Hs[51])*xss[1] + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(pow(E,yss[11])*Gs[12] - zbar*Hs[1] + zbar*(Gs[11] - Hs[3])*xss[1]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[11])*Gs[108] - zbar*Hs[49] + zbar*(Gs[107] - Hs[51])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[159]=(-(Pssp*zbar*Hs[3]*Hs[49]) - Pssp*zbar*Hs[1]*Hs[51] - Pssp*(-1 + zbar)*Gs[11]*Gs[107]*xss[1] - Pssp*zbar*Hs[3]*Hs[51]*xss[1] + Pssp*zbar*Gs[107]*(Hs[1] + Hs[3]*xss[1]) - (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(pow(E,yss[11])*Gs[13]) + zbar*Hs[1] - (-1 + zbar)*Gs[11]*xss[1] + zbar*Hs[3]*xss[1]) + Pssp*zbar*Gs[11]*(Hs[49] + Hs[51]*xss[1]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(E,yss[11])*Gs[109]) + zbar*Hs[49] - (-1 + zbar)*Gs[107]*xss[1] + zbar*Hs[51]*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[160]=pow(E,yss[0] - yss[11])*Pssp*Gs[0]*Gs[96] + pow(E,yss[3] - yss[11])*Pssp*Gs[3]*Gs[99] - Pssp*Gs[11]*Gs[107] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[11]*Gs[107])/pow(E,yss[11]) - (Pssp*Gs[107]*(pow(E,yss[0])*Gs[0] + pow(E,yss[3])*Gs[3] - pow(E,yss[11])*Gs[11] + pow(E,yss[11])*ebar*Hs[6]))/pow(E,yss[11]) + ((dP2ssp*Gs[105] + dP1ssp*Gs[106])*(pow(E,yss[0])*Gs[0] + pow(E,yss[3])*Gs[3] - pow(E,yss[0])*Gs[11] - pow(E,yss[3])*Gs[11] - pow(E,yss[11])*ebar*Gs[11] + pow(E,yss[11])*Gs[14] + pow(E,yss[11])*ebar*Hs[6]))/pow(E,yss[11]) + ebar*Pssp*Hs[6]*Hs[54] - (Pssp*Gs[11]*(pow(E,yss[0])*Gs[96] + pow(E,yss[3])*Gs[99] - pow(E,yss[11])*Gs[107] + pow(E,yss[11])*ebar*Hs[54]))/pow(E,yss[11]) + ((dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[0])*Gs[96] + pow(E,yss[3])*Gs[99] - pow(E,yss[0])*Gs[107] - pow(E,yss[3])*Gs[107] - pow(E,yss[11])*ebar*Gs[107] + pow(E,yss[11])*Gs[110] + pow(E,yss[11])*ebar*Hs[54]))/pow(E,yss[11]);
	Nxx_sp_s[161]=(-((Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[105]*Hs[3])/pow(E,yss[8])) + (Pssp*pow(zbar,rrho)*Gs[105]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(E,yss[8]) - (Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[9]*Hs[51])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*Gs[9]*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]))/pow(E,yss[8]) - (Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[3]*Hs[51]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[51]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[3]*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*yss[9])/pow(E,yss[8]) - (Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*yss[9])/pow(E,yss[8]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-((pow(zbar,rrho)*Gs[9])/pow(E,yss[8])) + bbeta*Gs[15] - (rrho*rrhoz*pow(zbar,rrho)*Hs[3]*yss[9])/pow(E,yss[8]) + (pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*yss[9])/pow(E,yss[8])) + ((dP2ssp*Gs[9] + dP1ssp*Gs[10])*(bbeta*pow(E,yss[8])*Gs[111] + pow(zbar,rrho)*Gsp[120]*Hs[55]*yss[9] + pow(zbar,rrho)*(-Gs[105] + (-(rrho*rrhoz) + Gsp[56])*Hs[51]*yss[9] + (Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54])*yss[9])))/pow(E,yss[8]))/bbeta;
	Nxx_sp_s[162]=-((dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[2]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[50];
	Nxx_sp_s[163]=-((dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[3]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[51];
	Nxx_sp_s[164]=-((dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[4]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[52];
	Nxx_sp_s[165]=-((dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[7]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[55];
	Nxx_sp_s[166]=-((dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[6]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(rrhoe - Hs[54]);
	Nxx_sp_s[167]=-((dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[5]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[53];
	Nxx_sp_s[168]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[0]*Gs[112]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[1]*Gs[113] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])*(pow(E,yss[0])*Gs[112] - pow(pow(E,yss[1]),oomega)*Gs[113]) - pow(E,yss[8])*Pssp*Gs[8]*Gs[120] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[112] - pow(pow(E,yss[1]),oomega)*Gs[113])*Hs[7] + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])) - pow(E,yss[8])*Gs[8] + Hs[7]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])*Hs[63] + (Pssp*Hs[7]*Hs[63])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[112] - pow(pow(E,yss[1]),oomega)*Gs[113])) - pow(E,yss[8])*Gs[120] + Hs[63]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[169]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[113]) - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[113] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[113] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[114] - (pbar*pphi*Pssp*Gs[9]*Gs[117])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[5]*Gs[121])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[2] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[2] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[3] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[3] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[58] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[58] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[58] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[58] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[58] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[59] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[59] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[59] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[59] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[59] + (pbar*pphi*Pssp*Gs[9]*Gs[120]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[8]*Gs[121]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[8]*Gs[117]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[5]*Gs[120]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[8]*Gs[120]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[4]*Hs[60]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[60]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[4]*(Gs[117]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[121] - Gs[120]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[1] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[2] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[2] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[3] - pbar*Hs[4]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[113]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[58] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[59] - pbar*Hs[60]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[117]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[121] - Gs[120]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[170]=(-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[113] - pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[1]*Gs[113] + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[113] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[113] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[114] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[114] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[114] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[9]*Gs[117] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[121] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[2] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[3] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[3] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[58] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[58] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[58] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[59] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[59] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[59] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[59] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[59] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[9]*Gs[120]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[121]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[117]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[120]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[120]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[7]*Gs[119]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[119]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[7]*(Gs[117]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[121] - Gs[120]*yss[9])) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha) - pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[1] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] - pow(E,yss[7])*pphi*Gs[7]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9]))) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[113]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[113] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[58] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[59] - pow(E,yss[7])*pphi*Gs[119]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[117]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[121] - Gs[120]*yss[9])));
	Nxx_sp_s[171]=-(pow(E,yss[8])*Pssp*Gs[8]*Gs[120]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[117]*Hs[3])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[117]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[5]*Hs[59])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[5]*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[3]*Hs[59]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[59]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[3]*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*((bbeta*pow(E,yss[8])*Gs[5])/pow(zbar,rrho) - pow(E,yss[8])*Gs[8] + Gs[9] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[3]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*((bbeta*pow(E,yss[8])*Gs[117])/pow(zbar,rrho) - pow(E,yss[8])*Gs[120] + Gs[121] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[59]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[172]=-(kkappa*Pssp*Gs[9]*Gs[118]) + pow(E,yss[8])*Pssp*Gs[8]*Gs[120] - kkappa*Pssp*Gs[6]*Gs[121] + pow(E,yss[8])*iiota*Pssp*zbar*Gs[120]*(-1 + Hs[0] + Hs[3]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[56] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[56] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*Hs[56] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*Hs[56] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[56] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[56] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*Hs[56] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[0]*Hs[58] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[2]*Hs[58] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*Hs[58] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[58] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[58] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[0]*Hs[59] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[2]*Hs[59] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[3]*Hs[59] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[59])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[59] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[59] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[59])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7]))*Hs[59])/pow(zbar,rrho) - pow(E,yss[8])*iiota*Pssp*zbar*(Hs[56] + Hs[59]) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[8]*(Hs[56] + Hs[59]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[56] + Hs[59]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*((-1 + Gsp[4])*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + rrhoz*Hs[59] + Gsp[52]*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*((-1 + Gsp[4])*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + rrhoz*Hs[59] + Gsp[52]*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*(Gsp[4]*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + (rrhoz + Gsp[52])*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7]))*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[3]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[56] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[59] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + rrhoz*Hs[59] + Gsp[52]*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[56] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[59] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + rrhoz*Hs[59] + Gsp[52]*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63])))/pow(zbar,rrho) - kkappa*Pssp*Gs[6]*Gs[118]*yss[9] + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(pow(E,yss[8])*Gs[8] - kkappa*Gs[9] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(-1 + Hs[0] + Hs[3]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])))/pow(zbar,rrho) - kkappa*Gs[6]*yss[9]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[8])*Gs[120] - kkappa*Gs[121] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[59])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[56] + Hs[59]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[56] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[59] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + rrhoz*Hs[59] + Gsp[52]*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63])))/pow(zbar,rrho) - kkappa*Gs[118]*yss[9]);
	Nxx_sp_s[173]=-(Pssp*Gs[6]*Gs[118]) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-Gs[6] + iiota*zbar*Hs[0] + iiota*zbar*(-1 + Hs[3])) - iiota*Pssp*zbar*(Hs[56] + Hs[59]) + iiota*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[56] + Hs[59]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-Gs[118] + iiota*zbar*(Hs[56] + Hs[59]));
	Nxx_sp_s[174]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[1]*Gs[113] - pow(E,yss[7])*Pssp*Gs[7]*Gs[119] + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[113] - pow(E,yss[7])*Gs[119]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[1] - pow(E,yss[7])*Gs[7])*(dP2ssp*Gs[121] + dP1ssp*Gs[122]);
	Nxx_sp_s[175]=-(pow(E,yss[0])*Pssp*Gs[0]*Gs[112]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[113] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[113] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[113] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[114] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[114] - pow(E,yss[3])*Pssp*Gs[3]*Gs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[2] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[2] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[3] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[3] - pphi*Pssp*Gs[117]*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4])) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[58] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[58] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[59] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[59] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[59] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[59] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[59] - pow(E,yss[2])*pbar*Pssp*(Gs[2] + Hs[4])*(Gs[114] + Hs[60]) - pphi*Pssp*Gs[5]*(pow(E,yss[1] + yss[7])*(Gs[113] + Gs[119]) + pow(E,yss[2])*pbar*(Gs[114] + Hs[60])) - pow(E,yss[11])*ebar*Pssp*Hs[6]*Hs[62] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[1] + Gs[7])*(Gs[113] + Gs[119])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[2] + Hs[4])*(Gs[114] + Hs[60])*yss[5] - (2*Pssp*zbar*Gs[5]*Gs[117]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[117]*Hs[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[5]*Hs[57])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[117]*Hs[3]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[5]*Hs[59]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[3]*Hs[57])/(1 + yss[5]) - (Pssp*zbar*Hs[1]*Hs[59])/(1 + yss[5]) - (Pssp*zbar*Hs[3]*Hs[59]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha) - pow(E,yss[0])*Gs[0] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[2] - pow(E,yss[3])*Gs[3] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[5] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] - pow(E,yss[2])*pbar*(Gs[2] + Hs[4]) - pow(E,yss[11])*ebar*Hs[6] - pphi*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))*yss[5] + (zbar*Gs[5]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[1])/(1 + yss[5]) - (zbar*Hs[3]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(E,yss[0])*Gs[112]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[113] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[114] - pow(E,yss[3])*Gs[115] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[117] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[59] - pow(E,yss[2])*pbar*(Gs[114] + Hs[60]) - pow(E,yss[11])*ebar*Hs[62] - pphi*(pow(E,yss[1] + yss[7])*(Gs[113] + Gs[119]) + pow(E,yss[2])*pbar*(Gs[114] + Hs[60]))*yss[5] + (zbar*Gs[117]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[57])/(1 + yss[5]) - (zbar*Hs[59]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[176]=pow(E,yss[3])*Pssp*Gs[3]*Gs[115] + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(pow(E,yss[3])*Gs[3] - pow(E,xss[0])*(-1 + ddelta + zbar*Hs[0] + zbar*Hs[3])) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(-1 + Hs[0] + Hs[3])*(Hs[56] + Hs[59]) - pow(E,xss[0])*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[56] + Hs[59]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[3])*Gs[115] - pow(E,xss[0])*zbar*(Hs[56] + Hs[59]));
	Nxx_sp_s[177]=-(pphi*Pssp*Gs[117]*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[6] + Hs[0] + Hs[3])*(Gs[118] + Hs[56] + Hs[59]) - pphi*Pssp*Gs[5]*(pow(E,yss[1] + yss[7])*(Gs[113] + Gs[119]) + pow(E,yss[2])*pbar*(Gs[114] + Hs[60])) + (2*Pssp*zbar*Gs[5]*Gs[117]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[117]*Hs[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[5]*Hs[57])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[117]*Hs[3]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[5]*Hs[59]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[3]*Hs[57])/(1 + yss[5]) + (Pssp*zbar*Hs[1]*Hs[59])/(1 + yss[5]) + (Pssp*zbar*Hs[3]*Hs[59]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[1] + Gs[7])*(Gs[113] + Gs[119])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[2] + Hs[4])*(Gs[114] + Hs[60])*(1 + yss[5]) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[5]) - Gs[10] + pow(E,xss[0])*kkappa*zbar*(Gs[6] + Hs[0] + Hs[3]) - (zbar*Gs[5]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[1])/(1 + yss[5]) + (zbar*Hs[3]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))*(1 + yss[5])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[117]) - Gs[122] + pow(E,xss[0])*kkappa*zbar*(Gs[118] + Hs[56] + Hs[59]) - (zbar*Gs[117]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[57])/(1 + yss[5]) + (zbar*Hs[59]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[113] + Gs[119]) + pow(E,yss[2])*pbar*(Gs[114] + Hs[60]))*(1 + yss[5]));
	Nxx_sp_s[178]=((-1 + nnus)*Gs[9] + nnus*Gs[10])*(dP2ssp*Gs[121] + dP1ssp*Gs[122]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*((-1 + nnus)*Gs[121] + nnus*Gs[122]);
	Nxx_sp_s[179]=(dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-Gs[5] - pow(E,bbar - xss[1])*ppsir*Hs[1] + Hs[5]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[1]*Hs[57] + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-Gs[117] - pow(E,bbar - xss[1])*ppsir*Hs[57] + Hs[61]);
	Nxx_sp_s[180]=pow(E,xss[0])*(-(Pssp*Gs[4]*Gs[116]) - (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(Gs[4] - Hs[0]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(Gs[116] - Hs[56]) + Pssp*Hs[0]*Hs[56]);
	Nxx_sp_s[181]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[113]) - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[113] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[114] + pow(E,yss[11])*Pssp*Gs[11]*Gs[123] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[2] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[2] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[3] + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha)) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[2] + pow(E,yss[11])*Gs[11] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] + pow(E,yss[2])*pbar*(Gs[2] + Hs[4])) - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[58] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[58] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[58] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[58] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[58] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[59] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[59] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[59] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[59] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[59] + pow(E,yss[2])*pbar*Pssp*(Gs[2] + Hs[4])*(Gs[114] + Hs[60]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[113]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[114] + pow(E,yss[11])*Gs[123] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[58] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[59] + pow(E,yss[2])*pbar*(Gs[114] + Hs[60]));
	Nxx_sp_s[182]=(Pssp*zbar*(Gs[11] - Hs[3])*Hs[57] + Pssp*zbar*Hs[1]*(Gs[123] - Hs[59]) - Pssp*zbar*(Gs[11] - Hs[3])*(Gs[123] - Hs[59])*xss[1] + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(pow(E,yss[11])*Gs[12] - zbar*Hs[1] + zbar*(Gs[11] - Hs[3])*xss[1]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[11])*Gs[124] - zbar*Hs[57] + zbar*(Gs[123] - Hs[59])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[183]=(-(Pssp*zbar*Hs[3]*Hs[57]) - Pssp*zbar*Hs[1]*Hs[59] - Pssp*(-1 + zbar)*Gs[11]*Gs[123]*xss[1] - Pssp*zbar*Hs[3]*Hs[59]*xss[1] + Pssp*zbar*Gs[123]*(Hs[1] + Hs[3]*xss[1]) - (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-(pow(E,yss[11])*Gs[13]) + zbar*Hs[1] - (-1 + zbar)*Gs[11]*xss[1] + zbar*Hs[3]*xss[1]) + Pssp*zbar*Gs[11]*(Hs[57] + Hs[59]*xss[1]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(E,yss[11])*Gs[125]) + zbar*Hs[57] - (-1 + zbar)*Gs[123]*xss[1] + zbar*Hs[59]*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[184]=pow(E,yss[0] - yss[11])*Pssp*Gs[0]*Gs[112] + pow(E,yss[3] - yss[11])*Pssp*Gs[3]*Gs[115] - Pssp*Gs[11]*Gs[123] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[11]*Gs[123])/pow(E,yss[11]) - (Pssp*Gs[123]*(pow(E,yss[0])*Gs[0] + pow(E,yss[3])*Gs[3] - pow(E,yss[11])*Gs[11] + pow(E,yss[11])*ebar*Hs[6]))/pow(E,yss[11]) + ((dP2ssp*Gs[121] + dP1ssp*Gs[122])*(pow(E,yss[0])*Gs[0] + pow(E,yss[3])*Gs[3] - pow(E,yss[0])*Gs[11] - pow(E,yss[3])*Gs[11] - pow(E,yss[11])*ebar*Gs[11] + pow(E,yss[11])*Gs[14] + pow(E,yss[11])*ebar*Hs[6]))/pow(E,yss[11]) + ebar*Pssp*Hs[6]*Hs[62] - (Pssp*Gs[11]*(pow(E,yss[0])*Gs[112] + pow(E,yss[3])*Gs[115] - pow(E,yss[11])*Gs[123] + pow(E,yss[11])*ebar*Hs[62]))/pow(E,yss[11]) + ((dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[0])*Gs[112] + pow(E,yss[3])*Gs[115] - pow(E,yss[0])*Gs[123] - pow(E,yss[3])*Gs[123] - pow(E,yss[11])*ebar*Gs[123] + pow(E,yss[11])*Gs[126] + pow(E,yss[11])*ebar*Hs[62]))/pow(E,yss[11]);
	Nxx_sp_s[185]=(-((Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[121]*Hs[3])/pow(E,yss[8])) + (Pssp*pow(zbar,rrho)*Gs[121]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(E,yss[8]) - (Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[9]*Hs[59])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*Gs[9]*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63]))/pow(E,yss[8]) - (Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[3]*Hs[59]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[59]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[3]*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*yss[9])/pow(E,yss[8]) - (Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*yss[9])/pow(E,yss[8]) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-((pow(zbar,rrho)*Gs[9])/pow(E,yss[8])) + bbeta*Gs[15] - (rrho*rrhoz*pow(zbar,rrho)*Hs[3]*yss[9])/pow(E,yss[8]) + (pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*yss[9])/pow(E,yss[8])) + ((dP2ssp*Gs[9] + dP1ssp*Gs[10])*(bbeta*pow(E,yss[8])*Gs[127] + pow(zbar,rrho)*(-Gs[121] + (-(rrho*rrhoz) + Gsp[56])*Hs[59]*yss[9] + (Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*yss[9])))/pow(E,yss[8]))/bbeta;
	Nxx_sp_s[186]=-((dP2ssp*Gs[121] + dP1ssp*Gs[122])*Hs[2]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[58];
	Nxx_sp_s[187]=-((dP2ssp*Gs[121] + dP1ssp*Gs[122])*Hs[3]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[59];
	Nxx_sp_s[188]=-((dP2ssp*Gs[121] + dP1ssp*Gs[122])*Hs[4]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[60];
	Nxx_sp_s[189]=-((dP2ssp*Gs[121] + dP1ssp*Gs[122])*Hs[7]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(rrhod - Hs[63]);
	Nxx_sp_s[190]=-((dP2ssp*Gs[121] + dP1ssp*Gs[122])*Hs[6]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[62];
	Nxx_sp_s[191]=-((dP2ssp*Gs[121] + dP1ssp*Gs[122])*Hs[5]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[61];
	Nxx_sp_s[216]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*pow(Gs[16],2)) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*pow(Gs[17],2) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*pow(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17],2) - pow(E,yss[8])*Pssp*pow(Gs[24],2) - 2*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])*Hs[15] + (Pssp*pow(Hs[15],2))/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + 2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])) - pow(E,yss[8])*Gs[24] + Hs[15]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[217]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[17],2)) + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[18] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[18],2) - (2*pbar*pphi*Pssp*Gs[21]*Gs[25])/pow(E,yss[8]) - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[10] + 2*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[10] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[10],2) - 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[11] + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[11] - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[11] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[11],2) + (2*pbar*pphi*Pssp*Gs[24]*Gs[25]*(1 + yss[5]))/pow(E,yss[8]) + (2*pbar*pphi*Pssp*Gs[21]*Gs[24]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*pow(Gs[24],2)*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*pow(Hs[12],2)*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (2*pbar*pphi*Pssp*Hs[12]*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])))/pow(E,yss[8]) + 2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[17]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[18] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[11] - pbar*Hs[12]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[218]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*pow(Gs[17],2)) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[17],2) - 2*(-1 + aalpha)*aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[18] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[18],2) - 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[21]*Gs[25] + 2*(-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[10] - 2*aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[10],2) + 2*(-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[11] - 2*pow(aalpha,2)*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[11] + 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[11] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[11],2) + 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[25]*(1 + yss[5]) + 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[21]*Gs[24]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*pow(Gs[24],2)*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*pow(Gs[23],2)*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[23]*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])) + 2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[17]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] - pow(E,yss[7])*pphi*Gs[23]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])));
	Nxx_sp_s[219]=-(pow(E,yss[8])*Pssp*pow(Gs[24],2)) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[21]*Hs[11])/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gs[21]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(Hs[11],2)*(1 + yss[5]))/pow(zbar,rrho) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[11]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15],2)*(1 + yss[5]))/pow(zbar,rrho) + 2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*((bbeta*pow(E,yss[8])*Gs[21])/pow(zbar,rrho) - pow(E,yss[8])*Gs[24] + Gs[25] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[11]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[220]=pow(E,yss[8])*Pssp*pow(Gs[24],2) - 2*kkappa*Pssp*Gs[22]*Gs[25] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[8],2) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[8],2) - 2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[8]*Hs[10] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*pow(Hs[10],2) - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[8]*Hs[11] - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[10]*Hs[11] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*pow(Hs[11],2) - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*pow(Hs[11],2))/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[24]*(Hs[8] + Hs[11]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[8] + Hs[11])*(Gs[24] + Hs[8] + Hs[11]) - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - 2*pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15],2) + 2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + 2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*pow(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15],2) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15],2) + 2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15],2) + (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*pow(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15],2))/pow(zbar,rrho) + (2*bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[11]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])))/pow(zbar,rrho) - (2*bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])))/pow(zbar,rrho) - kkappa*Pssp*pow(Gs[22],2)*yss[9] + 2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[8])*Gs[24] - kkappa*Gs[25] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[8] + Hs[11]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])))/pow(zbar,rrho) - kkappa*Gs[22]*yss[9]);
	Nxx_sp_s[221]=-(Pssp*pow(Gs[22],2)) + iiota*Pssp*zbar*pow(Hs[8] + Hs[11],2) + 2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-Gs[22] + iiota*zbar*(Hs[8] + Hs[11]));
	Nxx_sp_s[222]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*pow(Gs[17],2) - pow(E,yss[7])*Pssp*pow(Gs[23],2) + 2*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[17] - pow(E,yss[7])*Gs[23])*(dP2ssp*Gs[25] + dP1ssp*Gs[26]);
	Nxx_sp_s[223]=-(pow(E,yss[0])*Pssp*pow(Gs[16],2)) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[17],2) - 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[18] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[18],2) - pow(E,yss[3])*Pssp*pow(Gs[19],2) + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[10] - 2*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[10] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[10],2) + 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[11] - 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[11] + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[11] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[11],2) - pow(E,yss[2])*pbar*Pssp*pow(Gs[18] + Hs[12],2) - 2*pphi*Pssp*Gs[21]*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12])) - pow(E,yss[11])*ebar*Pssp*pow(Hs[14],2) - pow(E,yss[1] + yss[7])*pphi*Pssp*pow(Gs[17] + Gs[23],2)*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*pow(Gs[18] + Hs[12],2)*yss[5] - (2*Pssp*zbar*pow(Gs[21],2)*xss[1])/pow(1 + yss[5],3) + (2*Pssp*zbar*Gs[21]*Hs[9])/pow(1 + yss[5],2) + (2*Pssp*zbar*Gs[21]*Hs[11]*xss[1])/pow(1 + yss[5],2) - (2*Pssp*zbar*Hs[9]*Hs[11])/(1 + yss[5]) - (Pssp*zbar*pow(Hs[11],2)*xss[1])/(1 + yss[5]) + 2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*(1 - pow(E,yss[0])*Gs[16] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[18] - pow(E,yss[3])*Gs[19] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[21] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] - pow(E,yss[2])*pbar*(Gs[18] + Hs[12]) - pow(E,yss[11])*ebar*Hs[14] - pphi*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))*yss[5] + (zbar*Gs[21]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[9])/(1 + yss[5]) - (zbar*Hs[11]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[224]=pow(E,yss[3])*Pssp*pow(Gs[19],2) - pow(E,xss[0])*Pssp*zbar*pow(Hs[8] + Hs[11],2) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*pow(Hs[8] + Hs[11],2) + 2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[3])*Gs[19] - pow(E,xss[0])*zbar*(Hs[8] + Hs[11]));
	Nxx_sp_s[225]=pow(E,xss[0])*kkappa*Pssp*zbar*pow(Gs[22] + Hs[8] + Hs[11],2) - 2*pphi*Pssp*Gs[21]*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12])) + (2*Pssp*zbar*pow(Gs[21],2)*xss[1])/pow(1 + yss[5],3) - (2*Pssp*zbar*Gs[21]*Hs[9])/pow(1 + yss[5],2) - (2*Pssp*zbar*Gs[21]*Hs[11]*xss[1])/pow(1 + yss[5],2) + (2*Pssp*zbar*Hs[9]*Hs[11])/(1 + yss[5]) + (Pssp*zbar*pow(Hs[11],2)*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*pow(Gs[17] + Gs[23],2)*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*pow(Gs[18] + Hs[12],2)*(1 + yss[5]) + 2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[21]) - Gs[26] + pow(E,xss[0])*kkappa*zbar*(Gs[22] + Hs[8] + Hs[11]) - (zbar*Gs[21]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[9])/(1 + yss[5]) + (zbar*Hs[11]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))*(1 + yss[5]));
	Nxx_sp_s[226]=2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*((-1 + nnus)*Gs[25] + nnus*Gs[26]);
	Nxx_sp_s[227]=pow(E,bbar - xss[1])*ppsir*Pssp*pow(Hs[9],2) + 2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-Gs[21] - pow(E,bbar - xss[1])*ppsir*Hs[9] + Hs[13]);
	Nxx_sp_s[228]=-(pow(E,xss[0])*(Gs[20] - Hs[8])*(2*dP2ssp*Gs[25] + 2*dP1ssp*Gs[26] + Pssp*(Gs[20] + Hs[8])));
	Nxx_sp_s[229]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[17],2)) + 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[18],2) + pow(E,yss[11])*Pssp*pow(Gs[27],2) - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[10] + 2*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[10] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[10],2) - 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[11] + 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[11] - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[11] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[11],2) + pow(E,yss[2])*pbar*Pssp*pow(Gs[18] + Hs[12],2) + 2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[18] + pow(E,yss[11])*Gs[27] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]));
	Nxx_sp_s[230]=(2*Pssp*zbar*Hs[9]*(Gs[27] - Hs[11]) - Pssp*zbar*pow(Gs[27] - Hs[11],2)*xss[1] + 2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[11])*Gs[28] - zbar*Hs[9] + zbar*(Gs[27] - Hs[11])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[231]=(-2*Pssp*zbar*Hs[9]*Hs[11])/pow(E,yss[11]) - (Pssp*(-1 + zbar)*pow(Gs[27],2)*xss[1])/pow(E,yss[11]) - (Pssp*zbar*pow(Hs[11],2)*xss[1])/pow(E,yss[11]) + (2*Pssp*Gs[27]*(-1 + zbar*Hs[9] + zbar*Hs[11]*xss[1]))/pow(E,yss[11]) + 2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*(Gs[29] + ((-1 + zbar)*Gs[27]*xss[1])/pow(E,yss[11]) - (-1 + zbar*Hs[9] + zbar*Hs[11]*xss[1])/pow(E,yss[11]));
	Nxx_sp_s[232]=pow(E,yss[0] - yss[11])*Pssp*pow(Gs[16],2) + pow(E,yss[3] - yss[11])*Pssp*pow(Gs[19],2) - Pssp*pow(Gs[27],2) + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*pow(Gs[27],2))/pow(E,yss[11]) + ebar*Pssp*pow(Hs[14],2) + (2*Pssp*Gs[27]*(-(pow(E,yss[0])*Gs[16]) - pow(E,yss[3])*Gs[19] + pow(E,yss[11])*Gs[27] - pow(E,yss[11])*ebar*Hs[14]))/pow(E,yss[11]) + (2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[0])*Gs[16] + pow(E,yss[3])*Gs[19] - pow(E,yss[0])*Gs[27] - pow(E,yss[3])*Gs[27] - pow(E,yss[11])*ebar*Gs[27] + pow(E,yss[11])*Gs[30] + pow(E,yss[11])*ebar*Hs[14]))/pow(E,yss[11]);
	Nxx_sp_s[233]=((-2*Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[25]*Hs[11])/pow(E,yss[8]) + (2*Pssp*pow(zbar,rrho)*Gs[25]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(E,yss[8]) - (Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*pow(Hs[11],2)*yss[9])/pow(E,yss[8]) + (2*Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[11]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*yss[9])/pow(E,yss[8]) - (Pssp*pow(zbar,rrho)*pow(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15],2)*yss[9])/pow(E,yss[8]) + 2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-((pow(zbar,rrho)*Gs[25])/pow(E,yss[8])) + bbeta*Gs[31] - (rrho*rrhoz*pow(zbar,rrho)*Hs[11]*yss[9])/pow(E,yss[8]) + (pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*yss[9])/pow(E,yss[8])))/bbeta;
	Nxx_sp_s[234]=-2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[10];
	Nxx_sp_s[235]=-2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[11];
	Nxx_sp_s[236]=-2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[12];
	Nxx_sp_s[237]=-2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[15];
	Nxx_sp_s[238]=-2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[14];
	Nxx_sp_s[239]=-2*(dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[13];
	Nxx_sp_s[240]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[16]*Gs[32]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[17]*Gs[33] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33]) - pow(E,yss[8])*Pssp*Gs[24]*Gs[40] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])*Hs[15] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])) - pow(E,yss[8])*Gs[24] + Hs[15]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])*Hs[23] + (Pssp*Hs[15]*Hs[23])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])) - pow(E,yss[8])*Gs[40] + Hs[23]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[241]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[33]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[33] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[34] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[34] - (pbar*pphi*Pssp*Gs[25]*Gs[37])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[21]*Gs[41])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[10] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[10] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[11] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[11] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[18] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[18] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[18] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[19] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[19] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[19] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[19] + (pbar*pphi*Pssp*Gs[25]*Gs[40]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[24]*Gs[41]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[24]*Gs[37]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[21]*Gs[40]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[24]*Gs[40]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[12]*Hs[20]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[20]*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[12]*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[17]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[18] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[11] - pbar*Hs[12]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[33]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[34] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[19] - pbar*Hs[20]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[242]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[17]*Gs[33]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[33] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[33] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[34] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[34] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[25]*Gs[37] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[21]*Gs[41] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[10] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[11] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[11] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[18] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[18] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[19] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[19] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[19] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[19] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[25]*Gs[40]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[41]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[37]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[21]*Gs[40]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[40]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[23]*Gs[39]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[39]*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[23]*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[17]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] - pow(E,yss[7])*pphi*Gs[23]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9]))) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[33]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] - pow(E,yss[7])*pphi*Gs[39]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])));
	Nxx_sp_s[243]=-(pow(E,yss[8])*Pssp*Gs[24]*Gs[40]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[37]*Hs[11])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[37]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[21]*Hs[19])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[21]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[11]*Hs[19]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[19]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[11]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*((bbeta*pow(E,yss[8])*Gs[21])/pow(zbar,rrho) - pow(E,yss[8])*Gs[24] + Gs[25] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[11]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*((bbeta*pow(E,yss[8])*Gs[37])/pow(zbar,rrho) - pow(E,yss[8])*Gs[40] + Gs[41] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[19]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[244]=-(kkappa*Pssp*Gs[25]*Gs[38]) + pow(E,yss[8])*Pssp*Gs[24]*Gs[40] - kkappa*Pssp*Gs[22]*Gs[41] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[16] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[16] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*Hs[16] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*Hs[16] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[16] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[16] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*Hs[16] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[8]*Hs[18] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[10]*Hs[18] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*Hs[18] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[18] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[18] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[8]*Hs[19] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[10]*Hs[19] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[11]*Hs[19] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11]*Hs[19])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[19] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[19] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[19])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15]))*Hs[19])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[24]*(Hs[16] + Hs[19]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[8] + Hs[11])*(Gs[40] + Hs[16] + Hs[19]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*(Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15]))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[11]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])))/pow(zbar,rrho) - kkappa*Pssp*Gs[22]*Gs[38]*yss[9] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[8])*Gs[24] - kkappa*Gs[25] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[8] + Hs[11]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])))/pow(zbar,rrho) - kkappa*Gs[22]*yss[9]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[8])*Gs[40] - kkappa*Gs[41] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[16] + Hs[19]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])))/pow(zbar,rrho) - kkappa*Gs[38]*yss[9]);
	Nxx_sp_s[245]=-(Pssp*Gs[22]*Gs[38]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-Gs[22] + iiota*zbar*(Hs[8] + Hs[11])) + iiota*Pssp*zbar*(Hs[8] + Hs[11])*(Hs[16] + Hs[19]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-Gs[38] + iiota*zbar*(Hs[16] + Hs[19]));
	Nxx_sp_s[246]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[17]*Gs[33] - pow(E,yss[7])*Pssp*Gs[23]*Gs[39] + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[33] - pow(E,yss[7])*Gs[39]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[17] - pow(E,yss[7])*Gs[23])*(dP2ssp*Gs[41] + dP1ssp*Gs[42]);
	Nxx_sp_s[247]=-(pow(E,yss[0])*Pssp*Gs[16]*Gs[32]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[33] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[33] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[34] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[34] - pow(E,yss[3])*Pssp*Gs[19]*Gs[35] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[10] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[10] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[11] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[11] - pphi*Pssp*Gs[37]*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[18] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[18] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[19] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[19] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[19] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[19] - pow(E,yss[2])*pbar*Pssp*(Gs[18] + Hs[12])*(Gs[34] + Hs[20]) - pphi*Pssp*Gs[21]*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20])) - pow(E,yss[11])*ebar*Pssp*Hs[14]*Hs[22] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[17] + Gs[23])*(Gs[33] + Gs[39])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[18] + Hs[12])*(Gs[34] + Hs[20])*yss[5] - (2*Pssp*zbar*Gs[21]*Gs[37]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[37]*Hs[9])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[21]*Hs[17])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[37]*Hs[11]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[21]*Hs[19]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[11]*Hs[17])/(1 + yss[5]) - (Pssp*zbar*Hs[9]*Hs[19])/(1 + yss[5]) - (Pssp*zbar*Hs[11]*Hs[19]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(1 - pow(E,yss[0])*Gs[16] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[18] - pow(E,yss[3])*Gs[19] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[21] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] - pow(E,yss[2])*pbar*(Gs[18] + Hs[12]) - pow(E,yss[11])*ebar*Hs[14] - pphi*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))*yss[5] + (zbar*Gs[21]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[9])/(1 + yss[5]) - (zbar*Hs[11]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(E,yss[0])*Gs[32]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[34] - pow(E,yss[3])*Gs[35] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[37] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] - pow(E,yss[2])*pbar*(Gs[34] + Hs[20]) - pow(E,yss[11])*ebar*Hs[22] - pphi*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))*yss[5] + (zbar*Gs[37]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[17])/(1 + yss[5]) - (zbar*Hs[19]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[248]=pow(E,yss[3])*Pssp*Gs[19]*Gs[35] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[3])*Gs[19] - pow(E,xss[0])*zbar*(Hs[8] + Hs[11])) - pow(E,xss[0])*Pssp*zbar*(Hs[8] + Hs[11])*(Hs[16] + Hs[19]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[8] + Hs[11])*(Hs[16] + Hs[19]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[3])*Gs[35] - pow(E,xss[0])*zbar*(Hs[16] + Hs[19]));
	Nxx_sp_s[249]=-(pphi*Pssp*Gs[37]*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[22] + Hs[8] + Hs[11])*(Gs[38] + Hs[16] + Hs[19]) - pphi*Pssp*Gs[21]*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20])) + (2*Pssp*zbar*Gs[21]*Gs[37]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[37]*Hs[9])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[21]*Hs[17])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[37]*Hs[11]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[21]*Hs[19]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[11]*Hs[17])/(1 + yss[5]) + (Pssp*zbar*Hs[9]*Hs[19])/(1 + yss[5]) + (Pssp*zbar*Hs[11]*Hs[19]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[17] + Gs[23])*(Gs[33] + Gs[39])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[18] + Hs[12])*(Gs[34] + Hs[20])*(1 + yss[5]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[21]) - Gs[26] + pow(E,xss[0])*kkappa*zbar*(Gs[22] + Hs[8] + Hs[11]) - (zbar*Gs[21]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[9])/(1 + yss[5]) + (zbar*Hs[11]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))*(1 + yss[5])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[37]) - Gs[42] + pow(E,xss[0])*kkappa*zbar*(Gs[38] + Hs[16] + Hs[19]) - (zbar*Gs[37]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[17])/(1 + yss[5]) + (zbar*Hs[19]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))*(1 + yss[5]));
	Nxx_sp_s[250]=((-1 + nnus)*Gs[25] + nnus*Gs[26])*(dP2ssp*Gs[41] + dP1ssp*Gs[42]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*((-1 + nnus)*Gs[41] + nnus*Gs[42]);
	Nxx_sp_s[251]=(dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-Gs[21] - pow(E,bbar - xss[1])*ppsir*Hs[9] + Hs[13]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[9]*Hs[17] + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-Gs[37] - pow(E,bbar - xss[1])*ppsir*Hs[17] + Hs[21]);
	Nxx_sp_s[252]=pow(E,xss[0])*(-(Pssp*Gs[20]*Gs[36]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(Gs[20] - Hs[8]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(Gs[36] - Hs[16]) + Pssp*Hs[8]*Hs[16]);
	Nxx_sp_s[253]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[33]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[33] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[34] + pow(E,yss[11])*Pssp*Gs[27]*Gs[43] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[10] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[10] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[11] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[18] + pow(E,yss[11])*Gs[27] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] + pow(E,yss[2])*pbar*(Gs[18] + Hs[12])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[18] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[18] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[18] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[19] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[19] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[19] + pow(E,yss[2])*pbar*Pssp*(Gs[18] + Hs[12])*(Gs[34] + Hs[20]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[34] + pow(E,yss[11])*Gs[43] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]));
	Nxx_sp_s[254]=(Pssp*zbar*(Gs[27] - Hs[11])*Hs[17] + Pssp*zbar*Hs[9]*(Gs[43] - Hs[19]) - Pssp*zbar*(Gs[27] - Hs[11])*(Gs[43] - Hs[19])*xss[1] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[11])*Gs[28] - zbar*Hs[9] + zbar*(Gs[27] - Hs[11])*xss[1]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[11])*Gs[44] - zbar*Hs[17] + zbar*(Gs[43] - Hs[19])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[255]=-((Pssp*zbar*Hs[11]*Hs[17])/pow(E,yss[11])) - (Pssp*zbar*Hs[9]*Hs[19])/pow(E,yss[11]) - (Pssp*(-1 + zbar)*Gs[27]*Gs[43]*xss[1])/pow(E,yss[11]) - (Pssp*zbar*Hs[11]*Hs[19]*xss[1])/pow(E,yss[11]) + (Pssp*Gs[43]*(-1 + zbar*Hs[9] + zbar*Hs[11]*xss[1]))/pow(E,yss[11]) + (Pssp*zbar*Gs[27]*(Hs[17] + Hs[19]*xss[1]))/pow(E,yss[11]) - ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(E,yss[11])*Gs[45]) + zbar*Hs[17] - (-1 + zbar)*Gs[43]*xss[1] + zbar*Hs[19]*xss[1]))/pow(E,yss[11]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(Gs[29] + ((-1 + zbar)*Gs[27]*xss[1])/pow(E,yss[11]) - (-1 + zbar*Hs[9] + zbar*Hs[11]*xss[1])/pow(E,yss[11]));
	Nxx_sp_s[256]=pow(E,yss[0] - yss[11])*Pssp*Gs[16]*Gs[32] + pow(E,yss[3] - yss[11])*Pssp*Gs[19]*Gs[35] - Pssp*Gs[27]*Gs[43] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[27]*Gs[43])/pow(E,yss[11]) - (Pssp*Gs[43]*(pow(E,yss[0])*Gs[16] + pow(E,yss[3])*Gs[19] - pow(E,yss[11])*Gs[27] + pow(E,yss[11])*ebar*Hs[14]))/pow(E,yss[11]) + ((dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[0])*Gs[16] + pow(E,yss[3])*Gs[19] - pow(E,yss[0])*Gs[27] - pow(E,yss[3])*Gs[27] - pow(E,yss[11])*ebar*Gs[27] + pow(E,yss[11])*Gs[30] + pow(E,yss[11])*ebar*Hs[14]))/pow(E,yss[11]) + ebar*Pssp*Hs[14]*Hs[22] - (Pssp*Gs[27]*(pow(E,yss[0])*Gs[32] + pow(E,yss[3])*Gs[35] - pow(E,yss[11])*Gs[43] + pow(E,yss[11])*ebar*Hs[22]))/pow(E,yss[11]) + ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[0])*Gs[32] + pow(E,yss[3])*Gs[35] - pow(E,yss[0])*Gs[43] - pow(E,yss[3])*Gs[43] - pow(E,yss[11])*ebar*Gs[43] + pow(E,yss[11])*Gs[46] + pow(E,yss[11])*ebar*Hs[22]))/pow(E,yss[11]);
	Nxx_sp_s[257]=(-((Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[41]*Hs[11])/pow(E,yss[8])) + (Pssp*pow(zbar,rrho)*Gs[41]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(E,yss[8]) - (Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[25]*Hs[19])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*Gs[25]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(E,yss[8]) - (Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[11]*Hs[19]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[19]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[11]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*yss[9])/pow(E,yss[8]) - (Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*yss[9])/pow(E,yss[8]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-((pow(zbar,rrho)*Gs[25])/pow(E,yss[8])) + bbeta*Gs[31] - (rrho*rrhoz*pow(zbar,rrho)*Hs[11]*yss[9])/pow(E,yss[8]) + (pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*yss[9])/pow(E,yss[8])) + ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(bbeta*pow(E,yss[8])*Gs[47] + pow(zbar,rrho)*Gsp[120]*Hs[23]*yss[9] + pow(zbar,rrho)*(-Gs[41] + Gsp[8]*Hs[16]*yss[9] + Gsp[24]*Hs[17]*yss[9] + Gsp[40]*Hs[18]*yss[9] - rrho*rrhoz*Hs[19]*yss[9] + Gsp[56]*Hs[19]*yss[9] + Gsp[72]*Hs[20]*yss[9] + Gsp[88]*Hs[21]*yss[9] + Gsp[104]*Hs[22]*yss[9])))/pow(E,yss[8]))/bbeta;
	Nxx_sp_s[258]=-((dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[10]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(rrhoa - Hs[18]);
	Nxx_sp_s[259]=-((dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[11]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[19];
	Nxx_sp_s[260]=-((dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[12]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[20];
	Nxx_sp_s[261]=-((dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[15]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[23];
	Nxx_sp_s[262]=-((dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[14]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[22];
	Nxx_sp_s[263]=-((dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[13]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[21];
	Nxx_sp_s[264]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[16]*Gs[48]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[17]*Gs[49] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])*(pow(E,yss[0])*Gs[48] - pow(pow(E,yss[1]),oomega)*Gs[49]) - pow(E,yss[8])*Pssp*Gs[24]*Gs[56] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[48] - pow(pow(E,yss[1]),oomega)*Gs[49])*Hs[15] + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])) - pow(E,yss[8])*Gs[24] + Hs[15]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])*Hs[31] + (Pssp*Hs[15]*Hs[31])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[48] - pow(pow(E,yss[1]),oomega)*Gs[49])) - pow(E,yss[8])*Gs[56] + Hs[31]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[265]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[49]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[49] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[50] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[50] - (pbar*pphi*Pssp*Gs[25]*Gs[53])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[21]*Gs[57])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[10] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[10] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[11] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[11] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[26] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[26] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[26] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[26] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[27] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[27] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[27] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[27] + (pbar*pphi*Pssp*Gs[25]*Gs[56]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[24]*Gs[57]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[24]*Gs[53]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[21]*Gs[56]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[24]*Gs[56]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[12]*Hs[28]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[28]*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[12]*(Gs[53]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[57] - Gs[56]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[17]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[18] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[11] - pbar*Hs[12]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[49]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[50] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[26] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[27] - pbar*Hs[28]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[53]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[57] - Gs[56]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[266]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[17]*Gs[49]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[49] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[49] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[50] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[50] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[25]*Gs[53] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[21]*Gs[57] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[10] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[11] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[11] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[26] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[26] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[27] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[27] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[27] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[27] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[25]*Gs[56]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[57]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[53]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[21]*Gs[56]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[56]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[23]*Gs[55]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[55]*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[23]*(Gs[53]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[57] - Gs[56]*yss[9])) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[17]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] - pow(E,yss[7])*pphi*Gs[23]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9]))) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[49]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[49] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[26] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[27] - pow(E,yss[7])*pphi*Gs[55]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[53]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[57] - Gs[56]*yss[9])));
	Nxx_sp_s[267]=-(pow(E,yss[8])*Pssp*Gs[24]*Gs[56]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[53]*Hs[11])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[53]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[21]*Hs[27])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[21]*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[11]*Hs[27]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[27]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[11]*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*((bbeta*pow(E,yss[8])*Gs[21])/pow(zbar,rrho) - pow(E,yss[8])*Gs[24] + Gs[25] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[11]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*((bbeta*pow(E,yss[8])*Gs[53])/pow(zbar,rrho) - pow(E,yss[8])*Gs[56] + Gs[57] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[27]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[268]=-(kkappa*Pssp*Gs[25]*Gs[54]) + pow(E,yss[8])*Pssp*Gs[24]*Gs[56] - kkappa*Pssp*Gs[22]*Gs[57] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[24] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[24] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*Hs[24] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*Hs[24] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[24] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[24] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*Hs[24] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[8]*Hs[26] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[10]*Hs[26] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*Hs[26] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[26] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[26] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[8]*Hs[27] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[10]*Hs[27] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[11]*Hs[27] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11]*Hs[27])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[27] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[27] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[27])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15]))*Hs[27])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[24]*(Hs[24] + Hs[27]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[8] + Hs[11])*(Gs[56] + Hs[24] + Hs[27]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*(Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11]*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15]))*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[11]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[24] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[27] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[24] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[27] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31])))/pow(zbar,rrho) - kkappa*Pssp*Gs[22]*Gs[54]*yss[9] + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(pow(E,yss[8])*Gs[24] - kkappa*Gs[25] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[8] + Hs[11]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])))/pow(zbar,rrho) - kkappa*Gs[22]*yss[9]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[8])*Gs[56] - kkappa*Gs[57] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[27])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[24] + Hs[27]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[24] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[27] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31])))/pow(zbar,rrho) - kkappa*Gs[54]*yss[9]);
	Nxx_sp_s[269]=-(Pssp*Gs[22]*Gs[54]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-Gs[22] + iiota*zbar*(Hs[8] + Hs[11])) + iiota*Pssp*zbar*(Hs[8] + Hs[11])*(Hs[24] + Hs[27]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-Gs[54] + iiota*zbar*(Hs[24] + Hs[27]));
	Nxx_sp_s[270]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[17]*Gs[49] - pow(E,yss[7])*Pssp*Gs[23]*Gs[55] + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[49] - pow(E,yss[7])*Gs[55]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[17] - pow(E,yss[7])*Gs[23])*(dP2ssp*Gs[57] + dP1ssp*Gs[58]);
	Nxx_sp_s[271]=-(pow(E,yss[0])*Pssp*Gs[16]*Gs[48]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[49] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[49] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[50] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[50] - pow(E,yss[3])*Pssp*Gs[19]*Gs[51] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[10] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[10] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[11] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[11] - pphi*Pssp*Gs[53]*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[26] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[26] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[26] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[27] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[27] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[27] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[27] - pow(E,yss[2])*pbar*Pssp*(Gs[18] + Hs[12])*(Gs[50] + Hs[28]) - pphi*Pssp*Gs[21]*(pow(E,yss[1] + yss[7])*(Gs[49] + Gs[55]) + pow(E,yss[2])*pbar*(Gs[50] + Hs[28])) - pow(E,yss[11])*ebar*Pssp*Hs[14]*Hs[30] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[17] + Gs[23])*(Gs[49] + Gs[55])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[18] + Hs[12])*(Gs[50] + Hs[28])*yss[5] - (2*Pssp*zbar*Gs[21]*Gs[53]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[53]*Hs[9])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[21]*Hs[25])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[53]*Hs[11]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[21]*Hs[27]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[11]*Hs[25])/(1 + yss[5]) - (Pssp*zbar*Hs[9]*Hs[27])/(1 + yss[5]) - (Pssp*zbar*Hs[11]*Hs[27]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(1 - pow(E,yss[0])*Gs[16] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[18] - pow(E,yss[3])*Gs[19] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[21] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] - pow(E,yss[2])*pbar*(Gs[18] + Hs[12]) - pow(E,yss[11])*ebar*Hs[14] - pphi*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))*yss[5] + (zbar*Gs[21]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[9])/(1 + yss[5]) - (zbar*Hs[11]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(E,yss[0])*Gs[48]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[49] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[50] - pow(E,yss[3])*Gs[51] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[53] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[27] - pow(E,yss[2])*pbar*(Gs[50] + Hs[28]) - pow(E,yss[11])*ebar*Hs[30] - pphi*(pow(E,yss[1] + yss[7])*(Gs[49] + Gs[55]) + pow(E,yss[2])*pbar*(Gs[50] + Hs[28]))*yss[5] + (zbar*Gs[53]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[25])/(1 + yss[5]) - (zbar*Hs[27]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[272]=pow(E,yss[3])*Pssp*Gs[19]*Gs[51] + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(pow(E,yss[3])*Gs[19] - pow(E,xss[0])*zbar*(Hs[8] + Hs[11])) - pow(E,xss[0])*Pssp*zbar*(Hs[8] + Hs[11])*(Hs[24] + Hs[27]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[8] + Hs[11])*(Hs[24] + Hs[27]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[3])*Gs[51] - pow(E,xss[0])*zbar*(Hs[24] + Hs[27]));
	Nxx_sp_s[273]=-(pphi*Pssp*Gs[53]*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[22] + Hs[8] + Hs[11])*(Gs[54] + Hs[24] + Hs[27]) - pphi*Pssp*Gs[21]*(pow(E,yss[1] + yss[7])*(Gs[49] + Gs[55]) + pow(E,yss[2])*pbar*(Gs[50] + Hs[28])) + (2*Pssp*zbar*Gs[21]*Gs[53]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[53]*Hs[9])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[21]*Hs[25])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[53]*Hs[11]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[21]*Hs[27]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[11]*Hs[25])/(1 + yss[5]) + (Pssp*zbar*Hs[9]*Hs[27])/(1 + yss[5]) + (Pssp*zbar*Hs[11]*Hs[27]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[17] + Gs[23])*(Gs[49] + Gs[55])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[18] + Hs[12])*(Gs[50] + Hs[28])*(1 + yss[5]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[21]) - Gs[26] + pow(E,xss[0])*kkappa*zbar*(Gs[22] + Hs[8] + Hs[11]) - (zbar*Gs[21]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[9])/(1 + yss[5]) + (zbar*Hs[11]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))*(1 + yss[5])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[53]) - Gs[58] + pow(E,xss[0])*kkappa*zbar*(Gs[54] + Hs[24] + Hs[27]) - (zbar*Gs[53]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[25])/(1 + yss[5]) + (zbar*Hs[27]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[49] + Gs[55]) + pow(E,yss[2])*pbar*(Gs[50] + Hs[28]))*(1 + yss[5]));
	Nxx_sp_s[274]=((-1 + nnus)*Gs[25] + nnus*Gs[26])*(dP2ssp*Gs[57] + dP1ssp*Gs[58]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*((-1 + nnus)*Gs[57] + nnus*Gs[58]);
	Nxx_sp_s[275]=(dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-Gs[21] - pow(E,bbar - xss[1])*ppsir*Hs[9] + Hs[13]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[9]*Hs[25] + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-Gs[53] - pow(E,bbar - xss[1])*ppsir*Hs[25] + Hs[29]);
	Nxx_sp_s[276]=pow(E,xss[0])*(-(Pssp*Gs[20]*Gs[52]) - (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(Gs[20] - Hs[8]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(Gs[52] - Hs[24]) + Pssp*Hs[8]*Hs[24]);
	Nxx_sp_s[277]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[49]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[49] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[50] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[50] + pow(E,yss[11])*Pssp*Gs[27]*Gs[59] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[10] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[10] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[11] + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[18] + pow(E,yss[11])*Gs[27] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] + pow(E,yss[2])*pbar*(Gs[18] + Hs[12])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[26] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[26] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[26] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[26] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[27] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[27] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[27] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[27] + pow(E,yss[2])*pbar*Pssp*(Gs[18] + Hs[12])*(Gs[50] + Hs[28]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[49]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[50] + pow(E,yss[11])*Gs[59] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[26] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[27] + pow(E,yss[2])*pbar*(Gs[50] + Hs[28]));
	Nxx_sp_s[278]=(Pssp*zbar*(Gs[27] - Hs[11])*Hs[25] + Pssp*zbar*Hs[9]*(Gs[59] - Hs[27]) - Pssp*zbar*(Gs[27] - Hs[11])*(Gs[59] - Hs[27])*xss[1] + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(pow(E,yss[11])*Gs[28] - zbar*Hs[9] + zbar*(Gs[27] - Hs[11])*xss[1]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[11])*Gs[60] - zbar*Hs[25] + zbar*(Gs[59] - Hs[27])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[279]=-((Pssp*zbar*Hs[11]*Hs[25])/pow(E,yss[11])) - (Pssp*zbar*Hs[9]*Hs[27])/pow(E,yss[11]) - (Pssp*(-1 + zbar)*Gs[27]*Gs[59]*xss[1])/pow(E,yss[11]) - (Pssp*zbar*Hs[11]*Hs[27]*xss[1])/pow(E,yss[11]) + (Pssp*Gs[59]*(-1 + zbar*Hs[9] + zbar*Hs[11]*xss[1]))/pow(E,yss[11]) + (Pssp*zbar*Gs[27]*(Hs[25] + Hs[27]*xss[1]))/pow(E,yss[11]) - ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(E,yss[11])*Gs[61]) + zbar*Hs[25] - (-1 + zbar)*Gs[59]*xss[1] + zbar*Hs[27]*xss[1]))/pow(E,yss[11]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(Gs[29] + ((-1 + zbar)*Gs[27]*xss[1])/pow(E,yss[11]) - (-1 + zbar*Hs[9] + zbar*Hs[11]*xss[1])/pow(E,yss[11]));
	Nxx_sp_s[280]=pow(E,yss[0] - yss[11])*Pssp*Gs[16]*Gs[48] + pow(E,yss[3] - yss[11])*Pssp*Gs[19]*Gs[51] - Pssp*Gs[27]*Gs[59] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[27]*Gs[59])/pow(E,yss[11]) - (Pssp*Gs[59]*(pow(E,yss[0])*Gs[16] + pow(E,yss[3])*Gs[19] - pow(E,yss[11])*Gs[27] + pow(E,yss[11])*ebar*Hs[14]))/pow(E,yss[11]) + ((dP2ssp*Gs[57] + dP1ssp*Gs[58])*(pow(E,yss[0])*Gs[16] + pow(E,yss[3])*Gs[19] - pow(E,yss[0])*Gs[27] - pow(E,yss[3])*Gs[27] - pow(E,yss[11])*ebar*Gs[27] + pow(E,yss[11])*Gs[30] + pow(E,yss[11])*ebar*Hs[14]))/pow(E,yss[11]) + ebar*Pssp*Hs[14]*Hs[30] - (Pssp*Gs[27]*(pow(E,yss[0])*Gs[48] + pow(E,yss[3])*Gs[51] - pow(E,yss[11])*Gs[59] + pow(E,yss[11])*ebar*Hs[30]))/pow(E,yss[11]) + ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[0])*Gs[48] + pow(E,yss[3])*Gs[51] - pow(E,yss[0])*Gs[59] - pow(E,yss[3])*Gs[59] - pow(E,yss[11])*ebar*Gs[59] + pow(E,yss[11])*Gs[62] + pow(E,yss[11])*ebar*Hs[30]))/pow(E,yss[11]);
	Nxx_sp_s[281]=(-((Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[57]*Hs[11])/pow(E,yss[8])) + (Pssp*pow(zbar,rrho)*Gs[57]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(E,yss[8]) - (Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[25]*Hs[27])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*Gs[25]*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]))/pow(E,yss[8]) - (Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[11]*Hs[27]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[27]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[11]*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*yss[9])/pow(E,yss[8]) - (Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*yss[9])/pow(E,yss[8]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-((pow(zbar,rrho)*Gs[25])/pow(E,yss[8])) + bbeta*Gs[31] - (rrho*rrhoz*pow(zbar,rrho)*Hs[11]*yss[9])/pow(E,yss[8]) + (pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*yss[9])/pow(E,yss[8])) + ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(bbeta*pow(E,yss[8])*Gs[63] + pow(zbar,rrho)*Gsp[120]*Hs[31]*yss[9] + pow(zbar,rrho)*(-Gs[57] + Gsp[8]*Hs[24]*yss[9] + Gsp[24]*Hs[25]*yss[9] + Gsp[40]*Hs[26]*yss[9] - rrho*rrhoz*Hs[27]*yss[9] + Gsp[56]*Hs[27]*yss[9] + Gsp[72]*Hs[28]*yss[9] + Gsp[88]*Hs[29]*yss[9] + Gsp[104]*Hs[30]*yss[9])))/pow(E,yss[8]))/bbeta;
	Nxx_sp_s[282]=-((dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[10]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[26];
	Nxx_sp_s[283]=-((dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[11]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(rrhoz - Hs[27]);
	Nxx_sp_s[284]=-((dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[12]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[28];
	Nxx_sp_s[285]=-((dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[15]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[31];
	Nxx_sp_s[286]=-((dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[14]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[30];
	Nxx_sp_s[287]=-((dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[13]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[29];
	Nxx_sp_s[288]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[16]*Gs[64]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[17]*Gs[65] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])*(pow(E,yss[0])*Gs[64] - pow(pow(E,yss[1]),oomega)*Gs[65]) - pow(E,yss[8])*Pssp*Gs[24]*Gs[72] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[64] - pow(pow(E,yss[1]),oomega)*Gs[65])*Hs[15] + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])) - pow(E,yss[8])*Gs[24] + Hs[15]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])*Hs[39] + (Pssp*Hs[15]*Hs[39])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[64] - pow(pow(E,yss[1]),oomega)*Gs[65])) - pow(E,yss[8])*Gs[72] + Hs[39]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[289]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[65]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[65] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[66] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[66] - (pbar*pphi*Pssp*Gs[25]*Gs[69])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[21]*Gs[73])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[10] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[10] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[11] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[11] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[34] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[34] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[34] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[34] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[35] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[35] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[35] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[35] + (pbar*pphi*Pssp*Gs[25]*Gs[72]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[24]*Gs[73]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[24]*Gs[69]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[21]*Gs[72]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[24]*Gs[72]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[12]*Hs[36]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[36]*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[12]*(Gs[69]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[73] - Gs[72]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[17]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[18] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[11] - pbar*Hs[12]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[65]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[66] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[34] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[35] - pbar*Hs[36]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[69]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[73] - Gs[72]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[290]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[17]*Gs[65]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[65] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[65] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[66] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[66] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[25]*Gs[69] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[21]*Gs[73] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[10] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[11] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[11] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[34] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[34] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[35] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[35] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[35] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[35] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[25]*Gs[72]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[73]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[69]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[21]*Gs[72]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[72]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[23]*Gs[71]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[71]*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[23]*(Gs[69]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[73] - Gs[72]*yss[9])) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[17]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] - pow(E,yss[7])*pphi*Gs[23]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9]))) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[65]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[65] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[34] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[35] - pow(E,yss[7])*pphi*Gs[71]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[69]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[73] - Gs[72]*yss[9])));
	Nxx_sp_s[291]=-(pow(E,yss[8])*Pssp*Gs[24]*Gs[72]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[69]*Hs[11])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[69]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[21]*Hs[35])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[21]*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[11]*Hs[35]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[35]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[11]*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*((bbeta*pow(E,yss[8])*Gs[21])/pow(zbar,rrho) - pow(E,yss[8])*Gs[24] + Gs[25] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[11]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*((bbeta*pow(E,yss[8])*Gs[69])/pow(zbar,rrho) - pow(E,yss[8])*Gs[72] + Gs[73] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[35]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[292]=-(kkappa*Pssp*Gs[25]*Gs[70]) + pow(E,yss[8])*Pssp*Gs[24]*Gs[72] - kkappa*Pssp*Gs[22]*Gs[73] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[32] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[32] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*Hs[32] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*Hs[32] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[32] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[32] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*Hs[32] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[8]*Hs[34] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[10]*Hs[34] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*Hs[34] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[34] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[34] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[8]*Hs[35] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[10]*Hs[35] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[11]*Hs[35] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11]*Hs[35])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[35] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[35] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[35])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15]))*Hs[35])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[24]*(Hs[32] + Hs[35]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[8] + Hs[11])*(Gs[72] + Hs[32] + Hs[35]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*(Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11]*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15]))*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[11]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[32] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[35] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[32] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[35] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39])))/pow(zbar,rrho) - kkappa*Pssp*Gs[22]*Gs[70]*yss[9] + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(pow(E,yss[8])*Gs[24] - kkappa*Gs[25] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[8] + Hs[11]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])))/pow(zbar,rrho) - kkappa*Gs[22]*yss[9]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[8])*Gs[72] - kkappa*Gs[73] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[35])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[32] + Hs[35]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[32] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[35] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39])))/pow(zbar,rrho) - kkappa*Gs[70]*yss[9]);
	Nxx_sp_s[293]=-(Pssp*Gs[22]*Gs[70]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-Gs[22] + iiota*zbar*(Hs[8] + Hs[11])) + iiota*Pssp*zbar*(Hs[8] + Hs[11])*(Hs[32] + Hs[35]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-Gs[70] + iiota*zbar*(Hs[32] + Hs[35]));
	Nxx_sp_s[294]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[17]*Gs[65] - pow(E,yss[7])*Pssp*Gs[23]*Gs[71] + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[65] - pow(E,yss[7])*Gs[71]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[17] - pow(E,yss[7])*Gs[23])*(dP2ssp*Gs[73] + dP1ssp*Gs[74]);
	Nxx_sp_s[295]=-(pow(E,yss[0])*Pssp*Gs[16]*Gs[64]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[65] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[65] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[66] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[66] - pow(E,yss[3])*Pssp*Gs[19]*Gs[67] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[10] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[10] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[11] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[11] - pphi*Pssp*Gs[69]*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[34] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[34] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[35] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[35] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[35] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[35] - pow(E,yss[2])*pbar*Pssp*(Gs[18] + Hs[12])*(Gs[66] + Hs[36]) - pphi*Pssp*Gs[21]*(pow(E,yss[1] + yss[7])*(Gs[65] + Gs[71]) + pow(E,yss[2])*pbar*(Gs[66] + Hs[36])) - pow(E,yss[11])*ebar*Pssp*Hs[14]*Hs[38] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[17] + Gs[23])*(Gs[65] + Gs[71])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[18] + Hs[12])*(Gs[66] + Hs[36])*yss[5] - (2*Pssp*zbar*Gs[21]*Gs[69]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[69]*Hs[9])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[21]*Hs[33])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[69]*Hs[11]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[21]*Hs[35]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[11]*Hs[33])/(1 + yss[5]) - (Pssp*zbar*Hs[9]*Hs[35])/(1 + yss[5]) - (Pssp*zbar*Hs[11]*Hs[35]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(1 - pow(E,yss[0])*Gs[16] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[18] - pow(E,yss[3])*Gs[19] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[21] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] - pow(E,yss[2])*pbar*(Gs[18] + Hs[12]) - pow(E,yss[11])*ebar*Hs[14] - pphi*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))*yss[5] + (zbar*Gs[21]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[9])/(1 + yss[5]) - (zbar*Hs[11]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(E,yss[0])*Gs[64]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[65] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[66] - pow(E,yss[3])*Gs[67] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[69] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[35] - pow(E,yss[2])*pbar*(Gs[66] + Hs[36]) - pow(E,yss[11])*ebar*Hs[38] - pphi*(pow(E,yss[1] + yss[7])*(Gs[65] + Gs[71]) + pow(E,yss[2])*pbar*(Gs[66] + Hs[36]))*yss[5] + (zbar*Gs[69]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[33])/(1 + yss[5]) - (zbar*Hs[35]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[296]=pow(E,yss[3])*Pssp*Gs[19]*Gs[67] + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(pow(E,yss[3])*Gs[19] - pow(E,xss[0])*zbar*(Hs[8] + Hs[11])) - pow(E,xss[0])*Pssp*zbar*(Hs[8] + Hs[11])*(Hs[32] + Hs[35]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[8] + Hs[11])*(Hs[32] + Hs[35]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[3])*Gs[67] - pow(E,xss[0])*zbar*(Hs[32] + Hs[35]));
	Nxx_sp_s[297]=-(pphi*Pssp*Gs[69]*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[22] + Hs[8] + Hs[11])*(Gs[70] + Hs[32] + Hs[35]) - pphi*Pssp*Gs[21]*(pow(E,yss[1] + yss[7])*(Gs[65] + Gs[71]) + pow(E,yss[2])*pbar*(Gs[66] + Hs[36])) + (2*Pssp*zbar*Gs[21]*Gs[69]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[69]*Hs[9])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[21]*Hs[33])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[69]*Hs[11]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[21]*Hs[35]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[11]*Hs[33])/(1 + yss[5]) + (Pssp*zbar*Hs[9]*Hs[35])/(1 + yss[5]) + (Pssp*zbar*Hs[11]*Hs[35]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[17] + Gs[23])*(Gs[65] + Gs[71])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[18] + Hs[12])*(Gs[66] + Hs[36])*(1 + yss[5]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[21]) - Gs[26] + pow(E,xss[0])*kkappa*zbar*(Gs[22] + Hs[8] + Hs[11]) - (zbar*Gs[21]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[9])/(1 + yss[5]) + (zbar*Hs[11]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))*(1 + yss[5])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[69]) - Gs[74] + pow(E,xss[0])*kkappa*zbar*(Gs[70] + Hs[32] + Hs[35]) - (zbar*Gs[69]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[33])/(1 + yss[5]) + (zbar*Hs[35]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[65] + Gs[71]) + pow(E,yss[2])*pbar*(Gs[66] + Hs[36]))*(1 + yss[5]));
	Nxx_sp_s[298]=((-1 + nnus)*Gs[25] + nnus*Gs[26])*(dP2ssp*Gs[73] + dP1ssp*Gs[74]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*((-1 + nnus)*Gs[73] + nnus*Gs[74]);
	Nxx_sp_s[299]=(dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-Gs[21] - pow(E,bbar - xss[1])*ppsir*Hs[9] + Hs[13]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[9]*Hs[33] + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-Gs[69] - pow(E,bbar - xss[1])*ppsir*Hs[33] + Hs[37]);
	Nxx_sp_s[300]=pow(E,xss[0])*(-(Pssp*Gs[20]*Gs[68]) - (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(Gs[20] - Hs[8]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(Gs[68] - Hs[32]) + Pssp*Hs[8]*Hs[32]);
	Nxx_sp_s[301]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[65]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[65] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[66] + pow(E,yss[11])*Pssp*Gs[27]*Gs[75] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[10] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[10] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[11] + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[18] + pow(E,yss[11])*Gs[27] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] + pow(E,yss[2])*pbar*(Gs[18] + Hs[12])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[34] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[34] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[34] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[34] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[35] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[35] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[35] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[35] + pow(E,yss[2])*pbar*Pssp*(Gs[18] + Hs[12])*(Gs[66] + Hs[36]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[65]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[66] + pow(E,yss[11])*Gs[75] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[34] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[35] + pow(E,yss[2])*pbar*(Gs[66] + Hs[36]));
	Nxx_sp_s[302]=(Pssp*zbar*(Gs[27] - Hs[11])*Hs[33] + Pssp*zbar*Hs[9]*(Gs[75] - Hs[35]) - Pssp*zbar*(Gs[27] - Hs[11])*(Gs[75] - Hs[35])*xss[1] + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(pow(E,yss[11])*Gs[28] - zbar*Hs[9] + zbar*(Gs[27] - Hs[11])*xss[1]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[11])*Gs[76] - zbar*Hs[33] + zbar*(Gs[75] - Hs[35])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[303]=-((Pssp*zbar*Hs[11]*Hs[33])/pow(E,yss[11])) - (Pssp*zbar*Hs[9]*Hs[35])/pow(E,yss[11]) - (Pssp*(-1 + zbar)*Gs[27]*Gs[75]*xss[1])/pow(E,yss[11]) - (Pssp*zbar*Hs[11]*Hs[35]*xss[1])/pow(E,yss[11]) + (Pssp*Gs[75]*(-1 + zbar*Hs[9] + zbar*Hs[11]*xss[1]))/pow(E,yss[11]) + (Pssp*zbar*Gs[27]*(Hs[33] + Hs[35]*xss[1]))/pow(E,yss[11]) - ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(E,yss[11])*Gs[77]) + zbar*Hs[33] - (-1 + zbar)*Gs[75]*xss[1] + zbar*Hs[35]*xss[1]))/pow(E,yss[11]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(Gs[29] + ((-1 + zbar)*Gs[27]*xss[1])/pow(E,yss[11]) - (-1 + zbar*Hs[9] + zbar*Hs[11]*xss[1])/pow(E,yss[11]));
	Nxx_sp_s[304]=pow(E,yss[0] - yss[11])*Pssp*Gs[16]*Gs[64] + pow(E,yss[3] - yss[11])*Pssp*Gs[19]*Gs[67] - Pssp*Gs[27]*Gs[75] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[27]*Gs[75])/pow(E,yss[11]) - (Pssp*Gs[75]*(pow(E,yss[0])*Gs[16] + pow(E,yss[3])*Gs[19] - pow(E,yss[11])*Gs[27] + pow(E,yss[11])*ebar*Hs[14]))/pow(E,yss[11]) + ((dP2ssp*Gs[73] + dP1ssp*Gs[74])*(pow(E,yss[0])*Gs[16] + pow(E,yss[3])*Gs[19] - pow(E,yss[0])*Gs[27] - pow(E,yss[3])*Gs[27] - pow(E,yss[11])*ebar*Gs[27] + pow(E,yss[11])*Gs[30] + pow(E,yss[11])*ebar*Hs[14]))/pow(E,yss[11]) + ebar*Pssp*Hs[14]*Hs[38] - (Pssp*Gs[27]*(pow(E,yss[0])*Gs[64] + pow(E,yss[3])*Gs[67] - pow(E,yss[11])*Gs[75] + pow(E,yss[11])*ebar*Hs[38]))/pow(E,yss[11]) + ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[0])*Gs[64] + pow(E,yss[3])*Gs[67] - pow(E,yss[0])*Gs[75] - pow(E,yss[3])*Gs[75] - pow(E,yss[11])*ebar*Gs[75] + pow(E,yss[11])*Gs[78] + pow(E,yss[11])*ebar*Hs[38]))/pow(E,yss[11]);
	Nxx_sp_s[305]=(-((Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[73]*Hs[11])/pow(E,yss[8])) + (Pssp*pow(zbar,rrho)*Gs[73]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(E,yss[8]) - (Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[25]*Hs[35])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*Gs[25]*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]))/pow(E,yss[8]) - (Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[11]*Hs[35]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[35]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[11]*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*yss[9])/pow(E,yss[8]) - (Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*yss[9])/pow(E,yss[8]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-((pow(zbar,rrho)*Gs[25])/pow(E,yss[8])) + bbeta*Gs[31] - (rrho*rrhoz*pow(zbar,rrho)*Hs[11]*yss[9])/pow(E,yss[8]) + (pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*yss[9])/pow(E,yss[8])) + ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(bbeta*pow(E,yss[8])*Gs[79] + pow(zbar,rrho)*Gsp[120]*Hs[39]*yss[9] + pow(zbar,rrho)*(-Gs[73] + Gsp[8]*Hs[32]*yss[9] + Gsp[24]*Hs[33]*yss[9] + Gsp[40]*Hs[34]*yss[9] - rrho*rrhoz*Hs[35]*yss[9] + Gsp[56]*Hs[35]*yss[9] + Gsp[72]*Hs[36]*yss[9] + Gsp[88]*Hs[37]*yss[9] + Gsp[104]*Hs[38]*yss[9])))/pow(E,yss[8]))/bbeta;
	Nxx_sp_s[306]=-((dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[10]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[34];
	Nxx_sp_s[307]=-((dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[11]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[35];
	Nxx_sp_s[308]=-((dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[12]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(rrhop - Hs[36]);
	Nxx_sp_s[309]=-((dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[15]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[39];
	Nxx_sp_s[310]=-((dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[14]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[38];
	Nxx_sp_s[311]=-((dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[13]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[37];
	Nxx_sp_s[312]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[16]*Gs[80]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[17]*Gs[81] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])*(pow(E,yss[0])*Gs[80] - pow(pow(E,yss[1]),oomega)*Gs[81]) - pow(E,yss[8])*Pssp*Gs[24]*Gs[88] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[80] - pow(pow(E,yss[1]),oomega)*Gs[81])*Hs[15] + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])) - pow(E,yss[8])*Gs[24] + Hs[15]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])*Hs[47] + (Pssp*Hs[15]*Hs[47])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[80] - pow(pow(E,yss[1]),oomega)*Gs[81])) - pow(E,yss[8])*Gs[88] + Hs[47]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[313]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[81]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[81] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[82] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[82] - (pbar*pphi*Pssp*Gs[25]*Gs[85])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[21]*Gs[89])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[10] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[10] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[11] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[11] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[42] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[42] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[42] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[42] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[43] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[43] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[43] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[43] + (pbar*pphi*Pssp*Gs[25]*Gs[88]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[24]*Gs[89]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[24]*Gs[85]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[21]*Gs[88]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[24]*Gs[88]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[12]*Hs[44]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[44]*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[12]*(Gs[85]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[89] - Gs[88]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[17]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[18] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[11] - pbar*Hs[12]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[81]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[82] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[42] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[43] - pbar*Hs[44]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[85]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[89] - Gs[88]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[314]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[17]*Gs[81]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[81] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[81] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[82] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[82] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[25]*Gs[85] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[21]*Gs[89] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[10] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[11] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[11] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[42] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[42] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[43] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[43] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[43] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[43] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[25]*Gs[88]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[89]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[85]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[21]*Gs[88]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[88]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[23]*Gs[87]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[87]*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[23]*(Gs[85]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[89] - Gs[88]*yss[9])) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[17]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] - pow(E,yss[7])*pphi*Gs[23]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9]))) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[81]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[81] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[42] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[43] - pow(E,yss[7])*pphi*Gs[87]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[85]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[89] - Gs[88]*yss[9])));
	Nxx_sp_s[315]=-(pow(E,yss[8])*Pssp*Gs[24]*Gs[88]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[85]*Hs[11])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[85]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[21]*Hs[43])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[21]*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[11]*Hs[43]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[43]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[11]*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*((bbeta*pow(E,yss[8])*Gs[21])/pow(zbar,rrho) - pow(E,yss[8])*Gs[24] + Gs[25] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[11]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*((bbeta*pow(E,yss[8])*Gs[85])/pow(zbar,rrho) - pow(E,yss[8])*Gs[88] + Gs[89] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[43]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[316]=-(kkappa*Pssp*Gs[25]*Gs[86]) + pow(E,yss[8])*Pssp*Gs[24]*Gs[88] - kkappa*Pssp*Gs[22]*Gs[89] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[40] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[40] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*Hs[40] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*Hs[40] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[40] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[40] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*Hs[40] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[8]*Hs[42] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[10]*Hs[42] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*Hs[42] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[42] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[42] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[8]*Hs[43] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[10]*Hs[43] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[11]*Hs[43] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11]*Hs[43])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[43] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[43] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[43])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15]))*Hs[43])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[24]*(Hs[40] + Hs[43]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[8] + Hs[11])*(Gs[88] + Hs[40] + Hs[43]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*(Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11]*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15]))*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[11]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[40] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[43] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[40] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[43] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47])))/pow(zbar,rrho) - kkappa*Pssp*Gs[22]*Gs[86]*yss[9] + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(pow(E,yss[8])*Gs[24] - kkappa*Gs[25] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[8] + Hs[11]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])))/pow(zbar,rrho) - kkappa*Gs[22]*yss[9]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[8])*Gs[88] - kkappa*Gs[89] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[43])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[40] + Hs[43]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[40] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[43] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47])))/pow(zbar,rrho) - kkappa*Gs[86]*yss[9]);
	Nxx_sp_s[317]=-(Pssp*Gs[22]*Gs[86]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-Gs[22] + iiota*zbar*(Hs[8] + Hs[11])) + iiota*Pssp*zbar*(Hs[8] + Hs[11])*(Hs[40] + Hs[43]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-Gs[86] + iiota*zbar*(Hs[40] + Hs[43]));
	Nxx_sp_s[318]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[17]*Gs[81] - pow(E,yss[7])*Pssp*Gs[23]*Gs[87] + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[81] - pow(E,yss[7])*Gs[87]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[17] - pow(E,yss[7])*Gs[23])*(dP2ssp*Gs[89] + dP1ssp*Gs[90]);
	Nxx_sp_s[319]=-(pow(E,yss[0])*Pssp*Gs[16]*Gs[80]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[81] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[81] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[82] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[82] - pow(E,yss[3])*Pssp*Gs[19]*Gs[83] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[10] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[10] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[11] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[11] - pphi*Pssp*Gs[85]*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[42] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[42] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[42] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[43] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[43] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[43] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[43] - pow(E,yss[2])*pbar*Pssp*(Gs[18] + Hs[12])*(Gs[82] + Hs[44]) - pphi*Pssp*Gs[21]*(pow(E,yss[1] + yss[7])*(Gs[81] + Gs[87]) + pow(E,yss[2])*pbar*(Gs[82] + Hs[44])) - pow(E,yss[11])*ebar*Pssp*Hs[14]*Hs[46] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[17] + Gs[23])*(Gs[81] + Gs[87])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[18] + Hs[12])*(Gs[82] + Hs[44])*yss[5] - (2*Pssp*zbar*Gs[21]*Gs[85]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[85]*Hs[9])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[21]*Hs[41])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[85]*Hs[11]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[21]*Hs[43]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[11]*Hs[41])/(1 + yss[5]) - (Pssp*zbar*Hs[9]*Hs[43])/(1 + yss[5]) - (Pssp*zbar*Hs[11]*Hs[43]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(1 - pow(E,yss[0])*Gs[16] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[18] - pow(E,yss[3])*Gs[19] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[21] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] - pow(E,yss[2])*pbar*(Gs[18] + Hs[12]) - pow(E,yss[11])*ebar*Hs[14] - pphi*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))*yss[5] + (zbar*Gs[21]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[9])/(1 + yss[5]) - (zbar*Hs[11]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(E,yss[0])*Gs[80]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[81] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[82] - pow(E,yss[3])*Gs[83] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[85] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[43] - pow(E,yss[2])*pbar*(Gs[82] + Hs[44]) - pow(E,yss[11])*ebar*Hs[46] - pphi*(pow(E,yss[1] + yss[7])*(Gs[81] + Gs[87]) + pow(E,yss[2])*pbar*(Gs[82] + Hs[44]))*yss[5] + (zbar*Gs[85]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[41])/(1 + yss[5]) - (zbar*Hs[43]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[320]=pow(E,yss[3])*Pssp*Gs[19]*Gs[83] + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(pow(E,yss[3])*Gs[19] - pow(E,xss[0])*zbar*(Hs[8] + Hs[11])) - pow(E,xss[0])*Pssp*zbar*(Hs[8] + Hs[11])*(Hs[40] + Hs[43]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[8] + Hs[11])*(Hs[40] + Hs[43]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[3])*Gs[83] - pow(E,xss[0])*zbar*(Hs[40] + Hs[43]));
	Nxx_sp_s[321]=-(pphi*Pssp*Gs[85]*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[22] + Hs[8] + Hs[11])*(Gs[86] + Hs[40] + Hs[43]) - pphi*Pssp*Gs[21]*(pow(E,yss[1] + yss[7])*(Gs[81] + Gs[87]) + pow(E,yss[2])*pbar*(Gs[82] + Hs[44])) + (2*Pssp*zbar*Gs[21]*Gs[85]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[85]*Hs[9])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[21]*Hs[41])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[85]*Hs[11]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[21]*Hs[43]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[11]*Hs[41])/(1 + yss[5]) + (Pssp*zbar*Hs[9]*Hs[43])/(1 + yss[5]) + (Pssp*zbar*Hs[11]*Hs[43]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[17] + Gs[23])*(Gs[81] + Gs[87])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[18] + Hs[12])*(Gs[82] + Hs[44])*(1 + yss[5]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[21]) - Gs[26] + pow(E,xss[0])*kkappa*zbar*(Gs[22] + Hs[8] + Hs[11]) - (zbar*Gs[21]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[9])/(1 + yss[5]) + (zbar*Hs[11]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))*(1 + yss[5])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[85]) - Gs[90] + pow(E,xss[0])*kkappa*zbar*(Gs[86] + Hs[40] + Hs[43]) - (zbar*Gs[85]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[41])/(1 + yss[5]) + (zbar*Hs[43]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[81] + Gs[87]) + pow(E,yss[2])*pbar*(Gs[82] + Hs[44]))*(1 + yss[5]));
	Nxx_sp_s[322]=((-1 + nnus)*Gs[25] + nnus*Gs[26])*(dP2ssp*Gs[89] + dP1ssp*Gs[90]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*((-1 + nnus)*Gs[89] + nnus*Gs[90]);
	Nxx_sp_s[323]=(dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-Gs[21] - pow(E,bbar - xss[1])*ppsir*Hs[9] + Hs[13]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[9]*Hs[41] + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-Gs[85] - pow(E,bbar - xss[1])*ppsir*Hs[41] + Hs[45]);
	Nxx_sp_s[324]=pow(E,xss[0])*(-(Pssp*Gs[20]*Gs[84]) - (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(Gs[20] - Hs[8]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(Gs[84] - Hs[40]) + Pssp*Hs[8]*Hs[40]);
	Nxx_sp_s[325]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[81]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[81] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[82] + pow(E,yss[11])*Pssp*Gs[27]*Gs[91] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[10] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[10] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[11] + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[18] + pow(E,yss[11])*Gs[27] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] + pow(E,yss[2])*pbar*(Gs[18] + Hs[12])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[42] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[42] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[42] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[42] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[43] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[43] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[43] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[43] + pow(E,yss[2])*pbar*Pssp*(Gs[18] + Hs[12])*(Gs[82] + Hs[44]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[81]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[82] + pow(E,yss[11])*Gs[91] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[42] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[43] + pow(E,yss[2])*pbar*(Gs[82] + Hs[44]));
	Nxx_sp_s[326]=(Pssp*zbar*(Gs[27] - Hs[11])*Hs[41] + Pssp*zbar*Hs[9]*(Gs[91] - Hs[43]) - Pssp*zbar*(Gs[27] - Hs[11])*(Gs[91] - Hs[43])*xss[1] + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(pow(E,yss[11])*Gs[28] - zbar*Hs[9] + zbar*(Gs[27] - Hs[11])*xss[1]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[11])*Gs[92] - zbar*Hs[41] + zbar*(Gs[91] - Hs[43])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[327]=-((Pssp*zbar*Hs[11]*Hs[41])/pow(E,yss[11])) - (Pssp*zbar*Hs[9]*Hs[43])/pow(E,yss[11]) - (Pssp*(-1 + zbar)*Gs[27]*Gs[91]*xss[1])/pow(E,yss[11]) - (Pssp*zbar*Hs[11]*Hs[43]*xss[1])/pow(E,yss[11]) + (Pssp*Gs[91]*(-1 + zbar*Hs[9] + zbar*Hs[11]*xss[1]))/pow(E,yss[11]) + (Pssp*zbar*Gs[27]*(Hs[41] + Hs[43]*xss[1]))/pow(E,yss[11]) - ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(E,yss[11])*Gs[93]) + zbar*Hs[41] - (-1 + zbar)*Gs[91]*xss[1] + zbar*Hs[43]*xss[1]))/pow(E,yss[11]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(Gs[29] + ((-1 + zbar)*Gs[27]*xss[1])/pow(E,yss[11]) - (-1 + zbar*Hs[9] + zbar*Hs[11]*xss[1])/pow(E,yss[11]));
	Nxx_sp_s[328]=pow(E,yss[0] - yss[11])*Pssp*Gs[16]*Gs[80] + pow(E,yss[3] - yss[11])*Pssp*Gs[19]*Gs[83] - Pssp*Gs[27]*Gs[91] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[27]*Gs[91])/pow(E,yss[11]) - (Pssp*Gs[91]*(pow(E,yss[0])*Gs[16] + pow(E,yss[3])*Gs[19] - pow(E,yss[11])*Gs[27] + pow(E,yss[11])*ebar*Hs[14]))/pow(E,yss[11]) + ((dP2ssp*Gs[89] + dP1ssp*Gs[90])*(pow(E,yss[0])*Gs[16] + pow(E,yss[3])*Gs[19] - pow(E,yss[0])*Gs[27] - pow(E,yss[3])*Gs[27] - pow(E,yss[11])*ebar*Gs[27] + pow(E,yss[11])*Gs[30] + pow(E,yss[11])*ebar*Hs[14]))/pow(E,yss[11]) + ebar*Pssp*Hs[14]*Hs[46] - (Pssp*Gs[27]*(pow(E,yss[0])*Gs[80] + pow(E,yss[3])*Gs[83] - pow(E,yss[11])*Gs[91] + pow(E,yss[11])*ebar*Hs[46]))/pow(E,yss[11]) + ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[0])*Gs[80] + pow(E,yss[3])*Gs[83] - pow(E,yss[0])*Gs[91] - pow(E,yss[3])*Gs[91] - pow(E,yss[11])*ebar*Gs[91] + pow(E,yss[11])*Gs[94] + pow(E,yss[11])*ebar*Hs[46]))/pow(E,yss[11]);
	Nxx_sp_s[329]=(-((Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[89]*Hs[11])/pow(E,yss[8])) + (Pssp*pow(zbar,rrho)*Gs[89]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(E,yss[8]) - (Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[25]*Hs[43])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*Gs[25]*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]))/pow(E,yss[8]) - (Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[11]*Hs[43]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[43]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[11]*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*yss[9])/pow(E,yss[8]) - (Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*yss[9])/pow(E,yss[8]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-((pow(zbar,rrho)*Gs[25])/pow(E,yss[8])) + bbeta*Gs[31] - (rrho*rrhoz*pow(zbar,rrho)*Hs[11]*yss[9])/pow(E,yss[8]) + (pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*yss[9])/pow(E,yss[8])) + ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(bbeta*pow(E,yss[8])*Gs[95] + pow(zbar,rrho)*Gsp[120]*Hs[47]*yss[9] + pow(zbar,rrho)*(-Gs[89] + Gsp[8]*Hs[40]*yss[9] + Gsp[24]*Hs[41]*yss[9] + Gsp[40]*Hs[42]*yss[9] + (-(rrho*rrhoz) + Gsp[56])*Hs[43]*yss[9] + Gsp[72]*Hs[44]*yss[9] + Gsp[88]*Hs[45]*yss[9] + Gsp[104]*Hs[46]*yss[9])))/pow(E,yss[8]))/bbeta;
	Nxx_sp_s[330]=-((dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[10]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[42];
	Nxx_sp_s[331]=-((dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[11]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[43];
	Nxx_sp_s[332]=-((dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[12]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[44];
	Nxx_sp_s[333]=-((dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[15]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[47];
	Nxx_sp_s[334]=-((dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[14]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[46];
	Nxx_sp_s[335]=-((dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[13]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(rrhor - Hs[45]);
	Nxx_sp_s[336]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[16]*Gs[96]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[17]*Gs[97] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])*(pow(E,yss[0])*Gs[96] - pow(pow(E,yss[1]),oomega)*Gs[97]) - pow(E,yss[8])*Pssp*Gs[24]*Gs[104] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[96] - pow(pow(E,yss[1]),oomega)*Gs[97])*Hs[15] + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])) - pow(E,yss[8])*Gs[24] + Hs[15]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])*Hs[55] + (Pssp*Hs[15]*Hs[55])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[96] - pow(pow(E,yss[1]),oomega)*Gs[97])) - pow(E,yss[8])*Gs[104] + Hs[55]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[337]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[97]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[97] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[98] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[98] - (pbar*pphi*Pssp*Gs[25]*Gs[101])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[21]*Gs[105])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[10] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[10] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[11] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[11] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[50] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[50] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[50] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[50] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[51] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[51] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[51] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[51] + (pbar*pphi*Pssp*Gs[25]*Gs[104]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[24]*Gs[105]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[24]*Gs[101]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[21]*Gs[104]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[24]*Gs[104]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[12]*Hs[52]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[52]*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[12]*(Gs[101]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[105] - Gs[104]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[17]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[18] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[11] - pbar*Hs[12]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[97]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[98] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[50] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[51] - pbar*Hs[52]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[101]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[105] - Gs[104]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[338]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[17]*Gs[97]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[97] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[97] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[98] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[98] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[25]*Gs[101] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[21]*Gs[105] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[10] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[11] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[11] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[50] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[50] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[51] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[51] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[51] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[51] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[25]*Gs[104]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[105]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[101]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[21]*Gs[104]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[104]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[23]*Gs[103]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[103]*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[23]*(Gs[101]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[105] - Gs[104]*yss[9])) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[17]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] - pow(E,yss[7])*pphi*Gs[23]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9]))) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[97]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[97] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[50] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[51] - pow(E,yss[7])*pphi*Gs[103]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[101]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[105] - Gs[104]*yss[9])));
	Nxx_sp_s[339]=-(pow(E,yss[8])*Pssp*Gs[24]*Gs[104]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[101]*Hs[11])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[101]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[21]*Hs[51])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[21]*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[11]*Hs[51]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[51]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[11]*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*((bbeta*pow(E,yss[8])*Gs[21])/pow(zbar,rrho) - pow(E,yss[8])*Gs[24] + Gs[25] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[11]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*((bbeta*pow(E,yss[8])*Gs[101])/pow(zbar,rrho) - pow(E,yss[8])*Gs[104] + Gs[105] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[51]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[340]=-(kkappa*Pssp*Gs[25]*Gs[102]) + pow(E,yss[8])*Pssp*Gs[24]*Gs[104] - kkappa*Pssp*Gs[22]*Gs[105] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[48] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[48] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*Hs[48] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*Hs[48] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[48] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[48] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*Hs[48] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[8]*Hs[50] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[10]*Hs[50] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*Hs[50] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[50] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[50] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[8]*Hs[51] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[10]*Hs[51] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[11]*Hs[51] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11]*Hs[51])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[51] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[51] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[51])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15]))*Hs[51])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[24]*(Hs[48] + Hs[51]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[8] + Hs[11])*(Gs[104] + Hs[48] + Hs[51]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*(Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11]*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15]))*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[11]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[48] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[51] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[48] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[51] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55])))/pow(zbar,rrho) - kkappa*Pssp*Gs[22]*Gs[102]*yss[9] + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(pow(E,yss[8])*Gs[24] - kkappa*Gs[25] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[8] + Hs[11]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])))/pow(zbar,rrho) - kkappa*Gs[22]*yss[9]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[8])*Gs[104] - kkappa*Gs[105] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[51])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[48] + Hs[51]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[48] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[51] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55])))/pow(zbar,rrho) - kkappa*Gs[102]*yss[9]);
	Nxx_sp_s[341]=-(Pssp*Gs[22]*Gs[102]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-Gs[22] + iiota*zbar*(Hs[8] + Hs[11])) + iiota*Pssp*zbar*(Hs[8] + Hs[11])*(Hs[48] + Hs[51]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-Gs[102] + iiota*zbar*(Hs[48] + Hs[51]));
	Nxx_sp_s[342]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[17]*Gs[97] - pow(E,yss[7])*Pssp*Gs[23]*Gs[103] + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[97] - pow(E,yss[7])*Gs[103]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[17] - pow(E,yss[7])*Gs[23])*(dP2ssp*Gs[105] + dP1ssp*Gs[106]);
	Nxx_sp_s[343]=-(pow(E,yss[0])*Pssp*Gs[16]*Gs[96]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[97] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[97] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[98] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[98] - pow(E,yss[3])*Pssp*Gs[19]*Gs[99] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[10] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[10] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[11] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[11] - pphi*Pssp*Gs[101]*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[50] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[50] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[50] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[51] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[51] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[51] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[51] - pow(E,yss[2])*pbar*Pssp*(Gs[18] + Hs[12])*(Gs[98] + Hs[52]) - pphi*Pssp*Gs[21]*(pow(E,yss[1] + yss[7])*(Gs[97] + Gs[103]) + pow(E,yss[2])*pbar*(Gs[98] + Hs[52])) - pow(E,yss[11])*ebar*Pssp*Hs[14]*Hs[54] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[17] + Gs[23])*(Gs[97] + Gs[103])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[18] + Hs[12])*(Gs[98] + Hs[52])*yss[5] - (2*Pssp*zbar*Gs[21]*Gs[101]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[101]*Hs[9])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[21]*Hs[49])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[101]*Hs[11]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[21]*Hs[51]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[11]*Hs[49])/(1 + yss[5]) - (Pssp*zbar*Hs[9]*Hs[51])/(1 + yss[5]) - (Pssp*zbar*Hs[11]*Hs[51]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(1 - pow(E,yss[0])*Gs[16] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[18] - pow(E,yss[3])*Gs[19] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[21] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] - pow(E,yss[2])*pbar*(Gs[18] + Hs[12]) - pow(E,yss[11])*ebar*Hs[14] - pphi*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))*yss[5] + (zbar*Gs[21]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[9])/(1 + yss[5]) - (zbar*Hs[11]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(E,yss[0])*Gs[96]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[97] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[98] - pow(E,yss[3])*Gs[99] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[101] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[51] - pow(E,yss[2])*pbar*(Gs[98] + Hs[52]) - pow(E,yss[11])*ebar*Hs[54] - pphi*(pow(E,yss[1] + yss[7])*(Gs[97] + Gs[103]) + pow(E,yss[2])*pbar*(Gs[98] + Hs[52]))*yss[5] + (zbar*Gs[101]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[49])/(1 + yss[5]) - (zbar*Hs[51]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[344]=pow(E,yss[3])*Pssp*Gs[19]*Gs[99] + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(pow(E,yss[3])*Gs[19] - pow(E,xss[0])*zbar*(Hs[8] + Hs[11])) - pow(E,xss[0])*Pssp*zbar*(Hs[8] + Hs[11])*(Hs[48] + Hs[51]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[8] + Hs[11])*(Hs[48] + Hs[51]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[3])*Gs[99] - pow(E,xss[0])*zbar*(Hs[48] + Hs[51]));
	Nxx_sp_s[345]=-(pphi*Pssp*Gs[101]*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[22] + Hs[8] + Hs[11])*(Gs[102] + Hs[48] + Hs[51]) - pphi*Pssp*Gs[21]*(pow(E,yss[1] + yss[7])*(Gs[97] + Gs[103]) + pow(E,yss[2])*pbar*(Gs[98] + Hs[52])) + (2*Pssp*zbar*Gs[21]*Gs[101]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[101]*Hs[9])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[21]*Hs[49])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[101]*Hs[11]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[21]*Hs[51]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[11]*Hs[49])/(1 + yss[5]) + (Pssp*zbar*Hs[9]*Hs[51])/(1 + yss[5]) + (Pssp*zbar*Hs[11]*Hs[51]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[17] + Gs[23])*(Gs[97] + Gs[103])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[18] + Hs[12])*(Gs[98] + Hs[52])*(1 + yss[5]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[21]) - Gs[26] + pow(E,xss[0])*kkappa*zbar*(Gs[22] + Hs[8] + Hs[11]) - (zbar*Gs[21]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[9])/(1 + yss[5]) + (zbar*Hs[11]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))*(1 + yss[5])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[101]) - Gs[106] + pow(E,xss[0])*kkappa*zbar*(Gs[102] + Hs[48] + Hs[51]) - (zbar*Gs[101]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[49])/(1 + yss[5]) + (zbar*Hs[51]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[97] + Gs[103]) + pow(E,yss[2])*pbar*(Gs[98] + Hs[52]))*(1 + yss[5]));
	Nxx_sp_s[346]=((-1 + nnus)*Gs[25] + nnus*Gs[26])*(dP2ssp*Gs[105] + dP1ssp*Gs[106]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*((-1 + nnus)*Gs[105] + nnus*Gs[106]);
	Nxx_sp_s[347]=(dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-Gs[21] - pow(E,bbar - xss[1])*ppsir*Hs[9] + Hs[13]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[9]*Hs[49] + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-Gs[101] - pow(E,bbar - xss[1])*ppsir*Hs[49] + Hs[53]);
	Nxx_sp_s[348]=pow(E,xss[0])*(-(Pssp*Gs[20]*Gs[100]) - (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(Gs[20] - Hs[8]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(Gs[100] - Hs[48]) + Pssp*Hs[8]*Hs[48]);
	Nxx_sp_s[349]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[97]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[97] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[98] + pow(E,yss[11])*Pssp*Gs[27]*Gs[107] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[10] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[10] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[11] + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[18] + pow(E,yss[11])*Gs[27] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] + pow(E,yss[2])*pbar*(Gs[18] + Hs[12])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[50] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[50] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[50] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[50] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[51] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[51] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[51] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[51] + pow(E,yss[2])*pbar*Pssp*(Gs[18] + Hs[12])*(Gs[98] + Hs[52]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[97]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[98] + pow(E,yss[11])*Gs[107] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[50] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[51] + pow(E,yss[2])*pbar*(Gs[98] + Hs[52]));
	Nxx_sp_s[350]=(Pssp*zbar*(Gs[27] - Hs[11])*Hs[49] + Pssp*zbar*Hs[9]*(Gs[107] - Hs[51]) - Pssp*zbar*(Gs[27] - Hs[11])*(Gs[107] - Hs[51])*xss[1] + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(pow(E,yss[11])*Gs[28] - zbar*Hs[9] + zbar*(Gs[27] - Hs[11])*xss[1]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[11])*Gs[108] - zbar*Hs[49] + zbar*(Gs[107] - Hs[51])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[351]=-((Pssp*zbar*Hs[11]*Hs[49])/pow(E,yss[11])) - (Pssp*zbar*Hs[9]*Hs[51])/pow(E,yss[11]) - (Pssp*(-1 + zbar)*Gs[27]*Gs[107]*xss[1])/pow(E,yss[11]) - (Pssp*zbar*Hs[11]*Hs[51]*xss[1])/pow(E,yss[11]) + (Pssp*Gs[107]*(-1 + zbar*Hs[9] + zbar*Hs[11]*xss[1]))/pow(E,yss[11]) + (Pssp*zbar*Gs[27]*(Hs[49] + Hs[51]*xss[1]))/pow(E,yss[11]) - ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(E,yss[11])*Gs[109]) + zbar*Hs[49] - (-1 + zbar)*Gs[107]*xss[1] + zbar*Hs[51]*xss[1]))/pow(E,yss[11]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(Gs[29] + ((-1 + zbar)*Gs[27]*xss[1])/pow(E,yss[11]) - (-1 + zbar*Hs[9] + zbar*Hs[11]*xss[1])/pow(E,yss[11]));
	Nxx_sp_s[352]=pow(E,yss[0] - yss[11])*Pssp*Gs[16]*Gs[96] + pow(E,yss[3] - yss[11])*Pssp*Gs[19]*Gs[99] - Pssp*Gs[27]*Gs[107] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[27]*Gs[107])/pow(E,yss[11]) - (Pssp*Gs[107]*(pow(E,yss[0])*Gs[16] + pow(E,yss[3])*Gs[19] - pow(E,yss[11])*Gs[27] + pow(E,yss[11])*ebar*Hs[14]))/pow(E,yss[11]) + ((dP2ssp*Gs[105] + dP1ssp*Gs[106])*(pow(E,yss[0])*Gs[16] + pow(E,yss[3])*Gs[19] - pow(E,yss[0])*Gs[27] - pow(E,yss[3])*Gs[27] - pow(E,yss[11])*ebar*Gs[27] + pow(E,yss[11])*Gs[30] + pow(E,yss[11])*ebar*Hs[14]))/pow(E,yss[11]) + ebar*Pssp*Hs[14]*Hs[54] - (Pssp*Gs[27]*(pow(E,yss[0])*Gs[96] + pow(E,yss[3])*Gs[99] - pow(E,yss[11])*Gs[107] + pow(E,yss[11])*ebar*Hs[54]))/pow(E,yss[11]) + ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[0])*Gs[96] + pow(E,yss[3])*Gs[99] - pow(E,yss[0])*Gs[107] - pow(E,yss[3])*Gs[107] - pow(E,yss[11])*ebar*Gs[107] + pow(E,yss[11])*Gs[110] + pow(E,yss[11])*ebar*Hs[54]))/pow(E,yss[11]);
	Nxx_sp_s[353]=(-((Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[105]*Hs[11])/pow(E,yss[8])) + (Pssp*pow(zbar,rrho)*Gs[105]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(E,yss[8]) - (Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[25]*Hs[51])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*Gs[25]*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]))/pow(E,yss[8]) - (Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[11]*Hs[51]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[51]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[11]*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*yss[9])/pow(E,yss[8]) - (Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*yss[9])/pow(E,yss[8]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-((pow(zbar,rrho)*Gs[25])/pow(E,yss[8])) + bbeta*Gs[31] - (rrho*rrhoz*pow(zbar,rrho)*Hs[11]*yss[9])/pow(E,yss[8]) + (pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*yss[9])/pow(E,yss[8])) + ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(bbeta*pow(E,yss[8])*Gs[111] + pow(zbar,rrho)*Gsp[120]*Hs[55]*yss[9] + pow(zbar,rrho)*(-Gs[105] + (-(rrho*rrhoz) + Gsp[56])*Hs[51]*yss[9] + (Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54])*yss[9])))/pow(E,yss[8]))/bbeta;
	Nxx_sp_s[354]=-((dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[10]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[50];
	Nxx_sp_s[355]=-((dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[11]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[51];
	Nxx_sp_s[356]=-((dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[12]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[52];
	Nxx_sp_s[357]=-((dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[15]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[55];
	Nxx_sp_s[358]=-((dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[14]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(rrhoe - Hs[54]);
	Nxx_sp_s[359]=-((dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[13]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[53];
	Nxx_sp_s[360]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[16]*Gs[112]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[17]*Gs[113] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])*(pow(E,yss[0])*Gs[112] - pow(pow(E,yss[1]),oomega)*Gs[113]) - pow(E,yss[8])*Pssp*Gs[24]*Gs[120] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[112] - pow(pow(E,yss[1]),oomega)*Gs[113])*Hs[15] + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])) - pow(E,yss[8])*Gs[24] + Hs[15]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])*Hs[63] + (Pssp*Hs[15]*Hs[63])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[112] - pow(pow(E,yss[1]),oomega)*Gs[113])) - pow(E,yss[8])*Gs[120] + Hs[63]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[361]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[113]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[113] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[114] - (pbar*pphi*Pssp*Gs[25]*Gs[117])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[21]*Gs[121])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[10] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[10] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[11] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[11] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[58] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[58] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[58] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[58] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[59] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[59] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[59] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[59] + (pbar*pphi*Pssp*Gs[25]*Gs[120]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[24]*Gs[121]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[24]*Gs[117]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[21]*Gs[120]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[24]*Gs[120]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[12]*Hs[60]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[60]*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[12]*(Gs[117]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[121] - Gs[120]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[17]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[18] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[11] - pbar*Hs[12]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[113]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[58] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[59] - pbar*Hs[60]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[117]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[121] - Gs[120]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[362]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[17]*Gs[113]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[113] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[113] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[114] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[114] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[25]*Gs[117] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[21]*Gs[121] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[10] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[11] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[11] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[58] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[58] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[59] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[59] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[59] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[59] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[25]*Gs[120]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[121]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[117]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[21]*Gs[120]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[120]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[23]*Gs[119]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[119]*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[23]*(Gs[117]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[121] - Gs[120]*yss[9])) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[17]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] - pow(E,yss[7])*pphi*Gs[23]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9]))) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[113]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[113] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[58] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[59] - pow(E,yss[7])*pphi*Gs[119]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[117]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[121] - Gs[120]*yss[9])));
	Nxx_sp_s[363]=-(pow(E,yss[8])*Pssp*Gs[24]*Gs[120]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[117]*Hs[11])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[117]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[21]*Hs[59])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[21]*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[11]*Hs[59]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[59]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[11]*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*((bbeta*pow(E,yss[8])*Gs[21])/pow(zbar,rrho) - pow(E,yss[8])*Gs[24] + Gs[25] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[11]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*((bbeta*pow(E,yss[8])*Gs[117])/pow(zbar,rrho) - pow(E,yss[8])*Gs[120] + Gs[121] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[59]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[364]=-(kkappa*Pssp*Gs[25]*Gs[118]) + pow(E,yss[8])*Pssp*Gs[24]*Gs[120] - kkappa*Pssp*Gs[22]*Gs[121] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[56] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[56] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*Hs[56] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*Hs[56] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[56] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[56] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*Hs[56] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[8]*Hs[58] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[10]*Hs[58] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*Hs[58] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[58] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[58] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[8]*Hs[59] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[10]*Hs[59] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[11]*Hs[59] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11]*Hs[59])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[59] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[59] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[59])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15]))*Hs[59])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[24]*(Hs[56] + Hs[59]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[8] + Hs[11])*(Gs[120] + Hs[56] + Hs[59]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*((-1 + Gsp[4])*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + rrhoz*Hs[59] + Gsp[52]*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*((-1 + Gsp[4])*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + rrhoz*Hs[59] + Gsp[52]*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*(Gsp[4]*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + (rrhoz + Gsp[52])*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11]*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15]))*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[11]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[56] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[59] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + rrhoz*Hs[59] + Gsp[52]*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[56] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[59] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + rrhoz*Hs[59] + Gsp[52]*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63])))/pow(zbar,rrho) - kkappa*Pssp*Gs[22]*Gs[118]*yss[9] + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(pow(E,yss[8])*Gs[24] - kkappa*Gs[25] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[8] + Hs[11]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])))/pow(zbar,rrho) - kkappa*Gs[22]*yss[9]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[8])*Gs[120] - kkappa*Gs[121] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[59])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[56] + Hs[59]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[56] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[59] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + rrhoz*Hs[59] + Gsp[52]*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63])))/pow(zbar,rrho) - kkappa*Gs[118]*yss[9]);
	Nxx_sp_s[365]=-(Pssp*Gs[22]*Gs[118]) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-Gs[22] + iiota*zbar*(Hs[8] + Hs[11])) + iiota*Pssp*zbar*(Hs[8] + Hs[11])*(Hs[56] + Hs[59]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-Gs[118] + iiota*zbar*(Hs[56] + Hs[59]));
	Nxx_sp_s[366]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[17]*Gs[113] - pow(E,yss[7])*Pssp*Gs[23]*Gs[119] + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[113] - pow(E,yss[7])*Gs[119]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[17] - pow(E,yss[7])*Gs[23])*(dP2ssp*Gs[121] + dP1ssp*Gs[122]);
	Nxx_sp_s[367]=-(pow(E,yss[0])*Pssp*Gs[16]*Gs[112]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[113] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[113] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[114] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[114] - pow(E,yss[3])*Pssp*Gs[19]*Gs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[10] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[10] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[11] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[11] - pphi*Pssp*Gs[117]*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[58] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[58] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[58] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[59] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[59] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[59] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[59] - pow(E,yss[2])*pbar*Pssp*(Gs[18] + Hs[12])*(Gs[114] + Hs[60]) - pphi*Pssp*Gs[21]*(pow(E,yss[1] + yss[7])*(Gs[113] + Gs[119]) + pow(E,yss[2])*pbar*(Gs[114] + Hs[60])) - pow(E,yss[11])*ebar*Pssp*Hs[14]*Hs[62] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[17] + Gs[23])*(Gs[113] + Gs[119])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[18] + Hs[12])*(Gs[114] + Hs[60])*yss[5] - (2*Pssp*zbar*Gs[21]*Gs[117]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[117]*Hs[9])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[21]*Hs[57])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[117]*Hs[11]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[21]*Hs[59]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[11]*Hs[57])/(1 + yss[5]) - (Pssp*zbar*Hs[9]*Hs[59])/(1 + yss[5]) - (Pssp*zbar*Hs[11]*Hs[59]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(1 - pow(E,yss[0])*Gs[16] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[18] - pow(E,yss[3])*Gs[19] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[21] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] - pow(E,yss[2])*pbar*(Gs[18] + Hs[12]) - pow(E,yss[11])*ebar*Hs[14] - pphi*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))*yss[5] + (zbar*Gs[21]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[9])/(1 + yss[5]) - (zbar*Hs[11]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(E,yss[0])*Gs[112]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[113] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[114] - pow(E,yss[3])*Gs[115] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[117] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[59] - pow(E,yss[2])*pbar*(Gs[114] + Hs[60]) - pow(E,yss[11])*ebar*Hs[62] - pphi*(pow(E,yss[1] + yss[7])*(Gs[113] + Gs[119]) + pow(E,yss[2])*pbar*(Gs[114] + Hs[60]))*yss[5] + (zbar*Gs[117]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[57])/(1 + yss[5]) - (zbar*Hs[59]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[368]=pow(E,yss[3])*Pssp*Gs[19]*Gs[115] + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(pow(E,yss[3])*Gs[19] - pow(E,xss[0])*zbar*(Hs[8] + Hs[11])) - pow(E,xss[0])*Pssp*zbar*(Hs[8] + Hs[11])*(Hs[56] + Hs[59]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[8] + Hs[11])*(Hs[56] + Hs[59]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[3])*Gs[115] - pow(E,xss[0])*zbar*(Hs[56] + Hs[59]));
	Nxx_sp_s[369]=-(pphi*Pssp*Gs[117]*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[22] + Hs[8] + Hs[11])*(Gs[118] + Hs[56] + Hs[59]) - pphi*Pssp*Gs[21]*(pow(E,yss[1] + yss[7])*(Gs[113] + Gs[119]) + pow(E,yss[2])*pbar*(Gs[114] + Hs[60])) + (2*Pssp*zbar*Gs[21]*Gs[117]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[117]*Hs[9])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[21]*Hs[57])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[117]*Hs[11]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[21]*Hs[59]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[11]*Hs[57])/(1 + yss[5]) + (Pssp*zbar*Hs[9]*Hs[59])/(1 + yss[5]) + (Pssp*zbar*Hs[11]*Hs[59]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[17] + Gs[23])*(Gs[113] + Gs[119])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[18] + Hs[12])*(Gs[114] + Hs[60])*(1 + yss[5]) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[21]) - Gs[26] + pow(E,xss[0])*kkappa*zbar*(Gs[22] + Hs[8] + Hs[11]) - (zbar*Gs[21]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[9])/(1 + yss[5]) + (zbar*Hs[11]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))*(1 + yss[5])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[117]) - Gs[122] + pow(E,xss[0])*kkappa*zbar*(Gs[118] + Hs[56] + Hs[59]) - (zbar*Gs[117]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[57])/(1 + yss[5]) + (zbar*Hs[59]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[113] + Gs[119]) + pow(E,yss[2])*pbar*(Gs[114] + Hs[60]))*(1 + yss[5]));
	Nxx_sp_s[370]=((-1 + nnus)*Gs[25] + nnus*Gs[26])*(dP2ssp*Gs[121] + dP1ssp*Gs[122]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*((-1 + nnus)*Gs[121] + nnus*Gs[122]);
	Nxx_sp_s[371]=(dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-Gs[21] - pow(E,bbar - xss[1])*ppsir*Hs[9] + Hs[13]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[9]*Hs[57] + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-Gs[117] - pow(E,bbar - xss[1])*ppsir*Hs[57] + Hs[61]);
	Nxx_sp_s[372]=pow(E,xss[0])*(-(Pssp*Gs[20]*Gs[116]) - (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(Gs[20] - Hs[8]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(Gs[116] - Hs[56]) + Pssp*Hs[8]*Hs[56]);
	Nxx_sp_s[373]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[113]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[113] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[114] + pow(E,yss[11])*Pssp*Gs[27]*Gs[123] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[10] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[10] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[11] + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[18] + pow(E,yss[11])*Gs[27] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] + pow(E,yss[2])*pbar*(Gs[18] + Hs[12])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[58] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[58] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[58] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[58] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[59] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[59] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[59] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[59] + pow(E,yss[2])*pbar*Pssp*(Gs[18] + Hs[12])*(Gs[114] + Hs[60]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[113]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[114] + pow(E,yss[11])*Gs[123] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[58] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[59] + pow(E,yss[2])*pbar*(Gs[114] + Hs[60]));
	Nxx_sp_s[374]=(Pssp*zbar*(Gs[27] - Hs[11])*Hs[57] + Pssp*zbar*Hs[9]*(Gs[123] - Hs[59]) - Pssp*zbar*(Gs[27] - Hs[11])*(Gs[123] - Hs[59])*xss[1] + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(pow(E,yss[11])*Gs[28] - zbar*Hs[9] + zbar*(Gs[27] - Hs[11])*xss[1]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[11])*Gs[124] - zbar*Hs[57] + zbar*(Gs[123] - Hs[59])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[375]=-((Pssp*zbar*Hs[11]*Hs[57])/pow(E,yss[11])) - (Pssp*zbar*Hs[9]*Hs[59])/pow(E,yss[11]) - (Pssp*(-1 + zbar)*Gs[27]*Gs[123]*xss[1])/pow(E,yss[11]) - (Pssp*zbar*Hs[11]*Hs[59]*xss[1])/pow(E,yss[11]) + (Pssp*Gs[123]*(-1 + zbar*Hs[9] + zbar*Hs[11]*xss[1]))/pow(E,yss[11]) + (Pssp*zbar*Gs[27]*(Hs[57] + Hs[59]*xss[1]))/pow(E,yss[11]) - ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(E,yss[11])*Gs[125]) + zbar*Hs[57] - (-1 + zbar)*Gs[123]*xss[1] + zbar*Hs[59]*xss[1]))/pow(E,yss[11]) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(Gs[29] + ((-1 + zbar)*Gs[27]*xss[1])/pow(E,yss[11]) - (-1 + zbar*Hs[9] + zbar*Hs[11]*xss[1])/pow(E,yss[11]));
	Nxx_sp_s[376]=pow(E,yss[0] - yss[11])*Pssp*Gs[16]*Gs[112] + pow(E,yss[3] - yss[11])*Pssp*Gs[19]*Gs[115] - Pssp*Gs[27]*Gs[123] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[27]*Gs[123])/pow(E,yss[11]) - (Pssp*Gs[123]*(pow(E,yss[0])*Gs[16] + pow(E,yss[3])*Gs[19] - pow(E,yss[11])*Gs[27] + pow(E,yss[11])*ebar*Hs[14]))/pow(E,yss[11]) + ((dP2ssp*Gs[121] + dP1ssp*Gs[122])*(pow(E,yss[0])*Gs[16] + pow(E,yss[3])*Gs[19] - pow(E,yss[0])*Gs[27] - pow(E,yss[3])*Gs[27] - pow(E,yss[11])*ebar*Gs[27] + pow(E,yss[11])*Gs[30] + pow(E,yss[11])*ebar*Hs[14]))/pow(E,yss[11]) + ebar*Pssp*Hs[14]*Hs[62] - (Pssp*Gs[27]*(pow(E,yss[0])*Gs[112] + pow(E,yss[3])*Gs[115] - pow(E,yss[11])*Gs[123] + pow(E,yss[11])*ebar*Hs[62]))/pow(E,yss[11]) + ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[0])*Gs[112] + pow(E,yss[3])*Gs[115] - pow(E,yss[0])*Gs[123] - pow(E,yss[3])*Gs[123] - pow(E,yss[11])*ebar*Gs[123] + pow(E,yss[11])*Gs[126] + pow(E,yss[11])*ebar*Hs[62]))/pow(E,yss[11]);
	Nxx_sp_s[377]=(-((Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[121]*Hs[11])/pow(E,yss[8])) + (Pssp*pow(zbar,rrho)*Gs[121]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(E,yss[8]) - (Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[25]*Hs[59])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*Gs[25]*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63]))/pow(E,yss[8]) - (Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[11]*Hs[59]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[59]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[11]*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*yss[9])/pow(E,yss[8]) - (Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*yss[9])/pow(E,yss[8]) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-((pow(zbar,rrho)*Gs[25])/pow(E,yss[8])) + bbeta*Gs[31] - (rrho*rrhoz*pow(zbar,rrho)*Hs[11]*yss[9])/pow(E,yss[8]) + (pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*yss[9])/pow(E,yss[8])) + ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(bbeta*pow(E,yss[8])*Gs[127] + pow(zbar,rrho)*(-Gs[121] + (-(rrho*rrhoz) + Gsp[56])*Hs[59]*yss[9] + (Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*yss[9])))/pow(E,yss[8]))/bbeta;
	Nxx_sp_s[378]=-((dP2ssp*Gs[121] + dP1ssp*Gs[122])*Hs[10]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[58];
	Nxx_sp_s[379]=-((dP2ssp*Gs[121] + dP1ssp*Gs[122])*Hs[11]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[59];
	Nxx_sp_s[380]=-((dP2ssp*Gs[121] + dP1ssp*Gs[122])*Hs[12]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[60];
	Nxx_sp_s[381]=-((dP2ssp*Gs[121] + dP1ssp*Gs[122])*Hs[15]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(rrhod - Hs[63]);
	Nxx_sp_s[382]=-((dP2ssp*Gs[121] + dP1ssp*Gs[122])*Hs[14]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[62];
	Nxx_sp_s[383]=-((dP2ssp*Gs[121] + dP1ssp*Gs[122])*Hs[13]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[61];
	Nxx_sp_s[432]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*pow(Gs[32],2)) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*pow(Gs[33],2) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*pow(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33],2) - pow(E,yss[8])*Pssp*pow(Gs[40],2) - 2*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])*Hs[23] + (Pssp*pow(Hs[23],2))/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + 2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])) - pow(E,yss[8])*Gs[40] + Hs[23]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[433]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[33],2)) + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[34] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[34],2) - (2*pbar*pphi*Pssp*Gs[37]*Gs[41])/pow(E,yss[8]) - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[18] + 2*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[18] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[18],2) - 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[19] + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[19] - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[19] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[19],2) + (2*pbar*pphi*Pssp*Gs[40]*Gs[41]*(1 + yss[5]))/pow(E,yss[8]) + (2*pbar*pphi*Pssp*Gs[37]*Gs[40]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*pow(Gs[40],2)*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*pow(Hs[20],2)*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (2*pbar*pphi*Pssp*Hs[20]*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])))/pow(E,yss[8]) + 2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[33]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[34] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[19] - pbar*Hs[20]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[434]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*pow(Gs[33],2)) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[33],2) - 2*(-1 + aalpha)*aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[34] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[34],2) - 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[37]*Gs[41] + 2*(-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[18] - 2*aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[18],2) + 2*(-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[19] - 2*pow(aalpha,2)*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[19] + 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[19] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[19],2) + 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[40]*Gs[41]*(1 + yss[5]) + 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[37]*Gs[40]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*pow(Gs[40],2)*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*pow(Gs[39],2)*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - 2*pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[39]*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])) + 2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[33]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] - pow(E,yss[7])*pphi*Gs[39]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])));
	Nxx_sp_s[435]=-(pow(E,yss[8])*Pssp*pow(Gs[40],2)) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[37]*Hs[19])/pow(zbar,rrho) + (2*bbeta*pow(E,yss[8])*Pssp*Gs[37]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(Hs[19],2)*(1 + yss[5]))/pow(zbar,rrho) - (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[19]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23],2)*(1 + yss[5]))/pow(zbar,rrho) + 2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*((bbeta*pow(E,yss[8])*Gs[37])/pow(zbar,rrho) - pow(E,yss[8])*Gs[40] + Gs[41] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[19]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[436]=pow(E,yss[8])*Pssp*pow(Gs[40],2) - 2*kkappa*Pssp*Gs[38]*Gs[41] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[16],2) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[16],2) - 2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[16]*Hs[18] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*pow(Hs[18],2) - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[16]*Hs[19] - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[18]*Hs[19] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*pow(Hs[19],2) - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*pow(Hs[19],2))/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[40]*(Hs[16] + Hs[19]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[16] + Hs[19])*(Gs[40] + Hs[16] + Hs[19]) - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - 2*pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23],2) + 2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + 2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + 2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*pow(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23],2) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23],2) + 2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23],2) + (2*bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*pow(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23],2))/pow(zbar,rrho) + (2*bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[19]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])))/pow(zbar,rrho) - (2*bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])))/pow(zbar,rrho) - kkappa*Pssp*pow(Gs[38],2)*yss[9] + 2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[8])*Gs[40] - kkappa*Gs[41] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[16] + Hs[19]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])))/pow(zbar,rrho) - kkappa*Gs[38]*yss[9]);
	Nxx_sp_s[437]=-(Pssp*pow(Gs[38],2)) + iiota*Pssp*zbar*pow(Hs[16] + Hs[19],2) + 2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-Gs[38] + iiota*zbar*(Hs[16] + Hs[19]));
	Nxx_sp_s[438]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*pow(Gs[33],2) - pow(E,yss[7])*Pssp*pow(Gs[39],2) + 2*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[33] - pow(E,yss[7])*Gs[39])*(dP2ssp*Gs[41] + dP1ssp*Gs[42]);
	Nxx_sp_s[439]=-(pow(E,yss[0])*Pssp*pow(Gs[32],2)) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[33],2) - 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[34] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[34],2) - pow(E,yss[3])*Pssp*pow(Gs[35],2) + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[18] - 2*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[18] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[18],2) + 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[19] - 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[19] + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[19] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[19],2) - pow(E,yss[2])*pbar*Pssp*pow(Gs[34] + Hs[20],2) - 2*pphi*Pssp*Gs[37]*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20])) - pow(E,yss[11])*ebar*Pssp*pow(Hs[22],2) - pow(E,yss[1] + yss[7])*pphi*Pssp*pow(Gs[33] + Gs[39],2)*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*pow(Gs[34] + Hs[20],2)*yss[5] - (2*Pssp*zbar*pow(Gs[37],2)*xss[1])/pow(1 + yss[5],3) + (2*Pssp*zbar*Gs[37]*Hs[17])/pow(1 + yss[5],2) + (2*Pssp*zbar*Gs[37]*Hs[19]*xss[1])/pow(1 + yss[5],2) - (2*Pssp*zbar*Hs[17]*Hs[19])/(1 + yss[5]) - (Pssp*zbar*pow(Hs[19],2)*xss[1])/(1 + yss[5]) + 2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(E,yss[0])*Gs[32]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[34] - pow(E,yss[3])*Gs[35] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[37] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] - pow(E,yss[2])*pbar*(Gs[34] + Hs[20]) - pow(E,yss[11])*ebar*Hs[22] - pphi*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))*yss[5] + (zbar*Gs[37]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[17])/(1 + yss[5]) - (zbar*Hs[19]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[440]=pow(E,yss[3])*Pssp*pow(Gs[35],2) - pow(E,xss[0])*Pssp*zbar*pow(Hs[16] + Hs[19],2) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*pow(Hs[16] + Hs[19],2) + 2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[3])*Gs[35] - pow(E,xss[0])*zbar*(Hs[16] + Hs[19]));
	Nxx_sp_s[441]=pow(E,xss[0])*kkappa*Pssp*zbar*pow(Gs[38] + Hs[16] + Hs[19],2) - 2*pphi*Pssp*Gs[37]*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20])) + (2*Pssp*zbar*pow(Gs[37],2)*xss[1])/pow(1 + yss[5],3) - (2*Pssp*zbar*Gs[37]*Hs[17])/pow(1 + yss[5],2) - (2*Pssp*zbar*Gs[37]*Hs[19]*xss[1])/pow(1 + yss[5],2) + (2*Pssp*zbar*Hs[17]*Hs[19])/(1 + yss[5]) + (Pssp*zbar*pow(Hs[19],2)*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*pow(Gs[33] + Gs[39],2)*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*pow(Gs[34] + Hs[20],2)*(1 + yss[5]) + 2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[37]) - Gs[42] + pow(E,xss[0])*kkappa*zbar*(Gs[38] + Hs[16] + Hs[19]) - (zbar*Gs[37]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[17])/(1 + yss[5]) + (zbar*Hs[19]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))*(1 + yss[5]));
	Nxx_sp_s[442]=2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*((-1 + nnus)*Gs[41] + nnus*Gs[42]);
	Nxx_sp_s[443]=pow(E,bbar - xss[1])*ppsir*Pssp*pow(Hs[17],2) + 2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-Gs[37] - pow(E,bbar - xss[1])*ppsir*Hs[17] + Hs[21]);
	Nxx_sp_s[444]=-(pow(E,xss[0])*(Gs[36] - Hs[16])*(2*dP2ssp*Gs[41] + 2*dP1ssp*Gs[42] + Pssp*(Gs[36] + Hs[16])));
	Nxx_sp_s[445]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[33],2)) + 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[34],2) + pow(E,yss[11])*Pssp*pow(Gs[43],2) - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[18] + 2*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[18] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[18],2) - 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[19] + 2*aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[19] - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[19] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[19],2) + pow(E,yss[2])*pbar*Pssp*pow(Gs[34] + Hs[20],2) + 2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[34] + pow(E,yss[11])*Gs[43] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]));
	Nxx_sp_s[446]=(2*Pssp*zbar*Hs[17]*(Gs[43] - Hs[19]) - Pssp*zbar*pow(Gs[43] - Hs[19],2)*xss[1] + 2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[11])*Gs[44] - zbar*Hs[17] + zbar*(Gs[43] - Hs[19])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[447]=(-2*Pssp*zbar*Hs[17]*Hs[19] - Pssp*(-1 + zbar)*pow(Gs[43],2)*xss[1] - Pssp*zbar*pow(Hs[19],2)*xss[1] + 2*Pssp*zbar*Gs[43]*(Hs[17] + Hs[19]*xss[1]) - 2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(E,yss[11])*Gs[45]) + zbar*Hs[17] - (-1 + zbar)*Gs[43]*xss[1] + zbar*Hs[19]*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[448]=pow(E,yss[0] - yss[11])*Pssp*pow(Gs[32],2) + pow(E,yss[3] - yss[11])*Pssp*pow(Gs[35],2) - Pssp*pow(Gs[43],2) + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*pow(Gs[43],2))/pow(E,yss[11]) + ebar*Pssp*pow(Hs[22],2) + (2*Pssp*Gs[43]*(-(pow(E,yss[0])*Gs[32]) - pow(E,yss[3])*Gs[35] + pow(E,yss[11])*Gs[43] - pow(E,yss[11])*ebar*Hs[22]))/pow(E,yss[11]) + (2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[0])*Gs[32] + pow(E,yss[3])*Gs[35] - pow(E,yss[0])*Gs[43] - pow(E,yss[3])*Gs[43] - pow(E,yss[11])*ebar*Gs[43] + pow(E,yss[11])*Gs[46] + pow(E,yss[11])*ebar*Hs[22]))/pow(E,yss[11]);
	Nxx_sp_s[449]=(-2*Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[41]*Hs[19] + 2*Pssp*pow(zbar,rrho)*Gs[41]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*pow(Hs[19],2)*yss[9] + 2*Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[19]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*yss[9] - Pssp*pow(zbar,rrho)*pow(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23],2)*yss[9] + 2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*(bbeta*pow(E,yss[8])*Gs[47] + pow(zbar,rrho)*Gsp[120]*Hs[23]*yss[9] + pow(zbar,rrho)*(-Gs[41] + Gsp[8]*Hs[16]*yss[9] + Gsp[24]*Hs[17]*yss[9] + Gsp[40]*Hs[18]*yss[9] - rrho*rrhoz*Hs[19]*yss[9] + Gsp[56]*Hs[19]*yss[9] + Gsp[72]*Hs[20]*yss[9] + Gsp[88]*Hs[21]*yss[9] + Gsp[104]*Hs[22]*yss[9])))/(bbeta*pow(E,yss[8]));
	Nxx_sp_s[450]=2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*(rrhoa - Hs[18]);
	Nxx_sp_s[451]=-2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[19];
	Nxx_sp_s[452]=-2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[20];
	Nxx_sp_s[453]=-2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[23];
	Nxx_sp_s[454]=-2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[22];
	Nxx_sp_s[455]=-2*(dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[21];
	Nxx_sp_s[456]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[32]*Gs[48]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[33]*Gs[49] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])*(pow(E,yss[0])*Gs[48] - pow(pow(E,yss[1]),oomega)*Gs[49]) - pow(E,yss[8])*Pssp*Gs[40]*Gs[56] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[48] - pow(pow(E,yss[1]),oomega)*Gs[49])*Hs[23] + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])) - pow(E,yss[8])*Gs[40] + Hs[23]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])*Hs[31] + (Pssp*Hs[23]*Hs[31])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[48] - pow(pow(E,yss[1]),oomega)*Gs[49])) - pow(E,yss[8])*Gs[56] + Hs[31]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[457]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[49]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[49] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[50] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[50] - (pbar*pphi*Pssp*Gs[41]*Gs[53])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[37]*Gs[57])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[18] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[18] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[19] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[19] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[26] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[26] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[26] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[26] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[27] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[27] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[27] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[27] + (pbar*pphi*Pssp*Gs[41]*Gs[56]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[40]*Gs[57]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[40]*Gs[53]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[37]*Gs[56]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[40]*Gs[56]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[20]*Hs[28]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[28]*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[20]*(Gs[53]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[57] - Gs[56]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[33]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[34] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[19] - pbar*Hs[20]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[49]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[50] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[26] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[27] - pbar*Hs[28]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[53]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[57] - Gs[56]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[458]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[33]*Gs[49]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[49] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[49] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[50] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[50] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[41]*Gs[53] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[37]*Gs[57] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[18] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[19] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[19] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[26] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[26] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[27] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[27] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[27] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[27] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[41]*Gs[56]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[40]*Gs[57]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[40]*Gs[53]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[37]*Gs[56]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[40]*Gs[56]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[39]*Gs[55]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[55]*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[39]*(Gs[53]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[57] - Gs[56]*yss[9])) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[33]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] - pow(E,yss[7])*pphi*Gs[39]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9]))) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[49]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[49] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[26] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[27] - pow(E,yss[7])*pphi*Gs[55]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[53]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[57] - Gs[56]*yss[9])));
	Nxx_sp_s[459]=-(pow(E,yss[8])*Pssp*Gs[40]*Gs[56]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[53]*Hs[19])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[53]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[37]*Hs[27])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[37]*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[19]*Hs[27]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*Hs[27]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[19]*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*((bbeta*pow(E,yss[8])*Gs[37])/pow(zbar,rrho) - pow(E,yss[8])*Gs[40] + Gs[41] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[19]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*((bbeta*pow(E,yss[8])*Gs[53])/pow(zbar,rrho) - pow(E,yss[8])*Gs[56] + Gs[57] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[27]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[460]=-(kkappa*Pssp*Gs[41]*Gs[54]) + pow(E,yss[8])*Pssp*Gs[40]*Gs[56] - kkappa*Pssp*Gs[38]*Gs[57] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*Hs[24] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[24] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*Hs[24] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*Hs[24] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*Hs[24] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*Hs[24] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])*Hs[24] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[16]*Hs[26] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[18]*Hs[26] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*Hs[26] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*Hs[26] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*Hs[26] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[16]*Hs[27] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[18]*Hs[27] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[19]*Hs[27] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19]*Hs[27])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*Hs[27] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*Hs[27] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*Hs[27])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23]))*Hs[27])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[40]*(Hs[24] + Hs[27]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[16] + Hs[19])*(Gs[56] + Hs[24] + Hs[27]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])*(Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19]*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23]))*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[19]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[24] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[27] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[24] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[27] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31])))/pow(zbar,rrho) - kkappa*Pssp*Gs[38]*Gs[54]*yss[9] + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(pow(E,yss[8])*Gs[40] - kkappa*Gs[41] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[16] + Hs[19]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])))/pow(zbar,rrho) - kkappa*Gs[38]*yss[9]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[8])*Gs[56] - kkappa*Gs[57] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[27])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[24] + Hs[27]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[24] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[27] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31])))/pow(zbar,rrho) - kkappa*Gs[54]*yss[9]);
	Nxx_sp_s[461]=-(Pssp*Gs[38]*Gs[54]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-Gs[38] + iiota*zbar*(Hs[16] + Hs[19])) + iiota*Pssp*zbar*(Hs[16] + Hs[19])*(Hs[24] + Hs[27]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-Gs[54] + iiota*zbar*(Hs[24] + Hs[27]));
	Nxx_sp_s[462]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[33]*Gs[49] - pow(E,yss[7])*Pssp*Gs[39]*Gs[55] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[49] - pow(E,yss[7])*Gs[55]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[33] - pow(E,yss[7])*Gs[39])*(dP2ssp*Gs[57] + dP1ssp*Gs[58]);
	Nxx_sp_s[463]=-(pow(E,yss[0])*Pssp*Gs[32]*Gs[48]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[49] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[49] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[50] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[50] - pow(E,yss[3])*Pssp*Gs[35]*Gs[51] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[18] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[19] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[19] - pphi*Pssp*Gs[53]*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[26] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[26] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[26] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[27] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[27] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[27] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[27] - pow(E,yss[2])*pbar*Pssp*(Gs[34] + Hs[20])*(Gs[50] + Hs[28]) - pphi*Pssp*Gs[37]*(pow(E,yss[1] + yss[7])*(Gs[49] + Gs[55]) + pow(E,yss[2])*pbar*(Gs[50] + Hs[28])) - pow(E,yss[11])*ebar*Pssp*Hs[22]*Hs[30] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[33] + Gs[39])*(Gs[49] + Gs[55])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[34] + Hs[20])*(Gs[50] + Hs[28])*yss[5] - (2*Pssp*zbar*Gs[37]*Gs[53]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[53]*Hs[17])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[37]*Hs[25])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[53]*Hs[19]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[37]*Hs[27]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[19]*Hs[25])/(1 + yss[5]) - (Pssp*zbar*Hs[17]*Hs[27])/(1 + yss[5]) - (Pssp*zbar*Hs[19]*Hs[27]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(pow(E,yss[0])*Gs[32]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[34] - pow(E,yss[3])*Gs[35] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[37] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] - pow(E,yss[2])*pbar*(Gs[34] + Hs[20]) - pow(E,yss[11])*ebar*Hs[22] - pphi*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))*yss[5] + (zbar*Gs[37]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[17])/(1 + yss[5]) - (zbar*Hs[19]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(E,yss[0])*Gs[48]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[49] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[50] - pow(E,yss[3])*Gs[51] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[53] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[27] - pow(E,yss[2])*pbar*(Gs[50] + Hs[28]) - pow(E,yss[11])*ebar*Hs[30] - pphi*(pow(E,yss[1] + yss[7])*(Gs[49] + Gs[55]) + pow(E,yss[2])*pbar*(Gs[50] + Hs[28]))*yss[5] + (zbar*Gs[53]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[25])/(1 + yss[5]) - (zbar*Hs[27]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[464]=pow(E,yss[3])*Pssp*Gs[35]*Gs[51] + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(pow(E,yss[3])*Gs[35] - pow(E,xss[0])*zbar*(Hs[16] + Hs[19])) - pow(E,xss[0])*Pssp*zbar*(Hs[16] + Hs[19])*(Hs[24] + Hs[27]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[16] + Hs[19])*(Hs[24] + Hs[27]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[3])*Gs[51] - pow(E,xss[0])*zbar*(Hs[24] + Hs[27]));
	Nxx_sp_s[465]=-(pphi*Pssp*Gs[53]*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[38] + Hs[16] + Hs[19])*(Gs[54] + Hs[24] + Hs[27]) - pphi*Pssp*Gs[37]*(pow(E,yss[1] + yss[7])*(Gs[49] + Gs[55]) + pow(E,yss[2])*pbar*(Gs[50] + Hs[28])) + (2*Pssp*zbar*Gs[37]*Gs[53]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[53]*Hs[17])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[37]*Hs[25])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[53]*Hs[19]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[37]*Hs[27]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[19]*Hs[25])/(1 + yss[5]) + (Pssp*zbar*Hs[17]*Hs[27])/(1 + yss[5]) + (Pssp*zbar*Hs[19]*Hs[27]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[33] + Gs[39])*(Gs[49] + Gs[55])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[34] + Hs[20])*(Gs[50] + Hs[28])*(1 + yss[5]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[37]) - Gs[42] + pow(E,xss[0])*kkappa*zbar*(Gs[38] + Hs[16] + Hs[19]) - (zbar*Gs[37]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[17])/(1 + yss[5]) + (zbar*Hs[19]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))*(1 + yss[5])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[53]) - Gs[58] + pow(E,xss[0])*kkappa*zbar*(Gs[54] + Hs[24] + Hs[27]) - (zbar*Gs[53]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[25])/(1 + yss[5]) + (zbar*Hs[27]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[49] + Gs[55]) + pow(E,yss[2])*pbar*(Gs[50] + Hs[28]))*(1 + yss[5]));
	Nxx_sp_s[466]=((-1 + nnus)*Gs[41] + nnus*Gs[42])*(dP2ssp*Gs[57] + dP1ssp*Gs[58]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*((-1 + nnus)*Gs[57] + nnus*Gs[58]);
	Nxx_sp_s[467]=(dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-Gs[37] - pow(E,bbar - xss[1])*ppsir*Hs[17] + Hs[21]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[17]*Hs[25] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-Gs[53] - pow(E,bbar - xss[1])*ppsir*Hs[25] + Hs[29]);
	Nxx_sp_s[468]=pow(E,xss[0])*(-(Pssp*Gs[36]*Gs[52]) - (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(Gs[36] - Hs[16]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(Gs[52] - Hs[24]) + Pssp*Hs[16]*Hs[24]);
	Nxx_sp_s[469]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[49]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[49] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[50] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[50] + pow(E,yss[11])*Pssp*Gs[43]*Gs[59] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[18] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[18] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[19] + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[34] + pow(E,yss[11])*Gs[43] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] + pow(E,yss[2])*pbar*(Gs[34] + Hs[20])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[26] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[26] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[26] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[26] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[27] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[27] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[27] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[27] + pow(E,yss[2])*pbar*Pssp*(Gs[34] + Hs[20])*(Gs[50] + Hs[28]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[49]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[50] + pow(E,yss[11])*Gs[59] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[26] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[27] + pow(E,yss[2])*pbar*(Gs[50] + Hs[28]));
	Nxx_sp_s[470]=(Pssp*zbar*(Gs[43] - Hs[19])*Hs[25] + Pssp*zbar*Hs[17]*(Gs[59] - Hs[27]) - Pssp*zbar*(Gs[43] - Hs[19])*(Gs[59] - Hs[27])*xss[1] + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(pow(E,yss[11])*Gs[44] - zbar*Hs[17] + zbar*(Gs[43] - Hs[19])*xss[1]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[11])*Gs[60] - zbar*Hs[25] + zbar*(Gs[59] - Hs[27])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[471]=(-(Pssp*zbar*Hs[19]*Hs[25]) - Pssp*zbar*Hs[17]*Hs[27] - Pssp*(-1 + zbar)*Gs[43]*Gs[59]*xss[1] - Pssp*zbar*Hs[19]*Hs[27]*xss[1] + Pssp*zbar*Gs[59]*(Hs[17] + Hs[19]*xss[1]) - (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(pow(E,yss[11])*Gs[45]) + zbar*Hs[17] - (-1 + zbar)*Gs[43]*xss[1] + zbar*Hs[19]*xss[1]) + Pssp*zbar*Gs[43]*(Hs[25] + Hs[27]*xss[1]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(E,yss[11])*Gs[61]) + zbar*Hs[25] - (-1 + zbar)*Gs[59]*xss[1] + zbar*Hs[27]*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[472]=pow(E,yss[0] - yss[11])*Pssp*Gs[32]*Gs[48] + pow(E,yss[3] - yss[11])*Pssp*Gs[35]*Gs[51] - Pssp*Gs[43]*Gs[59] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[43]*Gs[59])/pow(E,yss[11]) - (Pssp*Gs[59]*(pow(E,yss[0])*Gs[32] + pow(E,yss[3])*Gs[35] - pow(E,yss[11])*Gs[43] + pow(E,yss[11])*ebar*Hs[22]))/pow(E,yss[11]) + ((dP2ssp*Gs[57] + dP1ssp*Gs[58])*(pow(E,yss[0])*Gs[32] + pow(E,yss[3])*Gs[35] - pow(E,yss[0])*Gs[43] - pow(E,yss[3])*Gs[43] - pow(E,yss[11])*ebar*Gs[43] + pow(E,yss[11])*Gs[46] + pow(E,yss[11])*ebar*Hs[22]))/pow(E,yss[11]) + ebar*Pssp*Hs[22]*Hs[30] - (Pssp*Gs[43]*(pow(E,yss[0])*Gs[48] + pow(E,yss[3])*Gs[51] - pow(E,yss[11])*Gs[59] + pow(E,yss[11])*ebar*Hs[30]))/pow(E,yss[11]) + ((dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[0])*Gs[48] + pow(E,yss[3])*Gs[51] - pow(E,yss[0])*Gs[59] - pow(E,yss[3])*Gs[59] - pow(E,yss[11])*ebar*Gs[59] + pow(E,yss[11])*Gs[62] + pow(E,yss[11])*ebar*Hs[30]))/pow(E,yss[11]);
	Nxx_sp_s[473]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[57]*Hs[19]) + Pssp*pow(zbar,rrho)*Gs[57]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[41]*Hs[27] + Pssp*pow(zbar,rrho)*Gs[41]*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[19]*Hs[27]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*Hs[27]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[19]*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*yss[9] + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(bbeta*pow(E,yss[8])*Gs[47] + pow(zbar,rrho)*Gsp[120]*Hs[23]*yss[9] + pow(zbar,rrho)*(-Gs[41] + Gsp[8]*Hs[16]*yss[9] + Gsp[24]*Hs[17]*yss[9] + Gsp[40]*Hs[18]*yss[9] - rrho*rrhoz*Hs[19]*yss[9] + Gsp[56]*Hs[19]*yss[9] + Gsp[72]*Hs[20]*yss[9] + Gsp[88]*Hs[21]*yss[9] + Gsp[104]*Hs[22]*yss[9])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(bbeta*pow(E,yss[8])*Gs[63] + pow(zbar,rrho)*Gsp[120]*Hs[31]*yss[9] + pow(zbar,rrho)*(-Gs[57] + Gsp[8]*Hs[24]*yss[9] + Gsp[24]*Hs[25]*yss[9] + Gsp[40]*Hs[26]*yss[9] - rrho*rrhoz*Hs[27]*yss[9] + Gsp[56]*Hs[27]*yss[9] + Gsp[72]*Hs[28]*yss[9] + Gsp[88]*Hs[29]*yss[9] + Gsp[104]*Hs[30]*yss[9])))/(bbeta*pow(E,yss[8]));
	Nxx_sp_s[474]=(dP2ssp*Gs[57] + dP1ssp*Gs[58])*(rrhoa - Hs[18]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[26];
	Nxx_sp_s[475]=-((dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[19]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(rrhoz - Hs[27]);
	Nxx_sp_s[476]=-((dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[20]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[28];
	Nxx_sp_s[477]=-((dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[23]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[31];
	Nxx_sp_s[478]=-((dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[22]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[30];
	Nxx_sp_s[479]=-((dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[21]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[29];
	Nxx_sp_s[480]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[32]*Gs[64]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[33]*Gs[65] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])*(pow(E,yss[0])*Gs[64] - pow(pow(E,yss[1]),oomega)*Gs[65]) - pow(E,yss[8])*Pssp*Gs[40]*Gs[72] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[64] - pow(pow(E,yss[1]),oomega)*Gs[65])*Hs[23] + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])) - pow(E,yss[8])*Gs[40] + Hs[23]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])*Hs[39] + (Pssp*Hs[23]*Hs[39])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[64] - pow(pow(E,yss[1]),oomega)*Gs[65])) - pow(E,yss[8])*Gs[72] + Hs[39]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[481]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[65]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[65] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[66] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[66] - (pbar*pphi*Pssp*Gs[41]*Gs[69])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[37]*Gs[73])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[18] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[18] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[19] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[19] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[34] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[34] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[34] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[34] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[35] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[35] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[35] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[35] + (pbar*pphi*Pssp*Gs[41]*Gs[72]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[40]*Gs[73]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[40]*Gs[69]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[37]*Gs[72]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[40]*Gs[72]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[20]*Hs[36]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[36]*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[20]*(Gs[69]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[73] - Gs[72]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[33]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[34] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[19] - pbar*Hs[20]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[65]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[66] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[34] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[35] - pbar*Hs[36]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[69]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[73] - Gs[72]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[482]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[33]*Gs[65]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[65] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[65] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[66] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[66] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[41]*Gs[69] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[37]*Gs[73] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[18] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[19] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[19] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[34] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[34] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[35] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[35] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[35] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[35] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[41]*Gs[72]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[40]*Gs[73]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[40]*Gs[69]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[37]*Gs[72]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[40]*Gs[72]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[39]*Gs[71]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[71]*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[39]*(Gs[69]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[73] - Gs[72]*yss[9])) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[33]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] - pow(E,yss[7])*pphi*Gs[39]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9]))) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[65]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[65] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[34] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[35] - pow(E,yss[7])*pphi*Gs[71]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[69]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[73] - Gs[72]*yss[9])));
	Nxx_sp_s[483]=-(pow(E,yss[8])*Pssp*Gs[40]*Gs[72]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[69]*Hs[19])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[69]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[37]*Hs[35])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[37]*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[19]*Hs[35]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*Hs[35]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[19]*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*((bbeta*pow(E,yss[8])*Gs[37])/pow(zbar,rrho) - pow(E,yss[8])*Gs[40] + Gs[41] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[19]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*((bbeta*pow(E,yss[8])*Gs[69])/pow(zbar,rrho) - pow(E,yss[8])*Gs[72] + Gs[73] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[35]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[484]=-(kkappa*Pssp*Gs[41]*Gs[70]) + pow(E,yss[8])*Pssp*Gs[40]*Gs[72] - kkappa*Pssp*Gs[38]*Gs[73] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*Hs[32] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[32] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*Hs[32] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*Hs[32] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*Hs[32] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*Hs[32] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])*Hs[32] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[16]*Hs[34] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[18]*Hs[34] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*Hs[34] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*Hs[34] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*Hs[34] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[16]*Hs[35] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[18]*Hs[35] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[19]*Hs[35] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19]*Hs[35])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*Hs[35] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*Hs[35] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*Hs[35])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23]))*Hs[35])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[40]*(Hs[32] + Hs[35]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[16] + Hs[19])*(Gs[72] + Hs[32] + Hs[35]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])*(Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19]*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23]))*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[19]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[32] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[35] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[32] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[35] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39])))/pow(zbar,rrho) - kkappa*Pssp*Gs[38]*Gs[70]*yss[9] + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(pow(E,yss[8])*Gs[40] - kkappa*Gs[41] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[16] + Hs[19]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])))/pow(zbar,rrho) - kkappa*Gs[38]*yss[9]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[8])*Gs[72] - kkappa*Gs[73] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[35])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[32] + Hs[35]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[32] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[35] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39])))/pow(zbar,rrho) - kkappa*Gs[70]*yss[9]);
	Nxx_sp_s[485]=-(Pssp*Gs[38]*Gs[70]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-Gs[38] + iiota*zbar*(Hs[16] + Hs[19])) + iiota*Pssp*zbar*(Hs[16] + Hs[19])*(Hs[32] + Hs[35]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-Gs[70] + iiota*zbar*(Hs[32] + Hs[35]));
	Nxx_sp_s[486]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[33]*Gs[65] - pow(E,yss[7])*Pssp*Gs[39]*Gs[71] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[65] - pow(E,yss[7])*Gs[71]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[33] - pow(E,yss[7])*Gs[39])*(dP2ssp*Gs[73] + dP1ssp*Gs[74]);
	Nxx_sp_s[487]=-(pow(E,yss[0])*Pssp*Gs[32]*Gs[64]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[65] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[65] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[66] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[66] - pow(E,yss[3])*Pssp*Gs[35]*Gs[67] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[18] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[19] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[19] - pphi*Pssp*Gs[69]*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[34] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[34] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[35] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[35] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[35] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[35] - pow(E,yss[2])*pbar*Pssp*(Gs[34] + Hs[20])*(Gs[66] + Hs[36]) - pphi*Pssp*Gs[37]*(pow(E,yss[1] + yss[7])*(Gs[65] + Gs[71]) + pow(E,yss[2])*pbar*(Gs[66] + Hs[36])) - pow(E,yss[11])*ebar*Pssp*Hs[22]*Hs[38] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[33] + Gs[39])*(Gs[65] + Gs[71])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[34] + Hs[20])*(Gs[66] + Hs[36])*yss[5] - (2*Pssp*zbar*Gs[37]*Gs[69]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[69]*Hs[17])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[37]*Hs[33])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[69]*Hs[19]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[37]*Hs[35]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[19]*Hs[33])/(1 + yss[5]) - (Pssp*zbar*Hs[17]*Hs[35])/(1 + yss[5]) - (Pssp*zbar*Hs[19]*Hs[35]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(pow(E,yss[0])*Gs[32]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[34] - pow(E,yss[3])*Gs[35] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[37] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] - pow(E,yss[2])*pbar*(Gs[34] + Hs[20]) - pow(E,yss[11])*ebar*Hs[22] - pphi*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))*yss[5] + (zbar*Gs[37]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[17])/(1 + yss[5]) - (zbar*Hs[19]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(E,yss[0])*Gs[64]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[65] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[66] - pow(E,yss[3])*Gs[67] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[69] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[35] - pow(E,yss[2])*pbar*(Gs[66] + Hs[36]) - pow(E,yss[11])*ebar*Hs[38] - pphi*(pow(E,yss[1] + yss[7])*(Gs[65] + Gs[71]) + pow(E,yss[2])*pbar*(Gs[66] + Hs[36]))*yss[5] + (zbar*Gs[69]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[33])/(1 + yss[5]) - (zbar*Hs[35]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[488]=pow(E,yss[3])*Pssp*Gs[35]*Gs[67] + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(pow(E,yss[3])*Gs[35] - pow(E,xss[0])*zbar*(Hs[16] + Hs[19])) - pow(E,xss[0])*Pssp*zbar*(Hs[16] + Hs[19])*(Hs[32] + Hs[35]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[16] + Hs[19])*(Hs[32] + Hs[35]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[3])*Gs[67] - pow(E,xss[0])*zbar*(Hs[32] + Hs[35]));
	Nxx_sp_s[489]=-(pphi*Pssp*Gs[69]*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[38] + Hs[16] + Hs[19])*(Gs[70] + Hs[32] + Hs[35]) - pphi*Pssp*Gs[37]*(pow(E,yss[1] + yss[7])*(Gs[65] + Gs[71]) + pow(E,yss[2])*pbar*(Gs[66] + Hs[36])) + (2*Pssp*zbar*Gs[37]*Gs[69]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[69]*Hs[17])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[37]*Hs[33])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[69]*Hs[19]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[37]*Hs[35]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[19]*Hs[33])/(1 + yss[5]) + (Pssp*zbar*Hs[17]*Hs[35])/(1 + yss[5]) + (Pssp*zbar*Hs[19]*Hs[35]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[33] + Gs[39])*(Gs[65] + Gs[71])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[34] + Hs[20])*(Gs[66] + Hs[36])*(1 + yss[5]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[37]) - Gs[42] + pow(E,xss[0])*kkappa*zbar*(Gs[38] + Hs[16] + Hs[19]) - (zbar*Gs[37]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[17])/(1 + yss[5]) + (zbar*Hs[19]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))*(1 + yss[5])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[69]) - Gs[74] + pow(E,xss[0])*kkappa*zbar*(Gs[70] + Hs[32] + Hs[35]) - (zbar*Gs[69]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[33])/(1 + yss[5]) + (zbar*Hs[35]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[65] + Gs[71]) + pow(E,yss[2])*pbar*(Gs[66] + Hs[36]))*(1 + yss[5]));
	Nxx_sp_s[490]=((-1 + nnus)*Gs[41] + nnus*Gs[42])*(dP2ssp*Gs[73] + dP1ssp*Gs[74]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*((-1 + nnus)*Gs[73] + nnus*Gs[74]);
	Nxx_sp_s[491]=(dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-Gs[37] - pow(E,bbar - xss[1])*ppsir*Hs[17] + Hs[21]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[17]*Hs[33] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-Gs[69] - pow(E,bbar - xss[1])*ppsir*Hs[33] + Hs[37]);
	Nxx_sp_s[492]=pow(E,xss[0])*(-(Pssp*Gs[36]*Gs[68]) - (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(Gs[36] - Hs[16]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(Gs[68] - Hs[32]) + Pssp*Hs[16]*Hs[32]);
	Nxx_sp_s[493]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[65]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[65] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[66] + pow(E,yss[11])*Pssp*Gs[43]*Gs[75] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[18] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[18] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[19] + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[34] + pow(E,yss[11])*Gs[43] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] + pow(E,yss[2])*pbar*(Gs[34] + Hs[20])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[34] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[34] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[34] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[34] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[35] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[35] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[35] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[35] + pow(E,yss[2])*pbar*Pssp*(Gs[34] + Hs[20])*(Gs[66] + Hs[36]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[65]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[66] + pow(E,yss[11])*Gs[75] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[34] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[35] + pow(E,yss[2])*pbar*(Gs[66] + Hs[36]));
	Nxx_sp_s[494]=(Pssp*zbar*(Gs[43] - Hs[19])*Hs[33] + Pssp*zbar*Hs[17]*(Gs[75] - Hs[35]) - Pssp*zbar*(Gs[43] - Hs[19])*(Gs[75] - Hs[35])*xss[1] + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(pow(E,yss[11])*Gs[44] - zbar*Hs[17] + zbar*(Gs[43] - Hs[19])*xss[1]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[11])*Gs[76] - zbar*Hs[33] + zbar*(Gs[75] - Hs[35])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[495]=(-(Pssp*zbar*Hs[19]*Hs[33]) - Pssp*zbar*Hs[17]*Hs[35] - Pssp*(-1 + zbar)*Gs[43]*Gs[75]*xss[1] - Pssp*zbar*Hs[19]*Hs[35]*xss[1] + Pssp*zbar*Gs[75]*(Hs[17] + Hs[19]*xss[1]) - (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(pow(E,yss[11])*Gs[45]) + zbar*Hs[17] - (-1 + zbar)*Gs[43]*xss[1] + zbar*Hs[19]*xss[1]) + Pssp*zbar*Gs[43]*(Hs[33] + Hs[35]*xss[1]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(E,yss[11])*Gs[77]) + zbar*Hs[33] - (-1 + zbar)*Gs[75]*xss[1] + zbar*Hs[35]*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[496]=pow(E,yss[0] - yss[11])*Pssp*Gs[32]*Gs[64] + pow(E,yss[3] - yss[11])*Pssp*Gs[35]*Gs[67] - Pssp*Gs[43]*Gs[75] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[43]*Gs[75])/pow(E,yss[11]) - (Pssp*Gs[75]*(pow(E,yss[0])*Gs[32] + pow(E,yss[3])*Gs[35] - pow(E,yss[11])*Gs[43] + pow(E,yss[11])*ebar*Hs[22]))/pow(E,yss[11]) + ((dP2ssp*Gs[73] + dP1ssp*Gs[74])*(pow(E,yss[0])*Gs[32] + pow(E,yss[3])*Gs[35] - pow(E,yss[0])*Gs[43] - pow(E,yss[3])*Gs[43] - pow(E,yss[11])*ebar*Gs[43] + pow(E,yss[11])*Gs[46] + pow(E,yss[11])*ebar*Hs[22]))/pow(E,yss[11]) + ebar*Pssp*Hs[22]*Hs[38] - (Pssp*Gs[43]*(pow(E,yss[0])*Gs[64] + pow(E,yss[3])*Gs[67] - pow(E,yss[11])*Gs[75] + pow(E,yss[11])*ebar*Hs[38]))/pow(E,yss[11]) + ((dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[0])*Gs[64] + pow(E,yss[3])*Gs[67] - pow(E,yss[0])*Gs[75] - pow(E,yss[3])*Gs[75] - pow(E,yss[11])*ebar*Gs[75] + pow(E,yss[11])*Gs[78] + pow(E,yss[11])*ebar*Hs[38]))/pow(E,yss[11]);
	Nxx_sp_s[497]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[73]*Hs[19]) + Pssp*pow(zbar,rrho)*Gs[73]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[41]*Hs[35] + Pssp*pow(zbar,rrho)*Gs[41]*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[19]*Hs[35]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*Hs[35]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[19]*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*yss[9] + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(bbeta*pow(E,yss[8])*Gs[47] + pow(zbar,rrho)*Gsp[120]*Hs[23]*yss[9] + pow(zbar,rrho)*(-Gs[41] + Gsp[8]*Hs[16]*yss[9] + Gsp[24]*Hs[17]*yss[9] + Gsp[40]*Hs[18]*yss[9] - rrho*rrhoz*Hs[19]*yss[9] + Gsp[56]*Hs[19]*yss[9] + Gsp[72]*Hs[20]*yss[9] + Gsp[88]*Hs[21]*yss[9] + Gsp[104]*Hs[22]*yss[9])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(bbeta*pow(E,yss[8])*Gs[79] + pow(zbar,rrho)*Gsp[120]*Hs[39]*yss[9] + pow(zbar,rrho)*(-Gs[73] + Gsp[8]*Hs[32]*yss[9] + Gsp[24]*Hs[33]*yss[9] + Gsp[40]*Hs[34]*yss[9] - rrho*rrhoz*Hs[35]*yss[9] + Gsp[56]*Hs[35]*yss[9] + Gsp[72]*Hs[36]*yss[9] + Gsp[88]*Hs[37]*yss[9] + Gsp[104]*Hs[38]*yss[9])))/(bbeta*pow(E,yss[8]));
	Nxx_sp_s[498]=(dP2ssp*Gs[73] + dP1ssp*Gs[74])*(rrhoa - Hs[18]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[34];
	Nxx_sp_s[499]=-((dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[19]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[35];
	Nxx_sp_s[500]=-((dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[20]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(rrhop - Hs[36]);
	Nxx_sp_s[501]=-((dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[23]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[39];
	Nxx_sp_s[502]=-((dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[22]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[38];
	Nxx_sp_s[503]=-((dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[21]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[37];
	Nxx_sp_s[504]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[32]*Gs[80]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[33]*Gs[81] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])*(pow(E,yss[0])*Gs[80] - pow(pow(E,yss[1]),oomega)*Gs[81]) - pow(E,yss[8])*Pssp*Gs[40]*Gs[88] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[80] - pow(pow(E,yss[1]),oomega)*Gs[81])*Hs[23] + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])) - pow(E,yss[8])*Gs[40] + Hs[23]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])*Hs[47] + (Pssp*Hs[23]*Hs[47])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[80] - pow(pow(E,yss[1]),oomega)*Gs[81])) - pow(E,yss[8])*Gs[88] + Hs[47]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[505]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[81]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[81] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[82] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[82] - (pbar*pphi*Pssp*Gs[41]*Gs[85])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[37]*Gs[89])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[18] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[18] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[19] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[19] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[42] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[42] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[42] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[42] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[43] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[43] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[43] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[43] + (pbar*pphi*Pssp*Gs[41]*Gs[88]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[40]*Gs[89]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[40]*Gs[85]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[37]*Gs[88]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[40]*Gs[88]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[20]*Hs[44]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[44]*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[20]*(Gs[85]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[89] - Gs[88]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[33]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[34] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[19] - pbar*Hs[20]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[81]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[82] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[42] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[43] - pbar*Hs[44]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[85]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[89] - Gs[88]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[506]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[33]*Gs[81]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[81] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[81] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[82] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[82] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[41]*Gs[85] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[37]*Gs[89] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[18] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[19] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[19] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[42] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[42] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[43] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[43] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[43] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[43] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[41]*Gs[88]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[40]*Gs[89]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[40]*Gs[85]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[37]*Gs[88]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[40]*Gs[88]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[39]*Gs[87]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[87]*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[39]*(Gs[85]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[89] - Gs[88]*yss[9])) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[33]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] - pow(E,yss[7])*pphi*Gs[39]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9]))) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[81]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[81] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[42] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[43] - pow(E,yss[7])*pphi*Gs[87]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[85]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[89] - Gs[88]*yss[9])));
	Nxx_sp_s[507]=-(pow(E,yss[8])*Pssp*Gs[40]*Gs[88]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[85]*Hs[19])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[85]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[37]*Hs[43])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[37]*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[19]*Hs[43]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*Hs[43]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[19]*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*((bbeta*pow(E,yss[8])*Gs[37])/pow(zbar,rrho) - pow(E,yss[8])*Gs[40] + Gs[41] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[19]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*((bbeta*pow(E,yss[8])*Gs[85])/pow(zbar,rrho) - pow(E,yss[8])*Gs[88] + Gs[89] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[43]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[508]=-(kkappa*Pssp*Gs[41]*Gs[86]) + pow(E,yss[8])*Pssp*Gs[40]*Gs[88] - kkappa*Pssp*Gs[38]*Gs[89] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*Hs[40] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[40] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*Hs[40] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*Hs[40] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*Hs[40] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*Hs[40] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])*Hs[40] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[16]*Hs[42] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[18]*Hs[42] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*Hs[42] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*Hs[42] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*Hs[42] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[16]*Hs[43] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[18]*Hs[43] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[19]*Hs[43] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19]*Hs[43])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*Hs[43] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*Hs[43] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*Hs[43])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23]))*Hs[43])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[40]*(Hs[40] + Hs[43]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[16] + Hs[19])*(Gs[88] + Hs[40] + Hs[43]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])*(Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19]*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23]))*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[19]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[40] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[43] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[40] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[43] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47])))/pow(zbar,rrho) - kkappa*Pssp*Gs[38]*Gs[86]*yss[9] + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(pow(E,yss[8])*Gs[40] - kkappa*Gs[41] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[16] + Hs[19]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])))/pow(zbar,rrho) - kkappa*Gs[38]*yss[9]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[8])*Gs[88] - kkappa*Gs[89] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[43])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[40] + Hs[43]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[40] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[43] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47])))/pow(zbar,rrho) - kkappa*Gs[86]*yss[9]);
	Nxx_sp_s[509]=-(Pssp*Gs[38]*Gs[86]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-Gs[38] + iiota*zbar*(Hs[16] + Hs[19])) + iiota*Pssp*zbar*(Hs[16] + Hs[19])*(Hs[40] + Hs[43]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-Gs[86] + iiota*zbar*(Hs[40] + Hs[43]));
	Nxx_sp_s[510]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[33]*Gs[81] - pow(E,yss[7])*Pssp*Gs[39]*Gs[87] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[81] - pow(E,yss[7])*Gs[87]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[33] - pow(E,yss[7])*Gs[39])*(dP2ssp*Gs[89] + dP1ssp*Gs[90]);
	Nxx_sp_s[511]=-(pow(E,yss[0])*Pssp*Gs[32]*Gs[80]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[81] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[81] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[82] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[82] - pow(E,yss[3])*Pssp*Gs[35]*Gs[83] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[18] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[19] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[19] - pphi*Pssp*Gs[85]*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[42] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[42] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[42] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[43] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[43] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[43] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[43] - pow(E,yss[2])*pbar*Pssp*(Gs[34] + Hs[20])*(Gs[82] + Hs[44]) - pphi*Pssp*Gs[37]*(pow(E,yss[1] + yss[7])*(Gs[81] + Gs[87]) + pow(E,yss[2])*pbar*(Gs[82] + Hs[44])) - pow(E,yss[11])*ebar*Pssp*Hs[22]*Hs[46] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[33] + Gs[39])*(Gs[81] + Gs[87])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[34] + Hs[20])*(Gs[82] + Hs[44])*yss[5] - (2*Pssp*zbar*Gs[37]*Gs[85]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[85]*Hs[17])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[37]*Hs[41])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[85]*Hs[19]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[37]*Hs[43]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[19]*Hs[41])/(1 + yss[5]) - (Pssp*zbar*Hs[17]*Hs[43])/(1 + yss[5]) - (Pssp*zbar*Hs[19]*Hs[43]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(pow(E,yss[0])*Gs[32]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[34] - pow(E,yss[3])*Gs[35] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[37] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] - pow(E,yss[2])*pbar*(Gs[34] + Hs[20]) - pow(E,yss[11])*ebar*Hs[22] - pphi*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))*yss[5] + (zbar*Gs[37]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[17])/(1 + yss[5]) - (zbar*Hs[19]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(E,yss[0])*Gs[80]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[81] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[82] - pow(E,yss[3])*Gs[83] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[85] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[43] - pow(E,yss[2])*pbar*(Gs[82] + Hs[44]) - pow(E,yss[11])*ebar*Hs[46] - pphi*(pow(E,yss[1] + yss[7])*(Gs[81] + Gs[87]) + pow(E,yss[2])*pbar*(Gs[82] + Hs[44]))*yss[5] + (zbar*Gs[85]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[41])/(1 + yss[5]) - (zbar*Hs[43]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[512]=pow(E,yss[3])*Pssp*Gs[35]*Gs[83] + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(pow(E,yss[3])*Gs[35] - pow(E,xss[0])*zbar*(Hs[16] + Hs[19])) - pow(E,xss[0])*Pssp*zbar*(Hs[16] + Hs[19])*(Hs[40] + Hs[43]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[16] + Hs[19])*(Hs[40] + Hs[43]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[3])*Gs[83] - pow(E,xss[0])*zbar*(Hs[40] + Hs[43]));
	Nxx_sp_s[513]=-(pphi*Pssp*Gs[85]*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[38] + Hs[16] + Hs[19])*(Gs[86] + Hs[40] + Hs[43]) - pphi*Pssp*Gs[37]*(pow(E,yss[1] + yss[7])*(Gs[81] + Gs[87]) + pow(E,yss[2])*pbar*(Gs[82] + Hs[44])) + (2*Pssp*zbar*Gs[37]*Gs[85]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[85]*Hs[17])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[37]*Hs[41])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[85]*Hs[19]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[37]*Hs[43]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[19]*Hs[41])/(1 + yss[5]) + (Pssp*zbar*Hs[17]*Hs[43])/(1 + yss[5]) + (Pssp*zbar*Hs[19]*Hs[43]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[33] + Gs[39])*(Gs[81] + Gs[87])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[34] + Hs[20])*(Gs[82] + Hs[44])*(1 + yss[5]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[37]) - Gs[42] + pow(E,xss[0])*kkappa*zbar*(Gs[38] + Hs[16] + Hs[19]) - (zbar*Gs[37]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[17])/(1 + yss[5]) + (zbar*Hs[19]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))*(1 + yss[5])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[85]) - Gs[90] + pow(E,xss[0])*kkappa*zbar*(Gs[86] + Hs[40] + Hs[43]) - (zbar*Gs[85]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[41])/(1 + yss[5]) + (zbar*Hs[43]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[81] + Gs[87]) + pow(E,yss[2])*pbar*(Gs[82] + Hs[44]))*(1 + yss[5]));
	Nxx_sp_s[514]=((-1 + nnus)*Gs[41] + nnus*Gs[42])*(dP2ssp*Gs[89] + dP1ssp*Gs[90]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*((-1 + nnus)*Gs[89] + nnus*Gs[90]);
	Nxx_sp_s[515]=(dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-Gs[37] - pow(E,bbar - xss[1])*ppsir*Hs[17] + Hs[21]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[17]*Hs[41] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-Gs[85] - pow(E,bbar - xss[1])*ppsir*Hs[41] + Hs[45]);
	Nxx_sp_s[516]=pow(E,xss[0])*(-(Pssp*Gs[36]*Gs[84]) - (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(Gs[36] - Hs[16]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(Gs[84] - Hs[40]) + Pssp*Hs[16]*Hs[40]);
	Nxx_sp_s[517]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[81]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[81] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[82] + pow(E,yss[11])*Pssp*Gs[43]*Gs[91] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[18] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[18] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[19] + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[34] + pow(E,yss[11])*Gs[43] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] + pow(E,yss[2])*pbar*(Gs[34] + Hs[20])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[42] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[42] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[42] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[42] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[43] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[43] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[43] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[43] + pow(E,yss[2])*pbar*Pssp*(Gs[34] + Hs[20])*(Gs[82] + Hs[44]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[81]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[82] + pow(E,yss[11])*Gs[91] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[42] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[43] + pow(E,yss[2])*pbar*(Gs[82] + Hs[44]));
	Nxx_sp_s[518]=(Pssp*zbar*(Gs[43] - Hs[19])*Hs[41] + Pssp*zbar*Hs[17]*(Gs[91] - Hs[43]) - Pssp*zbar*(Gs[43] - Hs[19])*(Gs[91] - Hs[43])*xss[1] + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(pow(E,yss[11])*Gs[44] - zbar*Hs[17] + zbar*(Gs[43] - Hs[19])*xss[1]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[11])*Gs[92] - zbar*Hs[41] + zbar*(Gs[91] - Hs[43])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[519]=(-(Pssp*zbar*Hs[19]*Hs[41]) - Pssp*zbar*Hs[17]*Hs[43] - Pssp*(-1 + zbar)*Gs[43]*Gs[91]*xss[1] - Pssp*zbar*Hs[19]*Hs[43]*xss[1] + Pssp*zbar*Gs[91]*(Hs[17] + Hs[19]*xss[1]) - (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(pow(E,yss[11])*Gs[45]) + zbar*Hs[17] - (-1 + zbar)*Gs[43]*xss[1] + zbar*Hs[19]*xss[1]) + Pssp*zbar*Gs[43]*(Hs[41] + Hs[43]*xss[1]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(E,yss[11])*Gs[93]) + zbar*Hs[41] - (-1 + zbar)*Gs[91]*xss[1] + zbar*Hs[43]*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[520]=pow(E,yss[0] - yss[11])*Pssp*Gs[32]*Gs[80] + pow(E,yss[3] - yss[11])*Pssp*Gs[35]*Gs[83] - Pssp*Gs[43]*Gs[91] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[43]*Gs[91])/pow(E,yss[11]) - (Pssp*Gs[91]*(pow(E,yss[0])*Gs[32] + pow(E,yss[3])*Gs[35] - pow(E,yss[11])*Gs[43] + pow(E,yss[11])*ebar*Hs[22]))/pow(E,yss[11]) + ((dP2ssp*Gs[89] + dP1ssp*Gs[90])*(pow(E,yss[0])*Gs[32] + pow(E,yss[3])*Gs[35] - pow(E,yss[0])*Gs[43] - pow(E,yss[3])*Gs[43] - pow(E,yss[11])*ebar*Gs[43] + pow(E,yss[11])*Gs[46] + pow(E,yss[11])*ebar*Hs[22]))/pow(E,yss[11]) + ebar*Pssp*Hs[22]*Hs[46] - (Pssp*Gs[43]*(pow(E,yss[0])*Gs[80] + pow(E,yss[3])*Gs[83] - pow(E,yss[11])*Gs[91] + pow(E,yss[11])*ebar*Hs[46]))/pow(E,yss[11]) + ((dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[0])*Gs[80] + pow(E,yss[3])*Gs[83] - pow(E,yss[0])*Gs[91] - pow(E,yss[3])*Gs[91] - pow(E,yss[11])*ebar*Gs[91] + pow(E,yss[11])*Gs[94] + pow(E,yss[11])*ebar*Hs[46]))/pow(E,yss[11]);
	Nxx_sp_s[521]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[89]*Hs[19]) + Pssp*pow(zbar,rrho)*Gs[89]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[41]*Hs[43] + Pssp*pow(zbar,rrho)*Gs[41]*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[19]*Hs[43]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*Hs[43]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[19]*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*yss[9] + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(bbeta*pow(E,yss[8])*Gs[47] + pow(zbar,rrho)*Gsp[120]*Hs[23]*yss[9] + pow(zbar,rrho)*(-Gs[41] + Gsp[8]*Hs[16]*yss[9] + Gsp[24]*Hs[17]*yss[9] + Gsp[40]*Hs[18]*yss[9] - rrho*rrhoz*Hs[19]*yss[9] + Gsp[56]*Hs[19]*yss[9] + Gsp[72]*Hs[20]*yss[9] + Gsp[88]*Hs[21]*yss[9] + Gsp[104]*Hs[22]*yss[9])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(bbeta*pow(E,yss[8])*Gs[95] + pow(zbar,rrho)*Gsp[120]*Hs[47]*yss[9] + pow(zbar,rrho)*(-Gs[89] + Gsp[8]*Hs[40]*yss[9] + Gsp[24]*Hs[41]*yss[9] + Gsp[40]*Hs[42]*yss[9] + (-(rrho*rrhoz) + Gsp[56])*Hs[43]*yss[9] + Gsp[72]*Hs[44]*yss[9] + Gsp[88]*Hs[45]*yss[9] + Gsp[104]*Hs[46]*yss[9])))/(bbeta*pow(E,yss[8]));
	Nxx_sp_s[522]=(dP2ssp*Gs[89] + dP1ssp*Gs[90])*(rrhoa - Hs[18]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[42];
	Nxx_sp_s[523]=-((dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[19]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[43];
	Nxx_sp_s[524]=-((dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[20]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[44];
	Nxx_sp_s[525]=-((dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[23]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[47];
	Nxx_sp_s[526]=-((dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[22]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[46];
	Nxx_sp_s[527]=-((dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[21]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(rrhor - Hs[45]);
	Nxx_sp_s[528]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[32]*Gs[96]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[33]*Gs[97] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])*(pow(E,yss[0])*Gs[96] - pow(pow(E,yss[1]),oomega)*Gs[97]) - pow(E,yss[8])*Pssp*Gs[40]*Gs[104] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[96] - pow(pow(E,yss[1]),oomega)*Gs[97])*Hs[23] + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])) - pow(E,yss[8])*Gs[40] + Hs[23]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])*Hs[55] + (Pssp*Hs[23]*Hs[55])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[96] - pow(pow(E,yss[1]),oomega)*Gs[97])) - pow(E,yss[8])*Gs[104] + Hs[55]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[529]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[97]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[97] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[98] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[98] - (pbar*pphi*Pssp*Gs[41]*Gs[101])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[37]*Gs[105])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[18] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[18] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[19] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[19] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[50] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[50] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[50] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[50] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[51] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[51] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[51] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[51] + (pbar*pphi*Pssp*Gs[41]*Gs[104]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[40]*Gs[105]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[40]*Gs[101]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[37]*Gs[104]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[40]*Gs[104]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[20]*Hs[52]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[52]*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[20]*(Gs[101]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[105] - Gs[104]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[33]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[34] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[19] - pbar*Hs[20]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[97]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[98] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[50] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[51] - pbar*Hs[52]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[101]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[105] - Gs[104]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[530]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[33]*Gs[97]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[97] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[97] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[98] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[98] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[41]*Gs[101] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[37]*Gs[105] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[18] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[19] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[19] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[50] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[50] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[51] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[51] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[51] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[51] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[41]*Gs[104]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[40]*Gs[105]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[40]*Gs[101]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[37]*Gs[104]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[40]*Gs[104]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[39]*Gs[103]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[103]*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[39]*(Gs[101]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[105] - Gs[104]*yss[9])) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[33]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] - pow(E,yss[7])*pphi*Gs[39]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9]))) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[97]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[97] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[50] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[51] - pow(E,yss[7])*pphi*Gs[103]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[101]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[105] - Gs[104]*yss[9])));
	Nxx_sp_s[531]=-(pow(E,yss[8])*Pssp*Gs[40]*Gs[104]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[101]*Hs[19])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[101]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[37]*Hs[51])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[37]*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[19]*Hs[51]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*Hs[51]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[19]*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*((bbeta*pow(E,yss[8])*Gs[37])/pow(zbar,rrho) - pow(E,yss[8])*Gs[40] + Gs[41] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[19]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*((bbeta*pow(E,yss[8])*Gs[101])/pow(zbar,rrho) - pow(E,yss[8])*Gs[104] + Gs[105] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[51]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[532]=-(kkappa*Pssp*Gs[41]*Gs[102]) + pow(E,yss[8])*Pssp*Gs[40]*Gs[104] - kkappa*Pssp*Gs[38]*Gs[105] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*Hs[48] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[48] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*Hs[48] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*Hs[48] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*Hs[48] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*Hs[48] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])*Hs[48] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[16]*Hs[50] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[18]*Hs[50] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*Hs[50] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*Hs[50] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*Hs[50] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[16]*Hs[51] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[18]*Hs[51] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[19]*Hs[51] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19]*Hs[51])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*Hs[51] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*Hs[51] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*Hs[51])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23]))*Hs[51])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[40]*(Hs[48] + Hs[51]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[16] + Hs[19])*(Gs[104] + Hs[48] + Hs[51]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])*(Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19]*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23]))*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[19]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[48] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[51] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[48] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[51] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55])))/pow(zbar,rrho) - kkappa*Pssp*Gs[38]*Gs[102]*yss[9] + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(pow(E,yss[8])*Gs[40] - kkappa*Gs[41] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[16] + Hs[19]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])))/pow(zbar,rrho) - kkappa*Gs[38]*yss[9]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[8])*Gs[104] - kkappa*Gs[105] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[51])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[48] + Hs[51]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[48] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[51] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55])))/pow(zbar,rrho) - kkappa*Gs[102]*yss[9]);
	Nxx_sp_s[533]=-(Pssp*Gs[38]*Gs[102]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-Gs[38] + iiota*zbar*(Hs[16] + Hs[19])) + iiota*Pssp*zbar*(Hs[16] + Hs[19])*(Hs[48] + Hs[51]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-Gs[102] + iiota*zbar*(Hs[48] + Hs[51]));
	Nxx_sp_s[534]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[33]*Gs[97] - pow(E,yss[7])*Pssp*Gs[39]*Gs[103] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[97] - pow(E,yss[7])*Gs[103]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[33] - pow(E,yss[7])*Gs[39])*(dP2ssp*Gs[105] + dP1ssp*Gs[106]);
	Nxx_sp_s[535]=-(pow(E,yss[0])*Pssp*Gs[32]*Gs[96]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[97] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[97] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[98] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[98] - pow(E,yss[3])*Pssp*Gs[35]*Gs[99] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[18] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[19] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[19] - pphi*Pssp*Gs[101]*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[50] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[50] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[50] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[51] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[51] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[51] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[51] - pow(E,yss[2])*pbar*Pssp*(Gs[34] + Hs[20])*(Gs[98] + Hs[52]) - pphi*Pssp*Gs[37]*(pow(E,yss[1] + yss[7])*(Gs[97] + Gs[103]) + pow(E,yss[2])*pbar*(Gs[98] + Hs[52])) - pow(E,yss[11])*ebar*Pssp*Hs[22]*Hs[54] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[33] + Gs[39])*(Gs[97] + Gs[103])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[34] + Hs[20])*(Gs[98] + Hs[52])*yss[5] - (2*Pssp*zbar*Gs[37]*Gs[101]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[101]*Hs[17])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[37]*Hs[49])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[101]*Hs[19]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[37]*Hs[51]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[19]*Hs[49])/(1 + yss[5]) - (Pssp*zbar*Hs[17]*Hs[51])/(1 + yss[5]) - (Pssp*zbar*Hs[19]*Hs[51]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(pow(E,yss[0])*Gs[32]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[34] - pow(E,yss[3])*Gs[35] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[37] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] - pow(E,yss[2])*pbar*(Gs[34] + Hs[20]) - pow(E,yss[11])*ebar*Hs[22] - pphi*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))*yss[5] + (zbar*Gs[37]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[17])/(1 + yss[5]) - (zbar*Hs[19]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(E,yss[0])*Gs[96]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[97] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[98] - pow(E,yss[3])*Gs[99] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[101] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[51] - pow(E,yss[2])*pbar*(Gs[98] + Hs[52]) - pow(E,yss[11])*ebar*Hs[54] - pphi*(pow(E,yss[1] + yss[7])*(Gs[97] + Gs[103]) + pow(E,yss[2])*pbar*(Gs[98] + Hs[52]))*yss[5] + (zbar*Gs[101]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[49])/(1 + yss[5]) - (zbar*Hs[51]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[536]=pow(E,yss[3])*Pssp*Gs[35]*Gs[99] + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(pow(E,yss[3])*Gs[35] - pow(E,xss[0])*zbar*(Hs[16] + Hs[19])) - pow(E,xss[0])*Pssp*zbar*(Hs[16] + Hs[19])*(Hs[48] + Hs[51]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[16] + Hs[19])*(Hs[48] + Hs[51]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[3])*Gs[99] - pow(E,xss[0])*zbar*(Hs[48] + Hs[51]));
	Nxx_sp_s[537]=-(pphi*Pssp*Gs[101]*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[38] + Hs[16] + Hs[19])*(Gs[102] + Hs[48] + Hs[51]) - pphi*Pssp*Gs[37]*(pow(E,yss[1] + yss[7])*(Gs[97] + Gs[103]) + pow(E,yss[2])*pbar*(Gs[98] + Hs[52])) + (2*Pssp*zbar*Gs[37]*Gs[101]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[101]*Hs[17])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[37]*Hs[49])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[101]*Hs[19]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[37]*Hs[51]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[19]*Hs[49])/(1 + yss[5]) + (Pssp*zbar*Hs[17]*Hs[51])/(1 + yss[5]) + (Pssp*zbar*Hs[19]*Hs[51]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[33] + Gs[39])*(Gs[97] + Gs[103])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[34] + Hs[20])*(Gs[98] + Hs[52])*(1 + yss[5]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[37]) - Gs[42] + pow(E,xss[0])*kkappa*zbar*(Gs[38] + Hs[16] + Hs[19]) - (zbar*Gs[37]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[17])/(1 + yss[5]) + (zbar*Hs[19]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))*(1 + yss[5])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[101]) - Gs[106] + pow(E,xss[0])*kkappa*zbar*(Gs[102] + Hs[48] + Hs[51]) - (zbar*Gs[101]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[49])/(1 + yss[5]) + (zbar*Hs[51]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[97] + Gs[103]) + pow(E,yss[2])*pbar*(Gs[98] + Hs[52]))*(1 + yss[5]));
	Nxx_sp_s[538]=((-1 + nnus)*Gs[41] + nnus*Gs[42])*(dP2ssp*Gs[105] + dP1ssp*Gs[106]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*((-1 + nnus)*Gs[105] + nnus*Gs[106]);
	Nxx_sp_s[539]=(dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-Gs[37] - pow(E,bbar - xss[1])*ppsir*Hs[17] + Hs[21]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[17]*Hs[49] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-Gs[101] - pow(E,bbar - xss[1])*ppsir*Hs[49] + Hs[53]);
	Nxx_sp_s[540]=pow(E,xss[0])*(-(Pssp*Gs[36]*Gs[100]) - (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(Gs[36] - Hs[16]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(Gs[100] - Hs[48]) + Pssp*Hs[16]*Hs[48]);
	Nxx_sp_s[541]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[97]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[97] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[98] + pow(E,yss[11])*Pssp*Gs[43]*Gs[107] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[18] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[18] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[19] + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[34] + pow(E,yss[11])*Gs[43] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] + pow(E,yss[2])*pbar*(Gs[34] + Hs[20])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[50] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[50] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[50] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[50] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[51] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[51] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[51] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[51] + pow(E,yss[2])*pbar*Pssp*(Gs[34] + Hs[20])*(Gs[98] + Hs[52]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[97]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[98] + pow(E,yss[11])*Gs[107] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[50] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[51] + pow(E,yss[2])*pbar*(Gs[98] + Hs[52]));
	Nxx_sp_s[542]=(Pssp*zbar*(Gs[43] - Hs[19])*Hs[49] + Pssp*zbar*Hs[17]*(Gs[107] - Hs[51]) - Pssp*zbar*(Gs[43] - Hs[19])*(Gs[107] - Hs[51])*xss[1] + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(pow(E,yss[11])*Gs[44] - zbar*Hs[17] + zbar*(Gs[43] - Hs[19])*xss[1]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[11])*Gs[108] - zbar*Hs[49] + zbar*(Gs[107] - Hs[51])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[543]=(-(Pssp*zbar*Hs[19]*Hs[49]) - Pssp*zbar*Hs[17]*Hs[51] - Pssp*(-1 + zbar)*Gs[43]*Gs[107]*xss[1] - Pssp*zbar*Hs[19]*Hs[51]*xss[1] + Pssp*zbar*Gs[107]*(Hs[17] + Hs[19]*xss[1]) - (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(pow(E,yss[11])*Gs[45]) + zbar*Hs[17] - (-1 + zbar)*Gs[43]*xss[1] + zbar*Hs[19]*xss[1]) + Pssp*zbar*Gs[43]*(Hs[49] + Hs[51]*xss[1]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(E,yss[11])*Gs[109]) + zbar*Hs[49] - (-1 + zbar)*Gs[107]*xss[1] + zbar*Hs[51]*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[544]=pow(E,yss[0] - yss[11])*Pssp*Gs[32]*Gs[96] + pow(E,yss[3] - yss[11])*Pssp*Gs[35]*Gs[99] - Pssp*Gs[43]*Gs[107] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[43]*Gs[107])/pow(E,yss[11]) - (Pssp*Gs[107]*(pow(E,yss[0])*Gs[32] + pow(E,yss[3])*Gs[35] - pow(E,yss[11])*Gs[43] + pow(E,yss[11])*ebar*Hs[22]))/pow(E,yss[11]) + ((dP2ssp*Gs[105] + dP1ssp*Gs[106])*(pow(E,yss[0])*Gs[32] + pow(E,yss[3])*Gs[35] - pow(E,yss[0])*Gs[43] - pow(E,yss[3])*Gs[43] - pow(E,yss[11])*ebar*Gs[43] + pow(E,yss[11])*Gs[46] + pow(E,yss[11])*ebar*Hs[22]))/pow(E,yss[11]) + ebar*Pssp*Hs[22]*Hs[54] - (Pssp*Gs[43]*(pow(E,yss[0])*Gs[96] + pow(E,yss[3])*Gs[99] - pow(E,yss[11])*Gs[107] + pow(E,yss[11])*ebar*Hs[54]))/pow(E,yss[11]) + ((dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[0])*Gs[96] + pow(E,yss[3])*Gs[99] - pow(E,yss[0])*Gs[107] - pow(E,yss[3])*Gs[107] - pow(E,yss[11])*ebar*Gs[107] + pow(E,yss[11])*Gs[110] + pow(E,yss[11])*ebar*Hs[54]))/pow(E,yss[11]);
	Nxx_sp_s[545]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[105]*Hs[19]) + Pssp*pow(zbar,rrho)*Gs[105]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[41]*Hs[51] + Pssp*pow(zbar,rrho)*Gs[41]*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[19]*Hs[51]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*Hs[51]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[19]*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*yss[9] + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(bbeta*pow(E,yss[8])*Gs[47] + pow(zbar,rrho)*Gsp[120]*Hs[23]*yss[9] + pow(zbar,rrho)*(-Gs[41] + Gsp[8]*Hs[16]*yss[9] + Gsp[24]*Hs[17]*yss[9] + Gsp[40]*Hs[18]*yss[9] - rrho*rrhoz*Hs[19]*yss[9] + Gsp[56]*Hs[19]*yss[9] + Gsp[72]*Hs[20]*yss[9] + Gsp[88]*Hs[21]*yss[9] + Gsp[104]*Hs[22]*yss[9])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(bbeta*pow(E,yss[8])*Gs[111] + pow(zbar,rrho)*Gsp[120]*Hs[55]*yss[9] + pow(zbar,rrho)*(-Gs[105] + (-(rrho*rrhoz) + Gsp[56])*Hs[51]*yss[9] + (Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nxx_sp_s[546]=(dP2ssp*Gs[105] + dP1ssp*Gs[106])*(rrhoa - Hs[18]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[50];
	Nxx_sp_s[547]=-((dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[19]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[51];
	Nxx_sp_s[548]=-((dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[20]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[52];
	Nxx_sp_s[549]=-((dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[23]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[55];
	Nxx_sp_s[550]=-((dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[22]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(rrhoe - Hs[54]);
	Nxx_sp_s[551]=-((dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[21]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[53];
	Nxx_sp_s[552]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[32]*Gs[112]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[33]*Gs[113] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])*(pow(E,yss[0])*Gs[112] - pow(pow(E,yss[1]),oomega)*Gs[113]) - pow(E,yss[8])*Pssp*Gs[40]*Gs[120] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[112] - pow(pow(E,yss[1]),oomega)*Gs[113])*Hs[23] + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])) - pow(E,yss[8])*Gs[40] + Hs[23]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])*Hs[63] + (Pssp*Hs[23]*Hs[63])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[112] - pow(pow(E,yss[1]),oomega)*Gs[113])) - pow(E,yss[8])*Gs[120] + Hs[63]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[553]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[113]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[113] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[114] - (pbar*pphi*Pssp*Gs[41]*Gs[117])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[37]*Gs[121])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[18] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[18] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[19] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[19] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[58] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[58] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[58] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[58] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[59] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[59] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[59] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[59] + (pbar*pphi*Pssp*Gs[41]*Gs[120]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[40]*Gs[121]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[40]*Gs[117]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[37]*Gs[120]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[40]*Gs[120]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[20]*Hs[60]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[60]*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[20]*(Gs[117]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[121] - Gs[120]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[33]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[34] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[19] - pbar*Hs[20]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[113]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[58] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[59] - pbar*Hs[60]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[117]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[121] - Gs[120]*yss[9])))/pow(E,yss[8]));
	Nxx_sp_s[554]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[33]*Gs[113]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[113] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[113] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[114] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[114] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[41]*Gs[117] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[37]*Gs[121] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[18] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[19] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[19] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[58] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[58] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[59] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[59] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[59] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[59] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[41]*Gs[120]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[40]*Gs[121]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[40]*Gs[117]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[37]*Gs[120]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[40]*Gs[120]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[39]*Gs[119]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[119]*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[39]*(Gs[117]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[121] - Gs[120]*yss[9])) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[33]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] - pow(E,yss[7])*pphi*Gs[39]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9]))) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[113]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[113] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[58] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[59] - pow(E,yss[7])*pphi*Gs[119]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[117]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[121] - Gs[120]*yss[9])));
	Nxx_sp_s[555]=-(pow(E,yss[8])*Pssp*Gs[40]*Gs[120]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[117]*Hs[19])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[117]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[37]*Hs[59])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[37]*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[19]*Hs[59]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*Hs[59]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[19]*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*((bbeta*pow(E,yss[8])*Gs[37])/pow(zbar,rrho) - pow(E,yss[8])*Gs[40] + Gs[41] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[19]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*((bbeta*pow(E,yss[8])*Gs[117])/pow(zbar,rrho) - pow(E,yss[8])*Gs[120] + Gs[121] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[59]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho));
	Nxx_sp_s[556]=-(kkappa*Pssp*Gs[41]*Gs[118]) + pow(E,yss[8])*Pssp*Gs[40]*Gs[120] - kkappa*Pssp*Gs[38]*Gs[121] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*Hs[56] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[56] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*Hs[56] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*Hs[56] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*Hs[56] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*Hs[56] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])*Hs[56] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[16]*Hs[58] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[18]*Hs[58] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*Hs[58] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*Hs[58] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*Hs[58] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[16]*Hs[59] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[18]*Hs[59] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[19]*Hs[59] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19]*Hs[59])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*Hs[59] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*Hs[59] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*Hs[59])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23]))*Hs[59])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[40]*(Hs[56] + Hs[59]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[16] + Hs[19])*(Gs[120] + Hs[56] + Hs[59]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*((-1 + Gsp[4])*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + rrhoz*Hs[59] + Gsp[52]*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])*((-1 + Gsp[4])*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + rrhoz*Hs[59] + Gsp[52]*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])*(Gsp[4]*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + (rrhoz + Gsp[52])*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19]*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23]))*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[19]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[56] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[59] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + rrhoz*Hs[59] + Gsp[52]*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[56] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[59] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + rrhoz*Hs[59] + Gsp[52]*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63])))/pow(zbar,rrho) - kkappa*Pssp*Gs[38]*Gs[118]*yss[9] + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(pow(E,yss[8])*Gs[40] - kkappa*Gs[41] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[16] + Hs[19]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])))/pow(zbar,rrho) - kkappa*Gs[38]*yss[9]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[8])*Gs[120] - kkappa*Gs[121] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[59])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[56] + Hs[59]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[56] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[59] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + rrhoz*Hs[59] + Gsp[52]*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63])))/pow(zbar,rrho) - kkappa*Gs[118]*yss[9]);
	Nxx_sp_s[557]=-(Pssp*Gs[38]*Gs[118]) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-Gs[38] + iiota*zbar*(Hs[16] + Hs[19])) + iiota*Pssp*zbar*(Hs[16] + Hs[19])*(Hs[56] + Hs[59]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-Gs[118] + iiota*zbar*(Hs[56] + Hs[59]));
	Nxx_sp_s[558]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[33]*Gs[113] - pow(E,yss[7])*Pssp*Gs[39]*Gs[119] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[113] - pow(E,yss[7])*Gs[119]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[33] - pow(E,yss[7])*Gs[39])*(dP2ssp*Gs[121] + dP1ssp*Gs[122]);
	Nxx_sp_s[559]=-(pow(E,yss[0])*Pssp*Gs[32]*Gs[112]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[113] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[113] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[114] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[114] - pow(E,yss[3])*Pssp*Gs[35]*Gs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[18] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[19] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[19] - pphi*Pssp*Gs[117]*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[58] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[58] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[58] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[59] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[59] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[59] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[59] - pow(E,yss[2])*pbar*Pssp*(Gs[34] + Hs[20])*(Gs[114] + Hs[60]) - pphi*Pssp*Gs[37]*(pow(E,yss[1] + yss[7])*(Gs[113] + Gs[119]) + pow(E,yss[2])*pbar*(Gs[114] + Hs[60])) - pow(E,yss[11])*ebar*Pssp*Hs[22]*Hs[62] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[33] + Gs[39])*(Gs[113] + Gs[119])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[34] + Hs[20])*(Gs[114] + Hs[60])*yss[5] - (2*Pssp*zbar*Gs[37]*Gs[117]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[117]*Hs[17])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[37]*Hs[57])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[117]*Hs[19]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[37]*Hs[59]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[19]*Hs[57])/(1 + yss[5]) - (Pssp*zbar*Hs[17]*Hs[59])/(1 + yss[5]) - (Pssp*zbar*Hs[19]*Hs[59]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-(pow(E,yss[0])*Gs[32]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[34] - pow(E,yss[3])*Gs[35] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[37] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] - pow(E,yss[2])*pbar*(Gs[34] + Hs[20]) - pow(E,yss[11])*ebar*Hs[22] - pphi*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))*yss[5] + (zbar*Gs[37]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[17])/(1 + yss[5]) - (zbar*Hs[19]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(E,yss[0])*Gs[112]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[113] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[114] - pow(E,yss[3])*Gs[115] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[117] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[59] - pow(E,yss[2])*pbar*(Gs[114] + Hs[60]) - pow(E,yss[11])*ebar*Hs[62] - pphi*(pow(E,yss[1] + yss[7])*(Gs[113] + Gs[119]) + pow(E,yss[2])*pbar*(Gs[114] + Hs[60]))*yss[5] + (zbar*Gs[117]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[57])/(1 + yss[5]) - (zbar*Hs[59]*xss[1])/(1 + yss[5]));
	Nxx_sp_s[560]=pow(E,yss[3])*Pssp*Gs[35]*Gs[115] + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(pow(E,yss[3])*Gs[35] - pow(E,xss[0])*zbar*(Hs[16] + Hs[19])) - pow(E,xss[0])*Pssp*zbar*(Hs[16] + Hs[19])*(Hs[56] + Hs[59]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[16] + Hs[19])*(Hs[56] + Hs[59]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[3])*Gs[115] - pow(E,xss[0])*zbar*(Hs[56] + Hs[59]));
	Nxx_sp_s[561]=-(pphi*Pssp*Gs[117]*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[38] + Hs[16] + Hs[19])*(Gs[118] + Hs[56] + Hs[59]) - pphi*Pssp*Gs[37]*(pow(E,yss[1] + yss[7])*(Gs[113] + Gs[119]) + pow(E,yss[2])*pbar*(Gs[114] + Hs[60])) + (2*Pssp*zbar*Gs[37]*Gs[117]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[117]*Hs[17])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[37]*Hs[57])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[117]*Hs[19]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[37]*Hs[59]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[19]*Hs[57])/(1 + yss[5]) + (Pssp*zbar*Hs[17]*Hs[59])/(1 + yss[5]) + (Pssp*zbar*Hs[19]*Hs[59]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[33] + Gs[39])*(Gs[113] + Gs[119])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[34] + Hs[20])*(Gs[114] + Hs[60])*(1 + yss[5]) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[37]) - Gs[42] + pow(E,xss[0])*kkappa*zbar*(Gs[38] + Hs[16] + Hs[19]) - (zbar*Gs[37]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[17])/(1 + yss[5]) + (zbar*Hs[19]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))*(1 + yss[5])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[117]) - Gs[122] + pow(E,xss[0])*kkappa*zbar*(Gs[118] + Hs[56] + Hs[59]) - (zbar*Gs[117]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[57])/(1 + yss[5]) + (zbar*Hs[59]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[113] + Gs[119]) + pow(E,yss[2])*pbar*(Gs[114] + Hs[60]))*(1 + yss[5]));
	Nxx_sp_s[562]=((-1 + nnus)*Gs[41] + nnus*Gs[42])*(dP2ssp*Gs[121] + dP1ssp*Gs[122]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*((-1 + nnus)*Gs[121] + nnus*Gs[122]);
	Nxx_sp_s[563]=(dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-Gs[37] - pow(E,bbar - xss[1])*ppsir*Hs[17] + Hs[21]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[17]*Hs[57] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-Gs[117] - pow(E,bbar - xss[1])*ppsir*Hs[57] + Hs[61]);
	Nxx_sp_s[564]=pow(E,xss[0])*(-(Pssp*Gs[36]*Gs[116]) - (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(Gs[36] - Hs[16]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(Gs[116] - Hs[56]) + Pssp*Hs[16]*Hs[56]);
	Nxx_sp_s[565]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[113]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[113] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[114] + pow(E,yss[11])*Pssp*Gs[43]*Gs[123] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[18] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[18] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[19] + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[34] + pow(E,yss[11])*Gs[43] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] + pow(E,yss[2])*pbar*(Gs[34] + Hs[20])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[58] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[58] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[58] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[58] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[59] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[59] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[59] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[59] + pow(E,yss[2])*pbar*Pssp*(Gs[34] + Hs[20])*(Gs[114] + Hs[60]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[113]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[114] + pow(E,yss[11])*Gs[123] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[58] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[59] + pow(E,yss[2])*pbar*(Gs[114] + Hs[60]));
	Nxx_sp_s[566]=(Pssp*zbar*(Gs[43] - Hs[19])*Hs[57] + Pssp*zbar*Hs[17]*(Gs[123] - Hs[59]) - Pssp*zbar*(Gs[43] - Hs[19])*(Gs[123] - Hs[59])*xss[1] + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(pow(E,yss[11])*Gs[44] - zbar*Hs[17] + zbar*(Gs[43] - Hs[19])*xss[1]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[11])*Gs[124] - zbar*Hs[57] + zbar*(Gs[123] - Hs[59])*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[567]=(-(Pssp*zbar*Hs[19]*Hs[57]) - Pssp*zbar*Hs[17]*Hs[59] - Pssp*(-1 + zbar)*Gs[43]*Gs[123]*xss[1] - Pssp*zbar*Hs[19]*Hs[59]*xss[1] + Pssp*zbar*Gs[123]*(Hs[17] + Hs[19]*xss[1]) - (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-(pow(E,yss[11])*Gs[45]) + zbar*Hs[17] - (-1 + zbar)*Gs[43]*xss[1] + zbar*Hs[19]*xss[1]) + Pssp*zbar*Gs[43]*(Hs[57] + Hs[59]*xss[1]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(E,yss[11])*Gs[125]) + zbar*Hs[57] - (-1 + zbar)*Gs[123]*xss[1] + zbar*Hs[59]*xss[1]))/pow(E,yss[11]);
	Nxx_sp_s[568]=pow(E,yss[0] - yss[11])*Pssp*Gs[32]*Gs[112] + pow(E,yss[3] - yss[11])*Pssp*Gs[35]*Gs[115] - Pssp*Gs[43]*Gs[123] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[43]*Gs[123])/pow(E,yss[11]) - (Pssp*Gs[123]*(pow(E,yss[0])*Gs[32] + pow(E,yss[3])*Gs[35] - pow(E,yss[11])*Gs[43] + pow(E,yss[11])*ebar*Hs[22]))/pow(E,yss[11]) + ((dP2ssp*Gs[121] + dP1ssp*Gs[122])*(pow(E,yss[0])*Gs[32] + pow(E,yss[3])*Gs[35] - pow(E,yss[0])*Gs[43] - pow(E,yss[3])*Gs[43] - pow(E,yss[11])*ebar*Gs[43] + pow(E,yss[11])*Gs[46] + pow(E,yss[11])*ebar*Hs[22]))/pow(E,yss[11]) + ebar*Pssp*Hs[22]*Hs[62] - (Pssp*Gs[43]*(pow(E,yss[0])*Gs[112] + pow(E,yss[3])*Gs[115] - pow(E,yss[11])*Gs[123] + pow(E,yss[11])*ebar*Hs[62]))/pow(E,yss[11]) + ((dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[0])*Gs[112] + pow(E,yss[3])*Gs[115] - pow(E,yss[0])*Gs[123] - pow(E,yss[3])*Gs[123] - pow(E,yss[11])*ebar*Gs[123] + pow(E,yss[11])*Gs[126] + pow(E,yss[11])*ebar*Hs[62]))/pow(E,yss[11]);
	Nxx_sp_s[569]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[121]*Hs[19]) + Pssp*pow(zbar,rrho)*Gs[121]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[41]*Hs[59] + Pssp*pow(zbar,rrho)*Gs[41]*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63]) - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[19]*Hs[59]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*Hs[59]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[19]*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*yss[9] + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(bbeta*pow(E,yss[8])*Gs[47] + pow(zbar,rrho)*Gsp[120]*Hs[23]*yss[9] + pow(zbar,rrho)*(-Gs[41] + Gsp[8]*Hs[16]*yss[9] + Gsp[24]*Hs[17]*yss[9] + Gsp[40]*Hs[18]*yss[9] - rrho*rrhoz*Hs[19]*yss[9] + Gsp[56]*Hs[19]*yss[9] + Gsp[72]*Hs[20]*yss[9] + Gsp[88]*Hs[21]*yss[9] + Gsp[104]*Hs[22]*yss[9])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(bbeta*pow(E,yss[8])*Gs[127] + pow(zbar,rrho)*(-Gs[121] + (-(rrho*rrhoz) + Gsp[56])*Hs[59]*yss[9] + (Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nxx_sp_s[570]=(dP2ssp*Gs[121] + dP1ssp*Gs[122])*(rrhoa - Hs[18]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[58];
	Nxx_sp_s[571]=-((dP2ssp*Gs[121] + dP1ssp*Gs[122])*Hs[19]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[59];
	Nxx_sp_s[572]=-((dP2ssp*Gs[121] + dP1ssp*Gs[122])*Hs[20]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[60];
	Nxx_sp_s[573]=-((dP2ssp*Gs[121] + dP1ssp*Gs[122])*Hs[23]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(rrhod - Hs[63]);
	Nxx_sp_s[574]=-((dP2ssp*Gs[121] + dP1ssp*Gs[122])*Hs[22]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[62];
	Nxx_sp_s[575]=-((dP2ssp*Gs[121] + dP1ssp*Gs[122])*Hs[21]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[61];
	Nxx_sp_s[648]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*pow(Gs[48],2)) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*pow(Gs[49],2) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*pow(pow(E,yss[0])*Gs[48] - pow(pow(E,yss[1]),oomega)*Gs[49],2) - pow(E,yss[8])*Pssp*pow(Gs[56],2) - 2*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[48] - pow(pow(E,yss[1]),oomega)*Gs[49])*Hs[31] + (Pssp*pow(Hs[31],2))/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + 2*(dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[48] - pow(pow(E,yss[1]),oomega)*Gs[49])) - pow(E,yss[8])*Gs[56] + Hs[31]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxx_sp_s[649]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Gs[49],2)) + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Gs[50] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*pow(Gs[50],2) - (2*pbar*pphi*Pssp*Gs[53]*Gs[57])/pow(E,yss[8]) - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[26] + 2*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[26] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[26],2) - 2*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[27] + 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[27] - 2*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[26]*Hs[27] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*pow(Hs[27],2) + (2*pbar*pphi*Pssp*Gs[56]*Gs[57]*(1 + yss[5]))/pow(E,yss[8]) + (2*pbar*pphi*Pssp*Gs[53]*Gs[56]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*pow(Gs[56],2)*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar